/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.practiced;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.practiced.AbstractPracticedCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.LinkedHashMap;
import java.util.List;
import org.nuiton.util.PagerBean;

public class PracticedCropCycleTopiaDao
extends AbstractPracticedCropCycleTopiaDao<PracticedCropCycle> {
    protected static final String PRACTICED_SYSTEM_SDC = "practicedSystem.growingSystem";
    protected static final String SDC_ID = "practicedSystem.growingSystem.topiaId";
    protected static final String SDC_NAME = "practicedSystem.growingSystem.name";
    protected static final String PRACTICED_SYSTEM_SDC_GROWING_PLAN = "practicedSystem.growingSystem.growingPlan";
    protected static final String GROWING_PLAN_ID = "practicedSystem.growingSystem.growingPlan.topiaId";
    protected static final String PRACTICED_SYSTEM_SDC_GROWING_PLAN_DOMAIN = "practicedSystem.growingSystem.growingPlan.domain";
    protected static final String DOMAIN_ID = "practicedSystem.growingSystem.growingPlan.domain.topiaId";
    protected static final String DOMAIN_CAMPAIGN = "practicedSystem.growingSystem.growingPlan.domain.campaign";
    protected static final String PRACTICED_SYSTEM_NAME = "practicedSystem.name";
    protected static final String PRACTICED_SYSTEM_CAMPAIGNS = "practicedSystem.campaigns";

    public ResultList<PracticedCropCycle> getFilteredCycles(PracticedCropCycleFilter filter) {
        String className = this.getEntityClass().getName();
        if (filter != null && !Strings.isNullOrEmpty((String)filter.getPracticedCropCycleType())) {
            className = filter.getPracticedCropCycleType();
        }
        String query = "FROM " + className + " pcc";
        query = query + " WHERE 1 = 1";
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query = query + DaoUtils.andAttributeLike("pcc", PRACTICED_SYSTEM_NAME, args, filter.getPracticedSystemName());
            query = query + DaoUtils.andAttributeLike("pcc", SDC_NAME, args, filter.getGrowingSystemName());
            query = query + DaoUtils.andAttributeLike("pcc", PRACTICED_SYSTEM_CAMPAIGNS, args, filter.getPracticedSystemCampaign());
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                query = query + DaoUtils.andAttributeInIfNotEmpty("pcc", DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns());
                query = query + DaoUtils.andAttributeInIfNotEmpty("pcc", DOMAIN_ID, args, navigationContext.getDomains());
                query = query + DaoUtils.andAttributeInIfNotEmpty("pcc", GROWING_PLAN_ID, args, navigationContext.getGrowingPlans());
                query = query + DaoUtils.andAttributeInIfNotEmpty("pcc", SDC_ID, args, navigationContext.getGrowingSystems());
            }
        }
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List cycles = this.find(query + " ORDER BY pcc." + "topiaCreateDate" + " DESC, pcc." + "topiaId", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + query, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)cycles, (PagerBean)pager);
        return result;
    }
}

