/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.performance;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.performance.AbstractPerformanceTopiaDao;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.performance.PerformanceFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.util.PagerBean;

public class PerformanceTopiaDao
extends AbstractPerformanceTopiaDao<Performance> {
    public ResultList<Performance> getFilteredPerformances(PerformanceFilter filter, SecurityContext securityContext) throws TopiaException {
        LinkedHashMap args = Maps.newLinkedHashMap();
        StringBuilder query = new StringBuilder("FROM " + Performance.class.getName() + " P");
        query.append(" WHERE 1 = 1");
        if (filter != null) {
            query.append(DaoUtils.andAttributeEquals("P", "practiced", args, filter.isPracticed()));
            query.append(DaoUtils.andAttributeLike("P", "name", args, filter.getPerformanceName()));
            if (StringUtils.isNotEmpty((CharSequence)filter.getDomainName())) {
                if (StringUtils.isNumeric((CharSequence)filter.getDomainName())) {
                    query.append(" AND EXISTS (FROM " + Domain.class.getName() + " D" + " WHERE D in elements(P." + "domains" + ")" + " AND D." + "campaign" + " = :domainCampaign" + ")");
                    args.put("domainCampaign", Integer.valueOf(filter.getDomainName()));
                } else {
                    query.append(" AND EXISTS (FROM " + Domain.class.getName() + " D" + " WHERE D in elements(P." + "domains" + ")" + " AND " + DaoUtils.getFieldLikeInsensitive("D.name", ":domainName") + ")");
                    args.put("domainName", "%" + filter.getDomainName() + "%");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)filter.getGrowingSystemName())) {
                query.append(" AND EXISTS (FROM " + GrowingSystem.class.getName() + " G" + " WHERE G in elements(P." + "growingSystems" + ")" + " AND " + DaoUtils.getFieldLikeInsensitive("G.name", ":growingSystemName") + ")");
                args.put("growingSystemName", "%" + filter.getGrowingSystemName() + "%");
            }
            if (StringUtils.isNotEmpty((CharSequence)filter.getPlotName())) {
                query.append(" AND EXISTS (FROM " + Plot.class.getName() + " PL" + " WHERE PL in elements(P." + "plots" + ")" + " AND " + DaoUtils.getFieldLikeInsensitive("PL.name", ":plotName") + ")");
                args.put("plotName", "%" + filter.getPlotName() + "%");
            }
            if (StringUtils.isNotEmpty((CharSequence)filter.getZoneName())) {
                query.append(" AND EXISTS (FROM " + Zone.class.getName() + " Z" + " WHERE Z in elements(P." + "zones" + ")" + " AND " + DaoUtils.getFieldLikeInsensitive("Z.name", ":zoneName") + ")");
                args.put("zoneName", "%" + filter.getZoneName() + "%");
            }
        }
        if (!securityContext.isAdmin()) {
            String userId = securityContext.getUserId();
            query.append(DaoUtils.andAttributeEquals("P", "author.topiaId", args, userId));
        }
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        String queryString = query.toString();
        String queryAndOrder = queryString + " ORDER BY " + "P." + "topiaCreateDate";
        List performances = this.find(queryAndOrder, args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + queryString, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)performances, (PagerBean)pager);
        return result;
    }
}

