/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.managementmode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.managementmode.AbstractManagementModeTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.security.ComputedUserPermission;
import fr.inra.agrosyst.api.entities.security.PermissionObjectType;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.util.PagerBean;

public class ManagementModeTopiaDao
extends AbstractManagementModeTopiaDao<ManagementMode> {
    protected static final String PROPERTY_GROWING_SYSTEM_NAME = "growingSystem.name";
    protected static final String PROPERTY_DOMAIN_CAMPAIGN = "growingSystem.growingPlan.domain.campaign";
    protected static final String PROPERTY_DOMAIN_ID = "growingSystem.growingPlan.domain.topiaId";
    protected static final String PROPERTY_DOMAIN_NAME = "growingSystem.growingPlan.domain.name";
    protected static final String PROPERTY_GROWING_PLAN_ID = "growingSystem.growingPlan.topiaId";
    protected static final String PROPERTY_GROWING_PLAN_NAME = "growingSystem.growingPlan.name";
    protected static final String PROPERTY_GROWING_SYSTEM_ID = "growingSystem.topiaId";

    public Pair<Map<GrowingSystem, ManagementModeDto>, PagerBean> getFilteredManagementModeDtos(ManagementModeFilter filter, SecurityContext securityContext) throws TopiaException {
        Object[] result2;
        String growingSystemManagementModeQuery = " FROM " + GrowingSystem.class.getName() + " gs ";
        growingSystemManagementModeQuery = growingSystemManagementModeQuery + " WHERE gs IN (";
        growingSystemManagementModeQuery = growingSystemManagementModeQuery + " SELECT mm.growingSystem FROM " + ManagementMode.class.getName() + " mm";
        growingSystemManagementModeQuery = growingSystemManagementModeQuery + " WHERE 1 = 1 ";
        LinkedHashMap args = Maps.newLinkedHashMap();
        growingSystemManagementModeQuery = this.filtratedQuery(growingSystemManagementModeQuery, args, filter, securityContext);
        growingSystemManagementModeQuery = growingSystemManagementModeQuery + ")";
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List growingSystems = this.find("SELECT DISTINCT gs " + growingSystemManagementModeQuery + " ORDER BY gs." + "name", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + growingSystemManagementModeQuery, args);
        args = Maps.newLinkedHashMap();
        String query = "SELECT mm.growingSystem, mm.topiaId, mm.category FROM " + ManagementMode.class.getName() + " mm";
        query = query + " WHERE 1 = 1 ";
        query = this.filtratedQuery(query, args, filter, securityContext);
        HashSet growingSystemSet = Sets.newHashSet((Iterable)growingSystems);
        query = query + DaoUtils.andAttributeIn("mm", "growingSystem", args, growingSystemSet);
        List results = this.findAll(query + " ORDER BY mm." + PROPERTY_GROWING_SYSTEM_NAME, args);
        LinkedHashMap gsManagmentModeDtos = Maps.newLinkedHashMap();
        if (results != null) {
            for (Object[] result2 : results) {
                GrowingSystem gs = (GrowingSystem)result2[0];
                ManagementModeDto managementModeDto = (ManagementModeDto)gsManagmentModeDtos.get(gs);
                if (managementModeDto == null) {
                    managementModeDto = new ManagementModeDto();
                    gsManagmentModeDtos.put(gs, managementModeDto);
                }
                String mmId = (String)result2[1];
                ManagementModeCategory category = (ManagementModeCategory)result2[2];
                if (category == ManagementModeCategory.PLANNED) {
                    managementModeDto.setPlannedManagementModeId(mmId);
                    continue;
                }
                managementModeDto.setObservedManagementModeId(mmId);
            }
        }
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        result2 = Pair.of((Object)gsManagmentModeDtos, (Object)pager);
        return result2;
    }

    protected String filtratedQuery(String query, Map<String, Object> args, ManagementModeFilter filter, SecurityContext securityContext) {
        if (filter != null) {
            query = query + DaoUtils.andAttributeEquals("mm", "versionNumber", args, filter.getVersion());
            query = query + DaoUtils.andAttributeLike("mm", PROPERTY_GROWING_SYSTEM_NAME, args, filter.getGrowingSystemName());
            query = query + DaoUtils.andAttributeEquals("mm", PROPERTY_DOMAIN_CAMPAIGN, args, filter.getCampaign());
            query = query + DaoUtils.andAttributeEquals("mm", "category", args, filter.getManagementModeCategory());
            query = query + DaoUtils.andAttributeLike("mm", PROPERTY_GROWING_PLAN_NAME, args, filter.getGrowingPlanName());
            query = query + DaoUtils.andAttributeLike("mm", PROPERTY_DOMAIN_NAME, args, filter.getDomainName());
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                query = query + DaoUtils.andAttributeInIfNotEmpty("mm", PROPERTY_DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns());
                if (navigationContext.getNetworksCount() > 0) {
                    Set<String> growingPlanIds = this.networksToGrowingSystems(navigationContext.getNetworks());
                    query = query + DaoUtils.andAttributeIn("mm", "topiaId", args, growingPlanIds);
                }
                query = query + DaoUtils.andAttributeInIfNotEmpty("mm", PROPERTY_DOMAIN_ID, args, navigationContext.getDomains());
                query = query + DaoUtils.andAttributeInIfNotEmpty("mm", PROPERTY_GROWING_PLAN_ID, args, navigationContext.getGrowingPlans());
                query = query + DaoUtils.andAttributeInIfNotEmpty("mm", "topiaId", args, navigationContext.getGrowingSystems());
            }
        }
        if (!securityContext.isAdmin()) {
            query = query + " AND ( mm.growingSystem.code IN (SELECT DISTINCT cup.object FROM " + ComputedUserPermission.class.getName() + " cup" + " WHERE cup." + "userId" + " = :cup_userId" + " AND cup." + "type" + " = :cup_type_code" + ")" + " OR mm." + "growingSystem" + "." + "topiaId" + " IN (" + "SELECT DISTINCT cup." + "object" + " FROM " + ComputedUserPermission.class.getName() + " cup" + " WHERE cup." + "userId" + " = :cup_userId" + " AND cup." + "type" + " = :cup_type_id" + ")" + " )";
            args.put("cup_userId", securityContext.getUserId());
            args.put("cup_type_code", PermissionObjectType.GROWING_SYSTEM_CODE);
            args.put("cup_type_id", PermissionObjectType.GROWING_SYSTEM_ID);
        }
        return query;
    }

    protected Set<String> networksToGrowingSystems(Set<String> networksIds) {
        Set<String> result = this.getProjectionHelper().networksToGrowingSystems(networksIds);
        return result;
    }

    public List<ManagementModeCategory> findManagementModeCategories(String growingSystemId) {
        ArrayList managementModeCategories = Lists.newArrayList();
        String query = "SELECT DISTINCT mm.category FROM " + ManagementMode.class.getName() + " mm";
        query = query + " WHERE 1 = 1";
        LinkedHashMap args = Maps.newLinkedHashMap();
        List results = this.findAll((query = query + DaoUtils.andAttributeLike("mm", PROPERTY_GROWING_SYSTEM_ID, args, growingSystemId)) + " ORDER BY mm." + "category", args);
        if (results != null) {
            for (ManagementModeCategory result : results) {
                managementModeCategories.add(result);
            }
        }
        return managementModeCategories;
    }

    public List<CroppingPlanEntry> getCroppingPlanEntryWithDomainCode(String domainsCode) {
        String query = " FROM " + CroppingPlanEntry.class.getName() + " cpe " + " WHERE cpe." + "domain" + " IN (" + " SELECT d FROM " + Domain.class.getName() + " d " + " WHERE d." + "code" + " = :domainCode )";
        LinkedHashMap args = Maps.newLinkedHashMap();
        args.put("domainCode", domainsCode);
        List allCroppingPlanEntries = this.findAll(query + " ORDER BY cpe." + "code", args);
        HashMap uniqueCroppingPlanEntryCodes = Maps.newHashMap();
        for (CroppingPlanEntry croppingPlanEntry : allCroppingPlanEntries) {
            if (uniqueCroppingPlanEntryCodes.get(croppingPlanEntry.getCode()) != null) continue;
            uniqueCroppingPlanEntryCodes.put(croppingPlanEntry.getCode(), croppingPlanEntry);
        }
        ArrayList result = Lists.newArrayList(uniqueCroppingPlanEntryCodes.values());
        return result;
    }
}

