/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.managementmode;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.managementmode.AbstractDecisionRuleTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.DecisionRuleFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.util.PagerBean;

public class DecisionRuleTopiaDao
extends AbstractDecisionRuleTopiaDao<DecisionRule> {
    public ResultList<DecisionRule> getFilteredDecisionRules(DecisionRuleFilter filter, SecurityContext securityContext) throws TopiaException {
        StringBuilder query = new StringBuilder(" FROM " + DecisionRule.class.getName() + " dr ");
        query.append(" WHERE 1 = 1 ");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeEquals("dr", "versionNumber", args, 1));
        if (filter != null) {
            Set<String> domainCodes;
            query.append(DaoUtils.andAttributeEquals("dr", "active", args, filter.getActive()));
            query.append(DaoUtils.andAttributeLike("dr", "name", args, filter.getDecisionRuleName()));
            query.append(DaoUtils.andAttributeEquals("dr", "interventionType", args, filter.getInterventionType()));
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                if (navigationContext.getCampaignsCount() == 0 && navigationContext.getNetworksCount() == 0 && navigationContext.getDomainsCount() == 0 && navigationContext.getGrowingPlansCount() == 0 && navigationContext.getGrowingSystemsCount() == 0) {
                    domainCodes = this.getProjectionHelper().domainsToDomainCodes(null, true);
                    query.append(DaoUtils.andAttributeIn("dr", "domainCode", args, domainCodes));
                } else {
                    if (navigationContext.getCampaignsCount() > 0 && navigationContext.getNetworksCount() == 0 && navigationContext.getDomainsCount() == 0 && navigationContext.getGrowingPlansCount() == 0 && navigationContext.getGrowingSystemsCount() == 0) {
                        domainCodes = this.getProjectionHelper().campaignsToDomainCodes(navigationContext.getCampaigns(), true);
                        query.append(DaoUtils.andAttributeIn("dr", "domainCode", args, domainCodes));
                    }
                    if (navigationContext.getNetworksCount() > 0) {
                        domainCodes = this.getProjectionHelper().networksToDomainsCode(navigationContext.getNetworks(), true);
                        query.append(DaoUtils.andAttributeIn("dr", "domainCode", args, domainCodes));
                    }
                    if (navigationContext.getDomainsCount() > 0) {
                        domainCodes = this.getProjectionHelper().domainsToDomainCodes(navigationContext.getDomains(), true);
                        query.append(DaoUtils.andAttributeIn("dr", "domainCode", args, domainCodes));
                    }
                    if (navigationContext.getGrowingPlansCount() > 0) {
                        domainCodes = this.getProjectionHelper().growingPlansToDomainCodes(navigationContext.getGrowingPlans(), true);
                        query.append(DaoUtils.andAttributeIn("dr", "domainCode", args, domainCodes));
                    }
                    if (navigationContext.getGrowingSystemsCount() > 0) {
                        domainCodes = this.getProjectionHelper().growingSystemsToDomainCodes(navigationContext.getGrowingSystems(), true);
                        query.append(DaoUtils.andAttributeIn("dr", "domainCode", args, domainCodes));
                    }
                }
            } else {
                domainCodes = this.getProjectionHelper().domainsToDomainCodes(null, true);
                query.append(DaoUtils.andAttributeIn("dr", "domainCode", args, domainCodes));
            }
        }
        SecurityHelper.addDecisionRuleFilter(query, args, securityContext, "dr");
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List decisionRules = this.find(query + " ORDER BY lower (dr." + "name" + "), dr." + "topiaId", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(topiaId) " + query, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)decisionRules, (PagerBean)pager);
        return result;
    }

    protected Set<String> networksToGrowingSystems(Set<String> networksIds) {
        Set<String> result = this.getProjectionHelper().networksToGrowingSystems(networksIds);
        return result;
    }

    public List<DecisionRule> findAllRelatedDecisionRules(String code) {
        String query = " FROM " + this.getEntityClass().getName() + " WHERE " + "code" + " = :code" + " ORDER BY " + "versionNumber" + " ASC";
        List result = this.findAll(query, DaoUtils.asArgsMap("code", code));
        return result;
    }

    public DecisionRule getLastRuleVersion(String code) {
        String query = "FROM " + DecisionRule.class.getName() + " dr";
        query = query + " WHERE 1 = 1";
        query = query + " AND dr.code = :code ";
        String hql = query + " ORDER BY dr." + "versionNumber" + " DESC";
        Map<String, Object> args = DaoUtils.asArgsMap("code", code);
        DecisionRule result = (DecisionRule)this.findFirstOrNull(hql, args);
        return result;
    }
}

