/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.history;

import fr.inra.agrosyst.api.entities.history.AbstractMessageTopiaDao;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.history.MessageFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.nuiton.util.PagerBean;

public class MessageTopiaDao
extends AbstractMessageTopiaDao<Message> {
    public ResultList<Message> getAllMessageByPage(MessageFilter filter) {
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        String query = "FROM " + this.getEntityClass().getName() + " M WHERE 1 = 1 ";
        String orderedQuery = query + " ORDER BY M." + "messageDate" + " DESC";
        List messages = this.find(orderedQuery, new HashMap(), startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + query, new HashMap());
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)messages, (PagerBean)pager);
        return result;
    }

    public List<Message> geAllMessages() {
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " M");
        query.append(" WHERE 1 = 1");
        query.append(" ORDER BY M.messageDate DESC");
        List result = this.findAll(query.toString(), new HashMap());
        return result;
    }

    public List<Message> geMessageFromDate(Date fromDate) {
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " M");
        query.append(" WHERE 1 = 1");
        query.append(" AND M.messageDate > :fromDate");
        query.append(" ORDER BY M.messageDate DESC");
        List result = this.findAll(query.toString(), DaoUtils.asArgsMap("fromDate", fromDate));
        return result;
    }

    public Date getLastMassageDate() {
        String query = "FROM " + this.getEntityClass().getName() + " M WHERE 1 = 1 ";
        String orderedQuery = query + " ORDER BY M." + "messageDate" + " DESC";
        List messages = this.findAll(orderedQuery, new HashMap());
        Date result = null;
        if (messages != null && !messages.isEmpty()) {
            result = ((Message)messages.get(0)).getMessageDate();
        }
        return result;
    }
}

