/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.action.AbstractAbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;

public class AbstractInputTopiaDao
extends AbstractAbstractInputTopiaDao<AbstractInput> {
    protected static final String FIND_INTERVENTION_INPUT_IDS_QUERY = " SELECT    mineralpro0_.topiaId FROM    abstractInput mineralpro0_    CROSS JOIN abstractAction mineralfer1_ WHERE    mineralpro0_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.MineralProductInputImpl'    AND mineralpro0_.mineralFertilizersSpreadingAction = mineralfer1_.topiaId    AND mineralfer1_.%s = ? UNION SELECT    organicpro3_.topiaId FROM    abstractInput organicpro3_    CROSS JOIN abstractAction organicfer4_ WHERE    organicpro3_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.OrganicProductInputImpl'    AND organicpro3_.organicFertilizersSpreadingAction = organicfer4_.topiaId    AND organicfer4_.%s = ? UNION SELECT    seedingpro5_.topiaId FROM    abstractInput seedingpro5_    CROSS JOIN abstractAction seedingact6_ WHERE    seedingpro5_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.SeedingProductInputImpl'    AND seedingpro5_.seedingAction = seedingact6_.topiaId    AND seedingact6_.%s = ? UNION SELECT    biological7_.topiaId FROM    abstractInput biological7_    CROSS JOIN abstractAction biological8_ WHERE    biological7_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.BiologicalProductInputImpl'    AND biological7_.biologicalControlAction = biological8_.topiaId    AND biological8_.%s = ? UNION SELECT    pesticidep9_.topiaId FROM    abstractInput pesticidep9_    CROSS JOIN abstractAction pesticides10_ WHERE    pesticidep9_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.PesticideProductInputImpl'    AND pesticidep9_.pesticidesSpreadingAction = pesticides10_.topiaId    AND pesticides10_.%s = ? UNION SELECT    otherprodu11_.topiaId FROM    abstractInput otherprodu11_    CROSS JOIN abstractAction otheractio12_ WHERE    otherprodu11_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.OtherProductInputImpl'    AND otheractio12_.%s = ?     AND (otherprodu11_.otherAction = otheractio12_.topiaId    OR otherprodu11_.harvestingAction = otheractio12_.topiaId    OR otherprodu11_.maintenancePruningVinesAction = otheractio12_.topiaId    OR otherprodu11_.irrigationAction = otheractio12_.topiaId    OR otherprodu11_.mineralFertilizersSpreadingAction = otheractio12_.topiaId    OR otherprodu11_.organicFertilizersSpreadingAction = otheractio12_.topiaId    OR otherprodu11_.pesticidesSpreadingAction = otheractio12_.topiaId    OR otherprodu11_.biologicalControlAction = otheractio12_.topiaId    OR otherprodu11_.seedingAction = otheractio12_.topiaId)";

    public List<AbstractInput> findAllByEffectiveIntervention(EffectiveIntervention effectiveIntervention) {
        return this.findAllByIntervention("effectiveIntervention", effectiveIntervention);
    }

    public List<AbstractInput> findAllByPracticedIntervention(PracticedIntervention practicedIntervention) {
        List<AbstractInput> orResult = this.findAllByIntervention("practicedIntervention", practicedIntervention);
        return orResult;
    }

    protected List<AbstractInput> findAllByIntervention(String toInterventionProperty, Object intervention) {
        List<String> inputIds = this.getInterventionInputIds(toInterventionProperty, (TopiaEntity)intervention);
        List<AbstractInput> products = this.getInterventionInputs(inputIds);
        return products;
    }

    protected List<AbstractInput> getInterventionInputs(List<String> inputIds) {
        ArrayList products = Lists.newArrayList();
        if (!inputIds.isEmpty()) {
            HashSet uniqueInputIds = Sets.newHashSet(inputIds);
            for (String uniqueInputId : uniqueInputIds) {
                Map<String, Object> args = DaoUtils.asArgsMap();
                StringBuilder query = new StringBuilder("FROM " + AbstractInput.class.getName() + " ai WHERE 1 = 1 ");
                query.append(DaoUtils.andAttributeEquals("ai", "topiaId", args, uniqueInputId));
                List inputs = this.findAll(query.toString(), args);
                products.addAll(inputs);
            }
        }
        return products;
    }

    protected List<String> getInterventionInputIds(final String toInterventionProperty, final TopiaEntity intervention) {
        return this.topiaSqlSupport.findMultipleResult((TopiaSqlQuery)new TopiaSqlQuery<String>(){

            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement(String.format(AbstractInputTopiaDao.FIND_INTERVENTION_INPUT_IDS_QUERY, toInterventionProperty, toInterventionProperty, toInterventionProperty, toInterventionProperty, toInterventionProperty, toInterventionProperty));
                String topiaId = intervention.getTopiaId();
                statement.setString(1, topiaId);
                statement.setString(2, topiaId);
                statement.setString(3, topiaId);
                statement.setString(4, topiaId);
                statement.setString(5, topiaId);
                statement.setString(6, topiaId);
                return statement;
            }

            public String prepareResult(ResultSet resultSet) throws SQLException {
                String topiaid = resultSet.getString(1);
                return topiaid;
            }
        });
    }
}

