/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AbstractZoneTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.util.PagerBean;

public class ZoneTopiaDao
extends AbstractZoneTopiaDao<Zone> {
    protected static final String PROPERTY_PLOT_NAME = "plot.name";
    protected static final String PROPERTY_DOMAIN = "plot.domain";
    protected static final String PROPERTY_DOMAIN_NAME = "plot.domain.name";
    protected static final String PROPERTY_DOMAIN_CAMPAIGN = "plot.domain.campaign";
    protected static final String PROPERTY_GROWING_SYSTEM = "plot.growingSystem";
    private static final Log log = LogFactory.getLog(ZoneTopiaDao.class);

    public ResultList<Zone> getFilteredZones(EffectiveZoneFilter filter, SecurityContext securityContext) throws TopiaException {
        StringBuilder query = new StringBuilder("FROM " + Zone.class.getName() + " z LEFT OUTER JOIN z." + "plot" + " AS pl " + " LEFT OUTER JOIN pl." + "growingSystem" + " gs " + " LEFT OUTER JOIN pl." + "domain" + " domain " + " LEFT OUTER JOIN gs." + "growingPlan" + " gp ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query.append(DaoUtils.andAttributeLike("z", "name", args, filter.getZoneName()));
            query.append(DaoUtils.andAttributeLike("pl", "name", args, filter.getPlotName()));
            query.append(DaoUtils.andAttributeEquals("pl", "active", args, filter.getActive()));
            query.append(DaoUtils.andAttributeLike("domain", "name", args, filter.getDomainName()));
            query.append(DaoUtils.andAttributeLike("gp", "name", args, filter.getGrowingPlanName()));
            query.append(DaoUtils.andAttributeLike("gs", "name", args, filter.getGrowingSystemName()));
            query.append(DaoUtils.andAttributeEquals("domain", "campaign", args, filter.getCampaign()));
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                List domainsIds;
                String hql;
                query.append(DaoUtils.andAttributeInIfNotEmpty("domain", "campaign", args, navigationContext.getCampaigns()));
                if (navigationContext.getNetworksCount() > 0) {
                    Set<String> domainIds = this.networksToDomains(navigationContext.getNetworks());
                    query.append(DaoUtils.andAttributeIn("domain", "topiaId", args, domainIds));
                }
                HashSet domains = Sets.newHashSet((Iterable)navigationContext.getDomains());
                if (!navigationContext.getGrowingSystems().isEmpty()) {
                    hql = "SELECT gs.growingPlan.domain.topiaId FROM " + GrowingSystem.class.getName() + " gs" + " WHERE gs." + "topiaId" + " IN :gsIds";
                    domainsIds = this.findAll(hql, DaoUtils.asArgsMap("gsIds", navigationContext.getGrowingSystems()));
                    domains.addAll(domainsIds);
                }
                if (!navigationContext.getGrowingPlans().isEmpty()) {
                    hql = "SELECT gp.domain.topiaId FROM " + GrowingPlan.class.getName() + " gp" + " WHERE gp." + "topiaId" + " IN :gpIds";
                    domainsIds = this.findAll(hql, DaoUtils.asArgsMap("gpIds", navigationContext.getGrowingPlans()));
                    domains.addAll(domainsIds);
                }
                query.append(DaoUtils.andAttributeInIfNotEmpty("domain", "topiaId", args, domains));
            }
        }
        SecurityHelper.addZoneFilter(query, args, securityContext, "z");
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List zones = this.find("SELECT z " + query + " ORDER BY domain." + "campaign" + " DESC, " + " lower(domain." + "name" + ")," + " lower(gp." + "name" + ") NULLS LAST," + " lower(gs." + "name" + ") NULLS LAST," + " lower(pl." + "name" + ")," + " lower(z." + "name" + ")", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + query, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)zones, (PagerBean)pager);
        return result;
    }

    protected Set<String> networksToDomains(Set<String> networksIds) {
        Set<String> result = this.getProjectionHelper().networksToDomains(networksIds);
        return result;
    }

    public LinkedHashMap<Integer, String> findAllRelatedZones(String code) {
        String query = "SELECT plot.domain.campaign, topiaId FROM " + Zone.class.getName() + " WHERE " + "code" + " = :code" + " ORDER BY " + PROPERTY_DOMAIN_CAMPAIGN + " DESC";
        List zones = this.findAll(query, DaoUtils.asArgsMap("code", code));
        LinkedHashMap<Integer, String> result = DaoUtils.toRelatedMap(zones);
        return result;
    }

    public List<Zone> findZonesWithoutCycle(String zoneId, String domainId) {
        String query = "FROM " + Zone.class.getName() + " z " + "WHERE z." + PROPERTY_DOMAIN + "." + "topiaId" + " =:domainId " + "AND z." + "active" + " = true " + "AND z NOT IN " + "(SELECT epcc." + "zone" + " FROM " + EffectivePerennialCropCycle.class.getName() + " epcc " + " WHERE epcc." + "zone" + "." + PROPERTY_DOMAIN + "." + "topiaId" + " =:domainId " + ")" + "AND z NOT IN " + "(SELECT escc." + "zone" + " FROM " + EffectiveSeasonalCropCycle.class.getName() + " escc " + " WHERE escc." + "zone" + "." + PROPERTY_DOMAIN + "." + "topiaId" + " =:domainId)" + " AND z." + "topiaId" + " != :zoneId";
        LinkedHashMap args = Maps.newLinkedHashMap();
        args.put("domainId", domainId);
        args.put("zoneId", zoneId);
        List res = this.findAll(query, args);
        return res;
    }

    public Map<String, Long> forQuery(Iterable<String> zonesIds, String subQuery) {
        HashMap result = Maps.newHashMap();
        LinkedHashMap args = Maps.newLinkedHashMap();
        HashSet zIds = Sets.newHashSet(zonesIds);
        Preconditions.checkArgument((zIds != null && !zIds.isEmpty() ? 1 : 0) != 0);
        String query = " SELECT z.topiaId, ";
        query = query + "(" + subQuery + ")";
        query = query + " FROM " + Zone.class.getName() + " z  WHERE 1 = 1 ";
        query = query + DaoUtils.andAttributeIn("z", "topiaId", args, zIds);
        List zonesTuples = this.findAll(query, args);
        for (Object[] zoneTuple : zonesTuples) {
            String zoneId = (String)zoneTuple[0];
            Long count = (Long)zoneTuple[1];
            result.put(zoneId, count);
        }
        return result;
    }

    public Map<String, Long> getZonesUsedForPerformances(Iterable<String> zonesIds) {
        String query = "SELECT COUNT(*) FROM " + Performance.class.getName() + " p " + " WHERE z IN ELEMENTS (p." + "zones" + ")";
        Map<String, Long> result = this.forQuery(zonesIds, query);
        return result;
    }

    public Map<String, Long> getZonesUsedForMesurementSessions(Iterable<String> zonesIds) {
        String query = "SELECT COUNT(*) FROM " + MeasurementSession.class.getName() + " ms " + " WHERE ms." + "zone" + " = z";
        Map<String, Long> result = this.forQuery(zonesIds, query);
        return result;
    }

    public Map<String, Long> getZonesUsedForEffectivePerennialCropCycles(Iterable<String> zonesIds) {
        String query = "SELECT COUNT(*) FROM " + EffectivePerennialCropCycle.class.getName() + " epcc " + " WHERE epcc." + "zone" + "= z";
        Map<String, Long> result = this.forQuery(zonesIds, query);
        return result;
    }

    public Map<String, Long> getZonesUsedForEffectiveSeasonalCropCycles(Iterable<String> zonesIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveSeasonalCropCycle.class.getName() + " escc " + " WHERE escc." + "zone" + " = z";
        Map<String, Long> result = this.forQuery(zonesIds, query);
        return result;
    }

    public List<Zone> findZonesFromDomainCode(String domainCode, SecurityContext securityContext) {
        LinkedHashMap args = Maps.newLinkedHashMap();
        StringBuilder query = new StringBuilder(" FROM " + Zone.class.getName() + " z ");
        query.append(" WHERE z.plot.domain.code = :domainCode ");
        args.put("domainCode", domainCode);
        query.append(" AND z.plot.domain.active = TRUE");
        query.append(" AND z.plot.active = TRUE ");
        query.append(" AND z.active = TRUE ");
        query.append(" AND ( z.topiaId");
        query.append("       IN (");
        query.append("            SELECT z1.topiaId FROM " + Zone.class.getName() + " z1 ");
        query.append("            WHERE z1.plot.growingSystem IS NULL ");
        query.append("           )");
        query.append("       OR z.topiaId");
        query.append("       IN (");
        query.append("            SELECT z2.topiaId FROM " + Zone.class.getName() + " z2 ");
        query.append("            WHERE z2.plot.growingSystem.active = TRUE");
        query.append("           )");
        query.append("     )");
        SecurityHelper.addZoneFilter(query, args, securityContext, "z");
        List zones = this.findAll(query + " ORDER BY lower(z." + "name" + "), lower (z." + PROPERTY_PLOT_NAME + "), lower(z." + PROPERTY_DOMAIN_NAME + "), z." + PROPERTY_DOMAIN_CAMPAIGN, args);
        return zones;
    }
}

