/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AbstractPriceTopiaDao;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.services.common.ProductPriceSummary;
import fr.inra.agrosyst.api.services.common.ProductPrices;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.common.CommonService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PriceTopiaDao
extends AbstractPriceTopiaDao<Price> {
    public ProductPrices computePriceIndication(Price filter, Set<Integer> campaigns, String excludeDomainId, String excludePracticedSystemId) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        HashMap args = Maps.newHashMap();
        String queryProjectionStats = "SELECT  count(p.topiaId),  avg  (p.price),  min  (p.price),  max  (p.price)  ";
        String queryProjectionAll = "SELECT p.price";
        String queryFilter = " FROM  " + this.getEntityClass().getName() + " p " + " WHERE p." + "price" + " IS NOT NULL ";
        queryFilter = queryFilter + DaoUtils.andAttributeEquals("p", "type", args, filter.getType());
        queryFilter = queryFilter + DaoUtils.andAttributeEquals("p", "objectId", args, filter.getObjectId());
        queryFilter = queryFilter + DaoUtils.andAttributeEquals("p", "priceUnit", args, filter.getPriceUnit());
        if (!Strings.isNullOrEmpty((String)excludeDomainId)) {
            queryFilter = queryFilter + " AND p.domain IS NOT NULL ";
            queryFilter = queryFilter + DaoUtils.andAttributeNotEquals("p", "domain.topiaId", args, excludeDomainId);
        } else if (!Strings.isNullOrEmpty((String)excludePracticedSystemId)) {
            queryFilter = queryFilter + " AND p.practicedSystem IS NOT NULL ";
            queryFilter = queryFilter + DaoUtils.andAttributeNotEquals("p", "practicedSystem.topiaId", args, excludePracticedSystemId);
        }
        Object[] allCampaignsObjects = (Object[])this.findAnyOrNull(queryProjectionStats + queryFilter, args);
        ProductPriceSummary allCampaignsPricesSummary = this.toPriceSummary(allCampaignsObjects);
        String orderedResult = " ORDER BY p.price ASC ";
        if (allCampaignsPricesSummary.getCountedPrices() > 0L) {
            List allCampaignsPrices = this.findAll(queryProjectionAll + queryFilter + orderedResult, args);
            Double median = DaoUtils.median(allCampaignsPrices);
            allCampaignsPricesSummary.setMedianPrice(median);
        }
        if (!Strings.isNullOrEmpty((String)excludeDomainId)) {
            queryFilter = queryFilter + DaoUtils.andAttributeIn("p", "domain.campaign", args, campaigns);
        } else if (!Strings.isNullOrEmpty((String)excludePracticedSystemId)) {
            queryFilter = queryFilter + DaoUtils.andAttributeEquals("p", "practicedSystem.campaigns", args, CommonService.ARRANGE_CAMPAIGNS_SET.apply(campaigns));
        }
        Object[] currentCampaignsObjects = (Object[])this.findAnyOrNull(queryProjectionStats + queryFilter, args);
        ProductPriceSummary currentCampaignsPricesSummary = this.toPriceSummary(currentCampaignsObjects);
        if (currentCampaignsPricesSummary.getCountedPrices() > 0L) {
            List currentCampaignsCampaignsPrices = this.findAll(queryProjectionAll + queryFilter + orderedResult, args);
            Double median = DaoUtils.median(currentCampaignsCampaignsPrices);
            currentCampaignsPricesSummary.setMedianPrice(median);
        }
        ProductPrices result = new ProductPrices();
        result.setAllCampaignsProductPriceSummary(allCampaignsPricesSummary);
        result.setCurrentCampaignsProductPriceSummary(currentCampaignsPricesSummary);
        result.setCurrentCampaigns((String)CommonService.ARRANGE_CAMPAIGNS_SET.apply(campaigns));
        return result;
    }

    protected ProductPriceSummary toPriceSummary(Object[] objects) {
        ProductPriceSummary result = new ProductPriceSummary();
        Long count = (Long)objects[0];
        result.setCountedPrices(count);
        if (count > 0L) {
            result.setAveragePrice((Double)objects[1]);
            result.setLowerPrice((Double)objects[2]);
            result.setHigherPrice((Double)objects[3]);
        }
        return result;
    }

    public List<Price> getPrices0(String domainTopiaId, String practicedSystemId, List<String> objectIds) {
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " p ");
        query.append(" WHERE 1 = 1");
        HashMap args = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)domainTopiaId)) {
            query.append(DaoUtils.andAttributeLike("p", "domain.topiaId", args, domainTopiaId));
            if (objectIds != null) {
                HashSet objectIds2 = Sets.newHashSet(objectIds);
                query.append(DaoUtils.andAttributeInIfNotEmpty("p", "objectId", args, objectIds2));
            }
        } else if (!Strings.isNullOrEmpty((String)practicedSystemId)) {
            query.append(DaoUtils.andAttributeEquals("p", "practicedSystem.topiaId", args, practicedSystemId));
        }
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public List<Price> getPricesForObjectIdLike(String objectId) {
        HashMap args = Maps.newHashMap();
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " p ");
        query.append(" WHERE 1 = 1");
        query.append(DaoUtils.andAttributeLike("p", "objectId", args, objectId));
        List result = this.findAll(query.toString(), args);
        return result;
    }
}

