/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AbstractPlotTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlotTopiaDao
extends AbstractPlotTopiaDao<Plot> {
    protected static final String PROPERTY_DOMAIN_ID = "domain.topiaId";
    protected static final String PROPERTY_DOMAIN_CAMPAIGN = "domain.campaign";

    public List<Plot> findAllByDomainId(String domainId) {
        List result = this.forProperties(PROPERTY_DOMAIN_ID, domainId, new Object[0]).findAll();
        return result;
    }

    public List<Plot> findAllByDomainOrderByName(Domain domain) {
        StringBuilder query = new StringBuilder(" FROM " + Plot.class.getName() + " p ");
        query.append(" WHERE p.domain = :domain ");
        Map<String, Object> args = DaoUtils.asArgsMap("domain", domain);
        query.append(" ORDER BY p.name");
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public List<Plot> findAllFreePlotInDomain(String domainId) {
        String query = "FROM " + Plot.class.getName() + " P";
        query = query + " WHERE domain.topiaId = :domainId";
        query = query + " AND growingSystem is null";
        List result = this.findAll(query, DaoUtils.asArgsMap("domainId", domainId));
        return result;
    }

    public LinkedHashMap<Integer, String> findAllRelatedPlots(String code) {
        String query = "SELECT domain.campaign, topiaId FROM " + this.getEntityClass().getName() + " WHERE " + "code" + " = :code" + " ORDER BY " + PROPERTY_DOMAIN_CAMPAIGN + " DESC";
        List plots = this.findAll(query, DaoUtils.asArgsMap("code", code));
        LinkedHashMap<Integer, String> result = DaoUtils.toRelatedMap(plots);
        return result;
    }

    public double getDomainPlotTotalArea(String domainId) {
        String query = "SELECT sum(area) FROM " + Plot.class.getName() + " WHERE " + PROPERTY_DOMAIN_ID + " = :domainId" + " AND " + "active" + " = true";
        Double totalArea = (Double)this.findUniqueOrNull(query, DaoUtils.asArgsMap("domainId", domainId));
        Double result = totalArea == null ? 0.0 : totalArea;
        return result;
    }

    public Long countAllGrowingSystemsForPlots(Set<String> plotTopiaIds) {
        Preconditions.checkArgument((plotTopiaIds != null && !plotTopiaIds.isEmpty() ? 1 : 0) != 0);
        StringBuilder query = new StringBuilder("SELECT count(DISTINCT p.growingSystem.topiaId) FROM " + Plot.class.getName() + " p ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeIn("p", "topiaId", args, plotTopiaIds));
        long result = (Long)this.findUnique(query.toString(), args);
        return result;
    }
}

