/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AbstractNetworkTopiaDao;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.nuiton.util.PagerBean;

public class NetworkTopiaDao
extends AbstractNetworkTopiaDao<Network> {
    protected static final String PROPERTY_CAMPAIGN = "name";

    public ResultList<Network> getFilteredNetworks(NetworkFilter filter, List<NetworkManager> managers) {
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " n ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query.append(DaoUtils.andAttributeLike("n", PROPERTY_CAMPAIGN, args, filter.getNetworkName()));
            query.append(DaoUtils.andAttributeEquals("n", "active", args, filter.getActive()));
            if (managers != null) {
                query.append(" AND ( 1=0 ");
                int index = 0;
                for (NetworkManager manager : managers) {
                    String key = "manager" + index++;
                    query.append(String.format(" OR :%s in elements ( %s )", key, "n.managers"));
                    args.put(key, manager);
                }
                query.append(" ) ");
            }
        }
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List networks = this.find(query + " ORDER BY lower (n." + PROPERTY_CAMPAIGN + ")", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + query, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)networks, (PagerBean)pager);
        return result;
    }

    protected Set<String> buildFullParentSet(Set<String> networkIds) {
        HashSet result = Sets.newHashSet();
        if (networkIds != null) {
            for (String networkId : networkIds) {
                this.buildParentSet(result, networkId);
            }
        }
        return result;
    }

    protected void buildParentSet(Set<String> result, String networkId) {
        if (!Strings.isNullOrEmpty((String)networkId) && !result.contains(networkId)) {
            Network network = (Network)this.forTopiaIdEquals(networkId).findUnique();
            result.add(networkId);
            if (network.getParents() != null) {
                for (Network parent : network.getParents()) {
                    this.buildParentSet(result, parent.getTopiaId());
                }
            }
        }
    }

    public LinkedHashMap<String, String> getNameFilteredNetworks(String name, Integer size, Set<String> exclusions, String selfNetworkId, boolean onNetworkEdition) {
        String query = "SELECT n.topiaId, n.name FROM " + this.getEntityClass().getName() + " n" + " WHERE n." + "active" + " = true ";
        LinkedHashMap args = Maps.newLinkedHashMap();
        query = query + DaoUtils.andAttributeLike("n", PROPERTY_CAMPAIGN, args, name);
        Set<String> fullExclusionSet = this.buildFullParentSet(exclusions);
        if (!Strings.isNullOrEmpty((String)selfNetworkId)) {
            fullExclusionSet.add(selfNetworkId);
            Set<Network> children = this.loadNetworksWithDescendantHierarchy(Sets.newHashSet((Object[])new String[]{selfNetworkId}));
            Iterables.addAll(fullExclusionSet, (Iterable)Iterables.transform(children, (Function)Entities.GET_TOPIA_ID));
        }
        if (onNetworkEdition) {
            GrowingSystemTopiaDao growingSystemDAO = (GrowingSystemTopiaDao)this.topiaDaoSupplier.getDao(GrowingSystem.class, GrowingSystemTopiaDao.class);
            Iterable<String> usedByGrowingSystemsNetworks = growingSystemDAO.getAllNetworksUsedByGrowingSystems();
            Iterables.addAll(fullExclusionSet, usedByGrowingSystemsNetworks);
        } else {
            Iterable<String> usedByNetworks = this.getAllNetworksUsedAsParents();
            Iterables.addAll(fullExclusionSet, usedByNetworks);
        }
        query = query + DaoUtils.andAttributeNotIn("n", "topiaId", args, fullExclusionSet);
        int nbResult = size != null ? size : 10;
        String order = " ORDER BY lower (n.name)";
        List networks = this.find(query + order, args, 0, nbResult);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object[] network : networks) {
            String topiaId = (String)network[0];
            String networkName = (String)network[1];
            result.put(topiaId, networkName);
        }
        return result;
    }

    public Set<Network> loadNetworksWithDescendantHierarchy(Set<String> networkIds) {
        HashSet result = Sets.newHashSet();
        for (String networkId : networkIds) {
            Network network = (Network)this.forTopiaIdEquals(networkId).findUnique();
            result.add(network);
        }
        Set<Network> children = this.findNetworkDescendantHierarchyExcluding(result, new HashSet<String>());
        result.addAll(children);
        return result;
    }

    protected Set<Network> findNetworkDescendantHierarchyExcluding(Collection<Network> networks, Set<String> networksToExclude) {
        HashSet children = Sets.newHashSet();
        if (networks != null && !networks.isEmpty()) {
            Preconditions.checkArgument((networksToExclude != null ? 1 : 0) != 0);
            HashSet networksExcluded = Sets.newHashSet(networksToExclude);
            StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " n");
            query.append(" WHERE 1=1");
            LinkedHashMap args = Maps.newLinkedHashMap();
            query.append(" AND ( 1=0 ");
            int index = 0;
            for (Network parent : networks) {
                networksExcluded.add(parent.getTopiaId());
                String key = "parent" + index++;
                query.append(String.format(" OR :%s in elements ( %s )", key, "n.parents"));
                args.put(key, parent);
            }
            query.append(" ) ");
            query.append(DaoUtils.andAttributeNotIn("n", "topiaId", args, networksExcluded));
            List networkList = this.findAll(query.toString(), args);
            if (!networkList.isEmpty()) {
                children.addAll(networkList);
                children.addAll(this.findNetworkDescendantHierarchyExcluding(networkList, networksExcluded));
            }
        }
        return children;
    }

    public Iterable<String> getAllNetworksUsedAsParents() {
        String hql = " SELECT DISTINCT n.parents FROM " + this.getEntityClass().getName() + " n ";
        List networks = this.findAll(hql, DaoUtils.asArgsMap());
        Iterable result = Iterables.transform((Iterable)networks, (Function)Entities.GET_TOPIA_ID);
        return result;
    }

    public Iterable<Network> findAllByNameWithoutCase(String name) {
        String hql = this.newFromClause() + " WHERE UPPER(" + PROPERTY_CAMPAIGN + ") = :name";
        List networks = this.findAll(hql, DaoUtils.asArgsMap(PROPERTY_CAMPAIGN, name.toUpperCase()));
        return networks;
    }
}

