/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AbstractGrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.common.GrowingSystemsIndicator;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.common.ProjectionHelper;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.PagerBean;

public class GrowingSystemTopiaDao
extends AbstractGrowingSystemTopiaDao<GrowingSystem> {
    public static final String PROPERTY_GROWING_PLAN_DOMAIN = "growingPlan.domain";
    public static final String PROPERTY_GROWING_PLAN_DOMAIN_ID = "growingPlan.domain.topiaId";
    public static final String PROPERTY_GROWING_PLAN_ID = "growingPlan.topiaId";
    protected static final String PROPERTY_GROWING_PLAN_TYPE = "growingPlan.type";
    protected static final String PROPERTY_GROWING_PLAN_NAME = "growingPlan.name";
    protected static final String PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN = "growingPlan.domain.campaign";
    protected static final String PROPERTY_GROWING_PLAN_DOMAIN_NAME = "growingPlan.domain.name";

    public ResultList<GrowingSystem> getFilteredGrowingSystems(GrowingSystemFilter filter, SecurityContext securityContext) {
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " gs");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            this.addFilerQuery(filter, query, args);
        }
        SecurityHelper.addGrowingSystemFilter(query, args, securityContext, "gs");
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        String queryString = query.toString();
        String queryAndOrder = queryString + " ORDER BY " + "lower ( gs." + "name" + " )" + ", gs." + PROPERTY_GROWING_PLAN_NAME + ", gs." + PROPERTY_GROWING_PLAN_DOMAIN_NAME + ", gs." + PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN;
        List growingSystems = this.find(queryAndOrder, args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + queryString, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)growingSystems, (PagerBean)pager);
        return result;
    }

    protected void addFilerQuery(GrowingSystemFilter filter, StringBuilder query, Map<String, Object> args) {
        NavigationContext navigationContext;
        query.append(DaoUtils.andAttributeLike("gs", "name", args, filter.getGrowingSystemName()));
        query.append(DaoUtils.andAttributeLike("gs", "dephyNumber", args, filter.getDephyNumber()));
        query.append(DaoUtils.andAttributeEquals("gs", "sector", args, filter.getSector()));
        query.append(DaoUtils.andAttributeLike("gs", PROPERTY_GROWING_PLAN_DOMAIN_NAME, args, filter.getDomainName()));
        query.append(DaoUtils.andAttributeLike("gs", PROPERTY_GROWING_PLAN_NAME, args, filter.getGrowingPlanName()));
        query.append(DaoUtils.andAttributeEquals("gs", "active", args, filter.getActive()));
        query.append(DaoUtils.andAttributeEquals("gs", "validated", args, filter.getValidated()));
        query.append(DaoUtils.andAttributeEquals("gs", PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN, args, filter.getCampaign()));
        if (StringUtils.isNotEmpty((CharSequence)filter.getNetwork())) {
            NetworkTopiaDao networkDAO = (NetworkTopiaDao)this.topiaDaoSupplier.getDao(Network.class, NetworkTopiaDao.class);
            NetworkFilter networkFilter = new NetworkFilter();
            networkFilter.setNetworkName(filter.getNetwork());
            ResultList<Network> networks = networkDAO.getFilteredNetworks(networkFilter, null);
            HashSet networkIds = Sets.newHashSet((Iterable)Collections2.transform((Collection)networks.getElements(), (Function)Entities.GET_TOPIA_ID));
            Set<String> growingSystemIds = this.getProjectionHelper().networksToGrowingSystems(networkIds);
            query.append(DaoUtils.andAttributeIn("gs", "topiaId", args, growingSystemIds));
        }
        if ((navigationContext = filter.getNavigationContext()) != null) {
            this.addNavigationContextQuery(query, args, navigationContext);
        }
    }

    protected void addNavigationContextQuery(StringBuilder query, Map<String, Object> args, NavigationContext navigationContext) {
        query.append(DaoUtils.andAttributeInIfNotEmpty("gs", PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns()));
        if (navigationContext.getNetworksCount() > 0) {
            Set<String> growingSystemIds = this.getProjectionHelper().networksToGrowingSystems(navigationContext.getNetworks());
            query.append(DaoUtils.andAttributeIn("gs", "topiaId", args, growingSystemIds));
        }
        query.append(DaoUtils.andAttributeInIfNotEmpty("gs", PROPERTY_GROWING_PLAN_DOMAIN_ID, args, navigationContext.getDomains()));
        query.append(DaoUtils.andAttributeInIfNotEmpty("gs", PROPERTY_GROWING_PLAN_ID, args, navigationContext.getGrowingPlans()));
        query.append(DaoUtils.andAttributeInIfNotEmpty("gs", "topiaId", args, navigationContext.getGrowingSystems()));
    }

    protected Set<String> networksProjection(Set<String> networkIds, String projection) {
        return this.networksProjection(networkIds, projection, null, null);
    }

    protected Set<String> networksProjection(final Set<String> networkIds, final String projection, final String filterProperty, final Object filterValue) {
        Callable<LinkedHashSet<String>> loader = new Callable<LinkedHashSet<String>>(){

            @Override
            public LinkedHashSet<String> call() throws Exception {
                StringBuilder query = new StringBuilder(String.format("SELECT DISTINCT gs.%s FROM %s gs", projection, GrowingSystemTopiaDao.this.getEntityClass().getName()));
                query.append(" WHERE ( 1 = 0");
                LinkedHashMap args = Maps.newLinkedHashMap();
                NetworkTopiaDao networkDAO = (NetworkTopiaDao)GrowingSystemTopiaDao.this.topiaDaoSupplier.getDao(Network.class, NetworkTopiaDao.class);
                Set<Network> networks = networkDAO.loadNetworksWithDescendantHierarchy(networkIds);
                ProjectionHelper.GET_NETWORK_SUB_QUERY(query, args, networks);
                query.append(")");
                query.append(DaoUtils.andAttributeEquals("gs", filterProperty, args, filterValue));
                List projectedList = GrowingSystemTopiaDao.this.findAll(query.toString(), args);
                LinkedHashSet result = Sets.newLinkedHashSet((Iterable)projectedList);
                return result;
            }
        };
        String key = String.format("%s_%s_%s_%s", networkIds, projection, filterProperty, filterValue);
        Set result = this.getCacheService().get("networksProjection", key, loader);
        return result;
    }

    public LinkedHashMap<Integer, String> findAllRelatedGrowingSystemsByCampaigns(String code) {
        String query = "SELECT growingPlan.domain.campaign, topiaId FROM " + this.getEntityClass().getName() + " WHERE " + "code" + " = :code" + " ORDER BY " + PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN + " DESC";
        List growingSystems = this.findAll(query, DaoUtils.asArgsMap("code", code));
        LinkedHashMap<Integer, String> result = DaoUtils.toRelatedMap(growingSystems);
        return result;
    }

    public LinkedHashMap<Integer, List<String>> findAllDephyRelatedGSCodesGPCodesDomainCodesByCampaigns(String dephy) {
        String query = "SELECT growingPlan.domain.campaign, code, growingPlan.code, growingPlan.domain.code  FROM " + this.getEntityClass().getName() + " WHERE " + "dephyNumber" + " = :dephy" + " ORDER BY " + PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN;
        List growingSystems = this.findAll(query, DaoUtils.asArgsMap("dephy", dephy));
        LinkedHashMap<Integer, List<String>> result = GrowingSystemTopiaDao.getGS_GP_D_CodesByCampaigns(growingSystems);
        return result;
    }

    protected static LinkedHashMap<Integer, List<String>> getGS_GP_D_CodesByCampaigns(List<Object[]> input) {
        LinkedHashMap result = null;
        if (input != null) {
            result = Maps.newLinkedHashMap();
            for (Object[] entry : input) {
                Integer campaign = (Integer)entry[0];
                String growingSystemCode = (String)entry[1];
                String growingPlanCode = (String)entry[2];
                String domainCode = (String)entry[3];
                ArrayList codes = Lists.newArrayList((Object[])new String[]{growingSystemCode, growingPlanCode, domainCode});
                result.put(campaign, codes);
            }
        }
        return result;
    }

    public List<GrowingSystem> findAllByCodeAndCampaign(String code, Set<Integer> campaigns) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        String query = "FROM " + this.getEntityClass().getName() + " gs WHERE 1 = 1";
        LinkedHashMap args = Maps.newLinkedHashMap();
        query = query + DaoUtils.andAttributeEquals("gs", "code", args, code);
        query = query + DaoUtils.andAttributeIn("gs", PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN, args, campaigns);
        List result = this.findAll(query + " ORDER BY gs." + PROPERTY_GROWING_PLAN_DOMAIN_CAMPAIGN + " ASC ", args);
        return result;
    }

    public List<GrowingSystem> findAllActiveWritableByDomain(Domain domain, SecurityContext securityContext) {
        StringBuilder query = new StringBuilder(" FROM " + this.getEntityClass().getName() + " gs WHERE 1 = 1 ");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeEquals("gs", PROPERTY_GROWING_PLAN_DOMAIN, args, domain));
        query.append(DaoUtils.andAttributeEquals("gs", "active", args, true));
        SecurityHelper.addWritableGrowingSystemFilter(query, args, securityContext, "gs");
        query.append(" ORDER BY LOWER ( gs.name ) ");
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public List<GrowingSystem> findAllAvailableForManagementModeDuplication(List<GrowingSystem> growingSystems, GrowingSystem managementModeGrowingSystem) {
        String query = "FROM " + this.getEntityClass().getName() + " gs WHERE 1 = 1";
        LinkedHashMap args = Maps.newLinkedHashMap();
        query = query + DaoUtils.andAttributeEquals("gs", "growingPlan.domain.code", args, managementModeGrowingSystem.getGrowingPlan().getDomain().getCode());
        query = query + DaoUtils.andAttributeEquals("gs", "active", args, true);
        query = query + " AND gs NOT IN (   SELECT    mm.growingSystem   FROM " + ManagementMode.class.getName() + " mm" + " ) AND gs IN (:growingSystems)";
        args.put("growingSystems", growingSystems);
        List result = this.findAll(query, args);
        return result;
    }

    public List<GrowingSystem> findAllAvailableFoPracticedSystemDuplication(GrowingSystemFilter growingSystemFilter, GrowingSystem growingSystem) {
        LinkedHashMap args = Maps.newLinkedHashMap();
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " gs");
        query.append(" WHERE 1 = 1");
        this.addFilerQuery(growingSystemFilter, query, args);
        query.append(DaoUtils.andAttributeEquals("gs", "growingPlan.domain.code", args, growingSystem.getGrowingPlan().getDomain().getCode()));
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public Set<String> getAllGrowingSystemCodes() {
        String query = "SELECT DISTINCT code FROM " + this.getEntityClass().getName();
        List list = this.findAll(query, DaoUtils.asArgsMap());
        HashSet result = Sets.newHashSet((Iterable)list);
        return result;
    }

    public void validateGrowingSystem(String growingSystemId, Date now) {
        Map<String, Object> args = DaoUtils.asArgsMap("growingSystemId", growingSystemId, "now", now);
        this.topiaJpaSupport.execute("UPDATE " + this.getEntityClass().getName() + " gs" + " SET gs.validated=true, gs.validationDate=:now, gs.updateDate=:now" + " WHERE gs." + "topiaId" + "=:growingSystemId", args);
    }

    public Iterable<String> getAllNetworksUsedByGrowingSystems() {
        String hql = " SELECT DISTINCT gs. networks FROM " + this.getEntityClass().getName() + " gs ";
        List networks = this.findAll(hql, DaoUtils.asArgsMap());
        Iterable result = Iterables.transform((Iterable)networks, (Function)Entities.GET_TOPIA_ID);
        return result;
    }

    public List<GrowingSystem> getGrowingSystemsForManagementMode(NavigationContext navigationContext, SecurityContext securityContext) {
        LinkedHashMap args = Maps.newLinkedHashMap();
        StringBuilder query = new StringBuilder(" FROM " + GrowingSystem.class.getName() + " gs ");
        query.append(" WHERE gs NOT IN (   SELECT    mm1.growingSystem   FROM " + ManagementMode.class.getName() + " mm1," + ManagementMode.class.getName() + " mm2 " + "   WHERE mm1." + "category" + " = :prevu " + "   AND mm2." + "category" + " = :constate " + "   AND mm1." + "growingSystem" + " = mm2." + "growingSystem" + " ) AND gs." + "active" + " = true ");
        args.put("prevu", ManagementModeCategory.PLANNED);
        args.put("constate", ManagementModeCategory.OBSERVED);
        this.addNavigationContextQuery(query, args, navigationContext);
        SecurityHelper.addWritableGrowingSystemFilter(query, args, securityContext, "gs");
        List result = this.findAll(query + " ORDER BY gs." + "name", args);
        return result;
    }

    protected Map<Object, Long> networksProjection(final Set<String> networkIds, final String projection, final String filterProperty, final Object filterValue, final String groupByProperty) {
        Callable<LinkedHashMap<Object, Long>> loader = new Callable<LinkedHashMap<Object, Long>>(){

            @Override
            public LinkedHashMap<Object, Long> call() throws Exception {
                StringBuilder query = new StringBuilder(String.format("SELECT gs.%s, COUNT (gs.%s) FROM %s gs", groupByProperty, projection, GrowingSystemTopiaDao.this.getEntityClass().getName()));
                query.append(" WHERE ( 1 = 0");
                LinkedHashMap args = Maps.newLinkedHashMap();
                boolean index = false;
                NetworkTopiaDao networkDAO = (NetworkTopiaDao)GrowingSystemTopiaDao.this.topiaDaoSupplier.getDao(Network.class, NetworkTopiaDao.class);
                Set<Network> networks = networkDAO.loadNetworksWithDescendantHierarchy(networkIds);
                ProjectionHelper.GET_NETWORK_SUB_QUERY(query, args, networks);
                query.append(")");
                query.append(DaoUtils.andAttributeEquals("gs", filterProperty, args, filterValue));
                query.append(String.format(" GROUP BY gs.%s ", groupByProperty));
                List projectedList = GrowingSystemTopiaDao.this.findAll(query.toString(), args);
                LinkedHashMap result = Maps.newLinkedHashMap();
                for (Object[] objects : projectedList) {
                    result.put(objects[0], (Long)objects[1]);
                }
                return result;
            }
        };
        String key = String.format("%s_%s_%s_%s_%s", networkIds, projection, filterProperty, filterValue, groupByProperty);
        Map result = this.getCacheService().get("networksProjection", key, loader);
        return result;
    }

    protected GrowingSystemsIndicator getIndicator(List<GrowingSystemsIndicator> indicators, Object o) {
        TypeDEPHY expectedDephy = null;
        if (o instanceof TypeDEPHY) {
            expectedDephy = (TypeDEPHY)o;
        }
        Sector expectedSector = null;
        if (o instanceof Sector) {
            expectedSector = (Sector)o;
        }
        for (GrowingSystemsIndicator indicator : indicators) {
            if (!Objects.equal((Object)indicator.getSector(), (Object)expectedSector) || !Objects.equal((Object)indicator.getTypeDephy(), (Object)expectedDephy)) continue;
            return indicator;
        }
        GrowingSystemsIndicator result = expectedDephy != null ? new GrowingSystemsIndicator(expectedDephy) : (expectedSector != null ? new GrowingSystemsIndicator(expectedSector) : new GrowingSystemsIndicator());
        indicators.add(result);
        return result;
    }

    public List<GrowingSystemsIndicator> networksToGrowingSystemIndicators(Set<String> networkIds) {
        GrowingSystemsIndicator indicator;
        Object key;
        ArrayList result = Lists.newArrayList();
        GrowingSystemsIndicator gsIndicator = new GrowingSystemsIndicator();
        gsIndicator.setCount((long)this.getProjectionHelper().networksToGrowingSystems(networkIds).size());
        gsIndicator.setActive((long)this.networksProjection(networkIds, "topiaId", "active", true).size());
        gsIndicator.setValidated((long)this.networksProjection(networkIds, "topiaId", "validated", true).size());
        result.add(gsIndicator);
        Map<Object, Long> map = this.networksProjection(networkIds, "topiaId", null, null, "sector");
        for (Map.Entry<Object, Long> entry : map.entrySet()) {
            key = entry.getKey();
            indicator = this.getIndicator(result, key);
            indicator.setCount(entry.getValue().longValue());
        }
        map = this.networksProjection(networkIds, "topiaId", "active", true, "sector");
        for (Map.Entry<Object, Long> entry : map.entrySet()) {
            key = entry.getKey();
            indicator = this.getIndicator(result, key);
            indicator.setActive(entry.getValue().longValue());
        }
        map = this.networksProjection(networkIds, "topiaId", "validated", true, "sector");
        for (Map.Entry<Object, Long> entry : map.entrySet()) {
            key = entry.getKey();
            indicator = this.getIndicator(result, key);
            indicator.setValidated(entry.getValue().longValue());
        }
        map = this.networksProjection(networkIds, "topiaId", null, null, PROPERTY_GROWING_PLAN_TYPE);
        for (Map.Entry<Object, Long> entry : map.entrySet()) {
            key = entry.getKey();
            indicator = this.getIndicator(result, key);
            indicator.setCount(entry.getValue().longValue());
        }
        map = this.networksProjection(networkIds, "topiaId", "active", true, PROPERTY_GROWING_PLAN_TYPE);
        for (Map.Entry<Object, Long> entry : map.entrySet()) {
            key = entry.getKey();
            indicator = this.getIndicator(result, key);
            indicator.setActive(entry.getValue().longValue());
        }
        map = this.networksProjection(networkIds, "topiaId", "validated", true, PROPERTY_GROWING_PLAN_TYPE);
        for (Map.Entry<Object, Long> entry : map.entrySet()) {
            key = entry.getKey();
            indicator = this.getIndicator(result, key);
            indicator.setValidated(entry.getValue().longValue());
        }
        return result;
    }

    public List<Integer> findCampaigns(String growingSystemCode) {
        Map<String, Object> args = DaoUtils.asArgsMap();
        String hql = " SELECT DISTINCT gs.growingPlan.domain.campaign FROM " + this.getEntityClass().getName() + " gs " + " WHERE 1=1 ";
        hql = hql + DaoUtils.andAttributeEquals("gs", "code", args, growingSystemCode);
        hql = hql + " ORDER BY gs.growingPlan.domain.campaign ASC ";
        List result = this.findAll(hql, args);
        return result;
    }
}

