/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AbstractGrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.util.PagerBean;

public class GrowingPlanTopiaDao
extends AbstractGrowingPlanTopiaDao<GrowingPlan> {
    protected static final String PROPERTY_DOMAIN_NAME = "domain.name";
    protected static final String PROPERTY_DOMAIN_CAMPAIGN = "domain.campaign";
    protected static final String PROPERTY_DOMAIN_ID = "domain.topiaId";

    public ResultList<GrowingPlan> getFilteredGrowingPlans(GrowingPlanFilter filter, SecurityContext securityContext) throws TopiaException {
        StringBuilder query = new StringBuilder("FROM " + GrowingPlan.class.getName() + " gp ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query.append(DaoUtils.andAttributeLike("gp", "name", args, filter.getGrowingPlanName()));
            query.append(DaoUtils.andAttributeEquals("gp", "active", args, filter.getActive()));
            query.append(DaoUtils.andAttributeEquals("gp", "type", args, filter.getTypeDephy()));
            query.append(DaoUtils.andAttributeLike("gp", PROPERTY_DOMAIN_NAME, args, filter.getDomainName()));
            query.append(DaoUtils.andAttributeEquals("gp", PROPERTY_DOMAIN_CAMPAIGN, args, filter.getCampaign()));
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                Set ncCampaigns = navigationContext.getCampaigns();
                query.append(DaoUtils.andAttributeInIfNotEmpty("gp", PROPERTY_DOMAIN_CAMPAIGN, args, ncCampaigns));
                if (navigationContext.getNetworksCount() > 0) {
                    Set<String> growingPlanIds = this.networksToGrowingPlans(navigationContext.getNetworks());
                    query.append(DaoUtils.andAttributeIn("gp", "topiaId", args, growingPlanIds));
                }
                Set ncDomains = navigationContext.getDomains();
                query.append(DaoUtils.andAttributeInIfNotEmpty("gp", PROPERTY_DOMAIN_ID, args, ncDomains));
                HashSet growingPlans = Sets.newHashSet((Iterable)navigationContext.getGrowingPlans());
                if (!navigationContext.getGrowingSystems().isEmpty()) {
                    String hql = "SELECT gs.growingPlan.topiaId FROM " + GrowingSystem.class.getName() + " gs" + " WHERE gs." + "topiaId" + " IN :gsIds";
                    List growingPlansIds = this.findAll(hql, DaoUtils.asArgsMap("gsIds", navigationContext.getGrowingSystems()));
                    growingPlans.addAll(growingPlansIds);
                }
                query.append(DaoUtils.andAttributeInIfNotEmpty("gp", "topiaId", args, growingPlans));
            }
        }
        SecurityHelper.addGrowingPlanFilter(query, args, securityContext, "gp");
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        String queryString = query.toString();
        String queryAndOrder = queryString + " ORDER BY " + "lower (gp." + "name" + ")" + ", gp." + PROPERTY_DOMAIN_NAME + "" + ", gp." + PROPERTY_DOMAIN_CAMPAIGN;
        List growingPlans = this.find(queryAndOrder, args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + queryString, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)growingPlans, (PagerBean)pager);
        return result;
    }

    protected Set<String> networksToGrowingPlans(Set<String> networksIds) {
        Set<String> result = this.getProjectionHelper().networksToGrowingPlans(networksIds);
        return result;
    }

    public LinkedHashSet<String> domainsToGrowingPlansCode(Set<String> domainCodes) {
        Preconditions.checkArgument((domainCodes != null && !domainCodes.isEmpty() ? 1 : 0) != 0);
        String domainCodeProperty = "domain.code";
        String query = String.format("SELECT DISTINCT gp.%s FROM %s gp", "code", this.getEntityClass().getName());
        query = query + " WHERE 1 = 1";
        LinkedHashMap args = Maps.newLinkedHashMap();
        query = domainCodes.size() == 1 ? query + DaoUtils.andAttributeEquals("gp", domainCodeProperty, args, domainCodes.iterator().next()) : query + DaoUtils.andAttributeIn("gp", domainCodeProperty, args, domainCodes);
        List growingPlanCodes = this.findAll(query, args);
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)growingPlanCodes);
        return result;
    }

    public LinkedHashMap<Integer, String> findAllRelatedGrowingPlans(String code) {
        String query = "SELECT domain.campaign, topiaId FROM " + this.getEntityClass().getName() + " WHERE " + "code" + " = :code" + " ORDER BY " + PROPERTY_DOMAIN_CAMPAIGN + " DESC";
        List growingPlans = this.findAll(query, DaoUtils.asArgsMap("code", code));
        LinkedHashMap<Integer, String> result = DaoUtils.toRelatedMap(growingPlans);
        return result;
    }

    public Set<String> getAllGrowingPlanCodes() {
        String query = "SELECT DISTINCT code FROM " + this.getEntityClass().getName();
        List list = this.findAll(query, DaoUtils.asArgsMap());
        HashSet result = Sets.newHashSet((Iterable)list);
        return result;
    }

    public void validateGrowingPlan(String growingPlanId, Date now) {
        Map<String, Object> args = DaoUtils.asArgsMap("growingPlanId", growingPlanId, "now", now);
        this.topiaJpaSupport.execute("UPDATE " + this.getEntityClass().getName() + " gp" + " SET gp.validated=true, gp.validationDate=:now, gp.updateDate=:now" + " WHERE gp." + "topiaId" + "=:growingPlanId", args);
    }
}

