/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AbstractDomainTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.WeatherStation;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.util.PagerBean;

public class DomainTopiaDao
extends AbstractDomainTopiaDao<Domain> {
    protected static final String PROPERTY_LOCATION_DEPARTEMENT = "location.departement";
    protected static final String PRACTICED_NODE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS = "practicedSeasonalCropCycle.practicedSystem.campaigns";
    private static final Log log = LogFactory.getLog(DomainTopiaDao.class);

    public ResultList<Domain> getFilteredDomains(DomainFilter filter, SecurityContext securityContext) throws TopiaException {
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " D");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query.append(DaoUtils.andAttributeLike("D", "name", args, filter.getDomainName()));
            query.append(DaoUtils.andAttributeEquals("D", "active", args, filter.getActive()));
            query.append(DaoUtils.andAttributeEquals("D", "type", args, filter.getType()));
            query.append(DaoUtils.andAttributeLike("D", "mainContact", args, filter.getMainContact()));
            query.append(DaoUtils.andAttributeLike("D", PROPERTY_LOCATION_DEPARTEMENT, args, filter.getDepartement()));
            query.append(DaoUtils.andAttributeEquals("D", "campaign", args, filter.getCampaign()));
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                List domainsIds;
                String hql;
                Set ncCampaigns = navigationContext.getCampaigns();
                query.append(DaoUtils.andAttributeInIfNotEmpty("D", "campaign", args, ncCampaigns));
                if (navigationContext.getNetworksCount() > 0) {
                    Set<String> domainIds = this.networksToDomains(navigationContext.getNetworks());
                    query.append(DaoUtils.andAttributeIn("D", "topiaId", args, domainIds));
                }
                HashSet domains = Sets.newHashSet((Iterable)navigationContext.getDomains());
                if (!navigationContext.getGrowingSystems().isEmpty()) {
                    hql = "SELECT gs.growingPlan.domain.topiaId FROM " + GrowingSystem.class.getName() + " gs" + " WHERE gs." + "topiaId" + " IN :gsIds";
                    domainsIds = this.findAll(hql, DaoUtils.asArgsMap("gsIds", navigationContext.getGrowingSystems()));
                    domains.addAll(domainsIds);
                }
                if (!navigationContext.getGrowingPlans().isEmpty()) {
                    hql = "SELECT gp.domain.topiaId FROM " + GrowingPlan.class.getName() + " gp" + " WHERE gp." + "topiaId" + " IN :gpIds";
                    domainsIds = this.findAll(hql, DaoUtils.asArgsMap("gpIds", navigationContext.getGrowingPlans()));
                    domains.addAll(domainsIds);
                }
                query.append(DaoUtils.andAttributeInIfNotEmpty("D", "topiaId", args, domains));
            }
        }
        SecurityHelper.addDomainFilter(query, args, securityContext, "D");
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        String queryString = query.toString();
        String queryAndOrder = queryString + " ORDER BY " + "lower (D." + "name" + ")" + ", D." + "campaign";
        List domains = this.find(queryAndOrder, args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + queryString, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)domains, (PagerBean)pager);
        return result;
    }

    protected Set<String> networksToDomains(Set<String> networksIds) {
        Set<String> result = this.getProjectionHelper().networksToDomains(networksIds);
        return result;
    }

    public LinkedHashMap<Integer, String> findAllRelatedDomains(String code) {
        String query = "SELECT campaign, topiaId FROM " + this.getEntityClass().getName() + " WHERE " + "code" + " = :code" + " ORDER BY " + "campaign" + " DESC";
        List domains = this.findAll(query, DaoUtils.asArgsMap("code", code));
        LinkedHashMap<Integer, String> result = DaoUtils.toRelatedMap(domains);
        return result;
    }

    public long countDomainWithName(String domainName) {
        String query = "SELECT count(*) FROM " + this.getEntityClass().getName() + " WHERE lower(" + "name" + ") = lower(:" + "name" + ")";
        Number result = (Number)this.findUnique(query, DaoUtils.asArgsMap("name", domainName));
        return result.longValue();
    }

    public List<Integer> getAllCampaigns() {
        String query = "SELECT DISTINCT campaign FROM " + this.getEntityClass().getName() + " ORDER BY " + "campaign" + " ASC";
        List result = this.findAll(query, DaoUtils.asArgsMap());
        return result;
    }

    public Set<String> getAllDomainCodes() {
        String query = "SELECT DISTINCT code FROM " + this.getEntityClass().getName();
        List list = this.findAll(query, DaoUtils.asArgsMap());
        HashSet result = Sets.newHashSet((Iterable)list);
        return result;
    }

    public void validateDomain(String domainId, Date now) {
        Map<String, Object> args = DaoUtils.asArgsMap("domainId", domainId, "now", now);
        this.topiaJpaSupport.execute("UPDATE " + this.getEntityClass().getName() + " d" + " SET d.validated=true, d.validationDate=:now, d.updateDate=:now" + " WHERE d." + "topiaId" + "=:domainId", args);
        Domain domain = (Domain)this.forTopiaIdEquals(domainId).findUnique();
        args = DaoUtils.asArgsMap("domain", domain);
        this.topiaJpaSupport.execute("UPDATE " + CroppingPlanEntry.class.getName() + " cpe" + " SET cpe." + "validated" + "=true" + " WHERE cpe." + "topiaId" + " IN (" + "   SELECT sub." + "topiaId" + " FROM " + CroppingPlanEntry.class.getName() + " sub" + "   WHERE sub." + "domain" + "=:domain" + " )", args);
        args = DaoUtils.asArgsMap("domain", domain);
        this.topiaJpaSupport.execute("UPDATE " + CroppingPlanSpecies.class.getName() + " cps" + " SET cps." + "validated" + "=true" + " WHERE cps." + "topiaId" + " IN (" + "   SELECT sub." + "topiaId" + " FROM " + CroppingPlanSpecies.class.getName() + " sub" + "   WHERE sub." + "croppingPlanEntry" + "." + "domain" + "=:domain" + " )", args);
        args = DaoUtils.asArgsMap("domain", domain);
        this.topiaJpaSupport.execute("UPDATE " + Ground.class.getName() + " s" + " SET s." + "validated" + "=true" + " WHERE s." + "topiaId" + " IN ( " + "   SELECT sub." + "topiaId" + " FROM " + Ground.class.getName() + " sub" + "   WHERE sub." + "domain" + "=:domain" + " )", args);
        args = DaoUtils.asArgsMap("domain", domain);
        this.topiaJpaSupport.execute("UPDATE " + GeoPoint.class.getName() + " gd" + " SET gd." + "validated" + "=true" + " WHERE gd." + "topiaId" + " IN ( " + "   SELECT sub." + "topiaId" + " FROM " + GeoPoint.class.getName() + " sub" + "   WHERE sub." + "domain" + "=:domain" + " )", args);
        Collection weatherStations = domain.getWeatherStations();
        if (CollectionUtils.isNotEmpty((Collection)weatherStations)) {
            args = DaoUtils.asArgsMap("weatherStationIds", Collections2.transform((Collection)weatherStations, (Function)Entities.GET_TOPIA_ID));
            this.topiaJpaSupport.execute("UPDATE " + WeatherStation.class.getName() + " ws" + " SET ws." + "validated" + "=true" + " WHERE ws." + "topiaId" + " IN ( :weatherStationIds )", args);
        }
        args = DaoUtils.asArgsMap("domain", domain);
        this.topiaJpaSupport.execute("UPDATE " + Equipment.class.getName() + " m" + " SET m." + "validated" + "=true" + " WHERE m." + "topiaId" + " IN ( " + "   SELECT sub." + "topiaId" + " FROM " + Equipment.class.getName() + " sub" + "   WHERE sub." + "domain" + "=:domain" + " )", args);
        args = DaoUtils.asArgsMap("domain", domain);
        this.topiaJpaSupport.execute("UPDATE " + ToolsCoupling.class.getName() + " tc" + " SET tc." + "validated" + "=true" + " WHERE tc." + "topiaId" + " IN ( " + "   SELECT sub." + "topiaId" + " FROM " + ToolsCoupling.class.getName() + " sub" + "   WHERE sub." + "domain" + "=:domain" + " )", args);
    }

    public String getDomainCodeForGrowingSystem(String gsTopiaId) {
        String query = "SELECT gs.growingPlan.domain.code FROM " + GrowingSystem.class.getName() + " gs " + " WHERE gs." + "topiaId" + " = :gsTopiaId";
        String domainCode = (String)this.findUnique(query, DaoUtils.asArgsMap("gsTopiaId", gsTopiaId));
        return domainCode;
    }

    public List<Domain> getActiveWritableDomainsForDecisionRuleCreation(SecurityContext securityContext) {
        StringBuilder query = new StringBuilder("FROM " + this.getEntityClass().getName() + " D");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeEquals("D", "active", args, true));
        SecurityHelper.addWritableDomainFilterForDecisionRuleCreation(query, args, securityContext, "D");
        String queryString = query.toString();
        String queryAndOrder = queryString + " ORDER BY " + "lower (D." + "name" + ")";
        List domains = this.findAll(queryAndOrder, args);
        final HashSet presentCodes = Sets.newHashSet();
        Iterables.removeIf((Iterable)domains, (Predicate)new Predicate<Domain>(){

            public boolean apply(Domain input) {
                boolean added = presentCodes.add(input.getCode());
                return !added;
            }
        });
        return domains;
    }

    public List<String> findDomainIdsForCampaigns(String code, Set<Integer> campaigns, boolean includeCropsFromInactiveDomains) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        StringBuilder query = new StringBuilder("SELECT DISTINCT topiaId FROM " + this.getEntityClass().getName() + " D");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (!includeCropsFromInactiveDomains) {
            query.append(DaoUtils.andAttributeEquals("D", "active", args, true));
        }
        query.append(DaoUtils.andAttributeEquals("D", "code", args, code));
        query.append(DaoUtils.andAttributeIn("D", "campaign", args, campaigns));
        List domainIds = this.findAll(query.toString(), args);
        return domainIds;
    }

    public List<String> findCroppingPlanCodeForDomainsAndCampaigns(String code, Set<Integer> campaigns) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        StringBuilder query = new StringBuilder("SELECT DISTINCT cp.code FROM " + CroppingPlanEntry.class.getName() + " cp ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeEquals("cp", "domain.code", args, code));
        query.append(DaoUtils.andAttributeEquals("cp", "domain.active", args, true));
        query.append(DaoUtils.andAttributeIn("cp", "domain.campaign", args, campaigns));
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public List<String> findCroppingPlanSpeciesCodeForCropCodeAndCampaigns(String code, Set<Integer> campaigns) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        StringBuilder query = new StringBuilder("SELECT DISTINCT cps.code FROM " + CroppingPlanSpecies.class.getName() + " cps ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeEquals("cps", "croppingPlanEntry.code", args, code));
        query.append(DaoUtils.andAttributeEquals("cps", "croppingPlanEntry.domain.active", args, true));
        query.append(DaoUtils.andAttributeIn("cps", "croppingPlanEntry.domain.campaign", args, campaigns));
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public List<String> findToolsCouplingCodeForDomainsAndCampaigns(String code, Set<Integer> campaigns) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        StringBuilder query = new StringBuilder("SELECT DISTINCT tc.code FROM " + ToolsCoupling.class.getName() + " tc ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeEquals("tc", "domain.code", args, code));
        query.append(DaoUtils.andAttributeEquals("tc", "domain.active", args, true));
        query.append(DaoUtils.andAttributeIn("tc", "domain.campaign", args, campaigns));
        List toolsCouplingCodes = this.findAll(query.toString(), args);
        return toolsCouplingCodes;
    }

    public List<ToolsCoupling> findToolsCouplingsForDomainCodeAndCampaigns(String domainCode, Set<Integer> campaigns) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        StringBuilder query = new StringBuilder("SELECT DISTINCT tc FROM " + ToolsCoupling.class.getName() + " tc ");
        query.append(" WHERE 1 = 1 ");
        LinkedHashMap args = Maps.newLinkedHashMap();
        query.append(DaoUtils.andAttributeEquals("tc", "domain.code", args, domainCode));
        query.append(DaoUtils.andAttributeEquals("tc", "domain.active", args, true));
        query.append(DaoUtils.andAttributeIn("tc", "domain.campaign", args, campaigns));
        List toolsCouplings = this.findAll(query.toString(), args);
        return toolsCouplings;
    }

    protected Map<String, Long> queryBody(Iterable<String> toolsCouplingIds, String campaign, String subQuery) {
        HashMap result = Maps.newHashMap();
        LinkedHashMap args = Maps.newLinkedHashMap();
        HashSet tcIds = Sets.newHashSet(toolsCouplingIds);
        Preconditions.checkArgument((tcIds != null && !tcIds.isEmpty() ? 1 : 0) != 0);
        if (campaign != null) {
            args.put("campaign", campaign);
        }
        String query = " SELECT tc.topiaId ,";
        query = query + "(" + subQuery + ")";
        query = query + " FROM " + ToolsCoupling.class.getName() + " tc  WHERE 1 = 1 ";
        query = query + DaoUtils.andAttributeIn("tc", "topiaId", args, tcIds);
        List tcs = this.findAll(query + " GROUP BY tc." + "topiaId", args);
        for (Object[] tcTuple : tcs) {
            String tcId = (String)tcTuple[0];
            Long count = (Long)tcTuple[1];
            result.put(tcId, count);
        }
        return result;
    }

    public Map<String, Long> getTCUsedForEffectiveInterventions(Iterable<String> toolsCouplingIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveIntervention.class.getName() + " ei " + " WHERE tc IN ELEMENTS (ei." + "toolCouplings" + ")";
        Map<String, Long> result = this.queryBody(toolsCouplingIds, null, query);
        return result;
    }

    public Map<String, Long> getTCUsedForPracticedInterventionNodesAndConnections(Iterable<String> toolsCouplingIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedCropCycleNode.class.getName() + " pccn " + " WHERE pccn." + PRACTICED_NODE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS + " LIKE :campaign " + " AND pccn." + "practicedSeasonalCropCycle" + "." + "practicedSystem" + "." + "growingSystem" + "." + "growingPlan" + "." + "domain" + "." + "code" + "=" + "tc." + "domain" + "." + "code" + " AND pccn IN " + "   (" + "     SELECT pi." + "practicedCropCycleConnection" + "." + "source" + "     FROM " + PracticedIntervention.class.getName() + " pi " + "     WHERE tc." + "code" + " IN ELEMENTS (pi." + "toolsCouplingCodes" + ")" + "    )";
        Map<String, Long> result = this.queryBody(toolsCouplingIds, campaign, query);
        return result;
    }

    public Map<String, Long> getTCUsedForPracticedInterventionPhases(Iterable<String> toolsCouplingIds, String campaign) {
        String query = "SELECT COUNT(ppcc) FROM " + PracticedPerennialCropCycle.class.getName() + " ppcc, " + PracticedIntervention.class.getName() + " pi " + " WHERE ppcc." + "practicedSystem" + "." + "campaigns" + " LIKE :campaign " + " AND pi." + "practicedCropCyclePhase" + " IN ELEMENTS (ppcc." + "cropCyclePhases" + ")" + " AND tc." + "code" + " IN ELEMENTS (pi." + "toolsCouplingCodes" + ")";
        Map<String, Long> result = this.queryBody(toolsCouplingIds, campaign, query);
        return result;
    }
}

