/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AbstractCroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpecies;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.measure.Measure;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CroppingPlanSpeciesTopiaDao
extends AbstractCroppingPlanSpeciesTopiaDao<CroppingPlanSpecies> {
    private static final Log log = LogFactory.getLog(CroppingPlanSpeciesTopiaDao.class);
    public static String FROM_NODE_TO_DOMAIN_QUERY = "practicedSeasonalCropCycle.practicedSystem.growingSystem.growingPlan.domain";

    public List<CroppingPlanSpecies> getCroppingPlanSpeciesForCodeAndDomainId(Set<String> speciesCodes, String domainId) {
        LinkedHashMap args = Maps.newLinkedHashMap();
        StringBuilder query = new StringBuilder("FROM " + CroppingPlanSpecies.class.getName() + " cps ");
        query.append("  WHERE 1 = 1 ");
        query.append(DaoUtils.andAttributeIn("cps", "code", args, speciesCodes));
        query.append(DaoUtils.andAttributeEquals("cps", "croppingPlanEntry.domain.topiaId", args, domainId));
        List result = this.findAll(query.toString(), args);
        return result;
    }

    protected Map<String, Long> queryBody(Iterable<String> croppingPlanSpeciesId, String campaign, String subQuery) {
        HashMap result = Maps.newHashMap();
        LinkedHashMap args = Maps.newLinkedHashMap();
        HashSet cpeIds = Sets.newHashSet(croppingPlanSpeciesId);
        if (campaign != null) {
            args.put("campaign", campaign);
        }
        StringBuilder query = new StringBuilder("SELECT cps.topiaId, ");
        query.append("(" + subQuery + ")");
        query.append(" FROM " + CroppingPlanSpecies.class.getName() + " cps  WHERE 1 = 1 ");
        query.append(DaoUtils.andAttributeIn("cps", "topiaId", args, cpeIds));
        List cpss = this.findAll(query.toString(), args);
        for (Object[] cpsTuple : cpss) {
            String cpsId = (String)cpsTuple[0];
            Long count = (Long)cpsTuple[1];
            result.put(cpsId, count);
        }
        return result;
    }

    public Map<String, Long> getCPSpeciesUsedForMeasures(Iterable<String> croppingPlanSpeciesIds) {
        String query = "SELECT COUNT(*) FROM " + Measure.class.getName() + " m " + "  WHERE m." + "croppingPlanSpecies" + "." + "topiaId" + " = cps." + "topiaId";
        Map<String, Long> result = this.queryBody(croppingPlanSpeciesIds, null, query);
        return result;
    }

    public Map<String, Long> getCPSpeciesUsedForEffectiveCropCycleSpecies(Iterable<String> croppingPlanSpeciesIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveCropCycleSpecies.class.getName() + " eccs " + "   WHERE eccs." + "croppingPlanSpecies" + "." + "topiaId" + " = cps." + "topiaId";
        Map<String, Long> result = this.queryBody(croppingPlanSpeciesIds, null, query);
        return result;
    }

    public Map<String, Long> getCPSpeciesUsedForEffectiveSpeciesStades(Iterable<String> croppingPlanSpeciesIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveSpeciesStade.class.getName() + " ess " + "   WHERE ess." + "croppingPlanSpecies" + "." + "topiaId" + " = cps." + "topiaId";
        Map<String, Long> result = this.queryBody(croppingPlanSpeciesIds, null, query);
        return result;
    }

    public Map<String, Long> getCPSpeciesUsedForPracticedCropCycleSpecies(Iterable<String> croppingPlanSpeciesIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedCropCycleSpecies.class.getName() + " pccs " + "   WHERE pccs." + "croppingPlanSpeciesCode" + " =cps." + "code" + "   AND pccs." + "cycle" + "." + "practicedSystem" + "." + "campaigns" + " LIKE :campaign ";
        Map<String, Long> result = this.queryBody(croppingPlanSpeciesIds, campaign, query);
        return result;
    }

    public List<PracticedCropCycleNode> getPracticedCropCycleNodeForCampaignAndDomainCode(String domainCode, String campaign) {
        String query = "FROM " + PracticedCropCycleNode.class.getName() + " pccn " + "  WHERE " + "  pccn." + "practicedSeasonalCropCycle.practicedSystem.campaigns" + " LIKE :campaign " + "  AND pccn." + FROM_NODE_TO_DOMAIN_QUERY + "." + "code" + " = :domainCode";
        LinkedHashMap args = Maps.newLinkedHashMap();
        args.put("campaign", campaign);
        args.put("domainCode", domainCode);
        List result = this.findAll(query, args);
        return result;
    }

    public Map<String, Long> getCPSpeciesUsedForPracticedPerennialCropCycleStades(Iterable<String> croppingPlanSpeciesIds, String campaign) {
        String query = "SELECT COUNT(ppcc) FROM " + PracticedPerennialCropCycle.class.getName() + " ppcc, " + PracticedIntervention.class.getName() + " pi," + PracticedSpeciesStade.class.getName() + " pss " + "  WHERE pss." + "speciesCode" + "= cps." + "code" + "  AND ppcc." + "practicedSystem" + "." + "campaigns" + " LIKE :campaign " + "  AND pi." + "practicedCropCyclePhase" + " IN ELEMENTS (" + "      ppcc." + "cropCyclePhases" + ")" + "  AND pss IN ELEMENTS(pi." + "speciesStades" + ")";
        Map<String, Long> result = this.queryBody(croppingPlanSpeciesIds, campaign, query);
        return result;
    }

    public List<PracticedIntervention> practicedInterventionsForSources(List<PracticedCropCycleNode> nodes) {
        StringBuilder query = new StringBuilder("FROM " + PracticedIntervention.class.getName() + " pi");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        String piSource = "practicedCropCycleConnection.source";
        HashSet nodesSet = Sets.newHashSet(nodes);
        query.append(DaoUtils.andAttributeInIfNotEmpty("pi", piSource, args, nodesSet));
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public List<PracticedIntervention> practicedInterventionsForTargets(List<PracticedCropCycleNode> nodes) {
        StringBuilder query = new StringBuilder("FROM " + PracticedIntervention.class.getName() + " pi");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        String piSource = "practicedCropCycleConnection.target";
        HashSet nodesSet = Sets.newHashSet(nodes);
        query.append(DaoUtils.andAttributeInIfNotEmpty("pi", piSource, args, nodesSet));
        List result = this.findAll(query.toString(), args);
        return result;
    }

    public Map<PracticedSpeciesStade, String> getSpeciesPracticedSpeciesStades(Iterable<String> croppingPlanSpeciesIds) {
        HashSet cpeSpeciesIds = Sets.newHashSet(croppingPlanSpeciesIds);
        LinkedHashMap args = Maps.newLinkedHashMap();
        String query = "SELECT pss, cps.topiaId FROM " + PracticedSpeciesStade.class.getName() + " pss, " + CroppingPlanSpecies.class.getName() + " cps " + "  WHERE pss." + "speciesCode" + "= cps." + "code";
        query = query + DaoUtils.andAttributeIn("cps", "topiaId", args, cpeSpeciesIds);
        HashMap result = Maps.newHashMap();
        List queryResults = this.findAll(query, args);
        for (Object[] res : queryResults) {
            PracticedSpeciesStade speciesStade = (PracticedSpeciesStade)res[0];
            String speciesId = (String)res[1];
            result.put(speciesStade, speciesId);
        }
        return result;
    }
}

