/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AbstractCroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.managementmode.Strategy;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CroppingPlanEntryTopiaDao
extends AbstractCroppingPlanEntryTopiaDao<CroppingPlanEntry> {
    protected static final String EFFECTIVE_CROPPING_PLAN_ENTRY_ID = "croppingPlanEntry.topiaId";
    protected static final String PRACTICED_NODE_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS = "practicedSeasonalCropCycle.practicedSystem.campaigns";
    protected static final String PRACTICED_CONNECTION_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS = "source.practicedSeasonalCropCycle.practicedSystem.campaigns";
    protected static final String PRACTICED_CONNECTION_TARGET_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS = "target.practicedSeasonalCropCycle.practicedSystem.campaigns";
    protected static final String EFFECTIVE_CONNECTION_SOURCE_CROPPING_PLAN_ENTRY_ID = "source.croppingPlanEntry.topiaId";
    protected static final String EFFECTIVE_CONNECTION_TARGET_CROPPING_PLAN_ENTRY_ID = "target.croppingPlanEntry.topiaId";
    protected static final String CROPPING_PLAN_ENTRY_DOMAIN_CAMPAIGN = "domain.campaign";
    private static final Log log = LogFactory.getLog(CroppingPlanEntryTopiaDao.class);

    public List<CroppingPlanEntry> findEntriesFromCode(String croppingPlanEntryCode, Set<Integer> campaigns) {
        String query = "FROM " + this.getEntityClass().getName() + " e ";
        LinkedHashMap args = Maps.newLinkedHashMap();
        query = query + " WHERE e.code = :code";
        args.put("code", croppingPlanEntryCode);
        query = query + DaoUtils.andAttributeIn("e", CROPPING_PLAN_ENTRY_DOMAIN_CAMPAIGN, args, campaigns);
        List entries = this.findAll(query + " ORDER BY e." + CROPPING_PLAN_ENTRY_DOMAIN_CAMPAIGN + " DESC", args);
        return entries;
    }

    protected Map<String, Long> queryBody(Iterable<String> croppingPlanIds, String campaign, String subQuery) {
        HashMap result = Maps.newHashMap();
        LinkedHashMap args = Maps.newLinkedHashMap();
        HashSet cpeIds = Sets.newHashSet(croppingPlanIds);
        if (campaign != null) {
            args.put("campaign", campaign);
        }
        String query = " SELECT cpe.topiaId, ";
        query = query + "(" + subQuery + ")";
        query = query + " FROM " + CroppingPlanEntry.class.getName() + " cpe WHERE 1 = 1 ";
        query = query + DaoUtils.andAttributeIn("cpe", "topiaId", args, cpeIds);
        List cpes = this.findAll(query, args);
        for (Object[] cpeTuple : cpes) {
            String cpeId = (String)cpeTuple[0];
            Long count = (Long)cpeTuple[1];
            result.put(cpeId, count);
        }
        return result;
    }

    public Map<String, Long> getCPEUsedForStrategies(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + Strategy.class.getName() + " s " + "       WHERE s." + "croppingPlanEntry" + "." + "topiaId" + " = cpe." + "topiaId";
        Map<String, Long> result = this.queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForMesurementSessions(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + MeasurementSession.class.getName() + " ms " + "        WHERE ms." + "croppingPlanEntry" + "." + "topiaId" + " = cpe." + "topiaId";
        Map<String, Long> result = this.queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForEffectiveCropCycleNode(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveCropCycleNode.class.getName() + " eccn " + "        WHERE eccn." + "croppingPlanEntry" + "." + "topiaId" + " = cpe." + "topiaId";
        Map<String, Long> result = this.queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForEffectiveCropCycleConnections(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveCropCycleConnection.class.getName() + " eccc " + "        WHERE eccc." + "intermediateCroppingPlanEntry" + "." + "topiaId" + " = cpe." + "topiaId" + "        OR eccc." + EFFECTIVE_CONNECTION_SOURCE_CROPPING_PLAN_ENTRY_ID + " = cpe." + "topiaId" + "        OR eccc." + EFFECTIVE_CONNECTION_TARGET_CROPPING_PLAN_ENTRY_ID + " = cpe." + "topiaId";
        Map<String, Long> result = this.queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForPracticedCropCycleConnections(Iterable<String> cpeIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedCropCycleConnection.class.getName() + " pccc " + "        WHERE pccc." + "intermediateCroppingPlanEntryCode" + " = cpe." + "code" + "        AND (" + "        (pccc." + PRACTICED_CONNECTION_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS + " LIKE :campaign" + "     ) " + "             OR " + "                (pccc." + PRACTICED_CONNECTION_TARGET_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS + " LIKE :campaign) " + "     ) ";
        Map<String, Long> result = this.queryBody(cpeIds, campaign, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForPracticedCropCycleNodes(Iterable<String> cpeIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedCropCycleNode.class.getName() + " pccn " + "        WHERE pccn." + PRACTICED_NODE_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS + " LIKE :campaign " + "        AND pccn." + "croppingPlanEntryCode" + " = cpe." + "code";
        Map<String, Long> result = this.queryBody(cpeIds, campaign, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForEffectivePerenialCropCycles(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + EffectivePerennialCropCycle.class.getName() + " epcc " + "        WHERE epcc." + EFFECTIVE_CROPPING_PLAN_ENTRY_ID + " = cpe." + "topiaId";
        Map<String, Long> result = this.queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedPracticedPerenialCropCycles(Iterable<String> cpeIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedPerennialCropCycle.class.getName() + " ppcc " + "        WHERE ppcc." + "croppingPlanEntryCode" + " = cpe." + "code" + "        AND ppcc." + "practicedSystem" + "." + "campaigns" + " LIKE :campaign ";
        Map<String, Long> result = this.queryBody(cpeIds, campaign, query);
        return result;
    }
}

