/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaApplicationContext;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

public class AgrosystTopiaApplicationContext
extends AbstractAgrosystTopiaApplicationContext {
    private static final Log log = LogFactory.getLog(AgrosystTopiaApplicationContext.class);
    protected AgrosystServiceConfig config;

    public AgrosystTopiaApplicationContext(AgrosystServiceConfig config, Properties topiaProperties) {
        super(topiaProperties);
        this.config = config;
    }

    public void applicationInit() {
        String logFileLocation = this.config.getLogFileLocation();
        if (StringUtils.isNotBlank((CharSequence)logFileLocation)) {
            File log4jConfigurationFile = new File(logFileLocation);
            String log4jConfigurationFileAbsolutePath = log4jConfigurationFile.getAbsolutePath();
            if (log4jConfigurationFile.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("will use logging configuration " + log4jConfigurationFileAbsolutePath));
                }
                LogManager.resetConfiguration();
                PropertyConfigurator.configure((String)log4jConfigurationFileAbsolutePath);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("there is no file " + log4jConfigurationFileAbsolutePath + ". Default logging configuration will be used."));
            }
        }
    }

    public void setConfig(AgrosystServiceConfig config) {
        this.config = config;
    }

    public AgrosystServiceConfig getConfig() {
        return this.config;
    }
}

