/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.users;

import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class UserServiceTest
extends AbstractAgrosystTest {
    UserService service;
    AuthenticationService authService;

    @Before
    public void setupServices() throws TopiaException {
        this.service = (UserService)this.serviceFactory.newService(UserService.class);
        this.authService = (AuthenticationService)this.serviceFactory.newService(AuthenticationService.class);
        TestDatas testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        testDatas.createTestUsers();
    }

    @Test
    public void testLoadUser() {
        UserDto user = this.authService.login("jenvoie@atoit.fr", "passera");
        Assert.assertNotNull((Object)user);
    }

    @Test
    public void testCreateValidUser() {
        UserDto user = new UserDto();
        user.setEmail("beta@tester.com");
        user.setFirstName("bebe");
        user.setLastName("tata");
        UserDto updatedUser = this.service.createUser(user, "betaTesterPassword");
        Assert.assertEquals((Object)updatedUser.getEmail(), (Object)user.getEmail());
    }

    @Test
    public void testEmailInUse() {
        Assert.assertTrue((boolean)this.service.isEmailInUse("jenvoie@atoit.fr", null));
        UserDto user = this.authService.login("jenvoie@atoit.fr", "passera");
        Assert.assertFalse((boolean)this.service.isEmailInUse("jenvoie@atoit.fr", user.getTopiaId()));
        Assert.assertFalse((boolean)this.service.isEmailInUse("pouette@toto.fr", null));
        Assert.assertFalse((boolean)this.service.isEmailInUse("pouette@toto.fr", "azertyuj"));
    }
}

