/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.ComputedUserPermissionTopiaDao;
import fr.inra.agrosyst.api.entities.security.PermissionObjectType;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.api.services.security.UserRoleEntityDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorizationServiceTest
extends AbstractAgrosystTest {
    protected TestDatas testDatas;
    protected UserService userService;
    protected BusinessAuthorizationService authorizationService;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected GrowingPlanTopiaDao growingPlanDao;
    protected ComputedUserPermissionTopiaDao computedUserPermissionDao;
    protected GrowingPlanService growingPlanService;
    protected DomainTopiaDao domainTopiaDao;
    protected String growingPlanCode;
    protected String growingPlanId;
    protected String growingSystemId;
    protected String domainId;
    protected AgrosystUser testUser;

    @Before
    public void setupServices() {
        this.userService = (UserService)this.serviceFactory.newService(UserService.class);
        this.authorizationService = (BusinessAuthorizationService)this.serviceFactory.newService(BusinessAuthorizationService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.growingSystemDao = this.getPersistenceContext().getGrowingSystemDao();
        this.growingPlanDao = this.getPersistenceContext().getGrowingPlanDao();
        this.domainTopiaDao = this.getPersistenceContext().getDomainDao();
        this.computedUserPermissionDao = this.getPersistenceContext().getComputedUserPermissionDao();
        this.growingPlanService = (GrowingPlanService)this.serviceFactory.newService(GrowingPlanService.class);
        Domain domain = this.testDatas.createSingleTestDomain();
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.findAll().iterator().next();
        GrowingPlan growingPlan = growingSystem.getGrowingPlan();
        this.domainId = domain.getTopiaId();
        this.growingSystemId = growingSystem.getTopiaId();
        this.growingPlanId = growingPlan.getTopiaId();
        this.growingPlanCode = growingPlan.getCode();
        this.testUser = this.testDatas.createSingleTestUser();
        this.getConfig().setBusinessCachingEnabled(true);
    }

    @Test
    public void testGrowingPlanResponsible() {
        this.loginAsTest();
        try {
            this.authorizationService.checkDomainReadable(this.domainId);
            Assert.fail((String)"Should have failed");
        }
        catch (AgrosystAccessDeniedException agrosystAccessDeniedException) {
            // empty catch block
        }
        this.loginAsAdmin();
        ArrayList roles = Lists.newArrayList();
        UserRoleDto userRoleDto = new UserRoleDto();
        roles.add(userRoleDto);
        userRoleDto.setType(RoleType.GROWING_PLAN_RESPONSIBLE);
        UserRoleEntityDto userRoleEntityDto = new UserRoleEntityDto();
        userRoleEntityDto.setIdentifier(this.growingPlanCode);
        userRoleDto.setEntity(userRoleEntityDto);
        this.authorizationService.saveUserRoles(this.testUser.getTopiaId(), (List)roles);
        this.loginAsTest();
        this.authorizationService.checkDomainReadable(this.domainId);
        Assert.assertTrue((boolean)this.authorizationService.isGrowingPlanWritable(this.growingPlanId));
        this.authorizationService.checkCreateOrUpdateGrowingPlan(this.growingPlanId);
        Assert.assertTrue((boolean)this.authorizationService.isGrowingSystemWritable(this.growingSystemId));
        this.authorizationService.checkCreateOrUpdateGrowingSystem(this.growingSystemId);
        Assert.assertFalse((boolean)this.authorizationService.isDomainWritable(this.domainId));
        try {
            this.authorizationService.checkCreateOrUpdateDomain(this.domainId);
            Assert.fail((String)"Should have failed");
        }
        catch (AgrosystAccessDeniedException agrosystAccessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateGrowingPlan() {
        this.loginAsAdmin();
        Domain domain = (Domain)this.domainTopiaDao.forTopiaIdEquals(this.domainId).findUnique();
        GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.newInstance();
        growingPlan.setName("TEST");
        growingPlan.setType(TypeDEPHY.DEPHY_EXPE);
        growingPlan.setDomain(domain);
        this.growingPlanService.createOrUpdateGrowingPlan(growingPlan);
    }

    @Test
    public void testIsObjectDirty() {
        this.loginAsAdmin();
        Domain domain = (Domain)this.domainTopiaDao.forTopiaIdEquals(this.domainId).findUnique();
        List toDirty = this.computedUserPermissionDao.forProperties("type", (Object)PermissionObjectType.DOMAIN_ID, new Object[]{"object", domain.getTopiaId(), "dirty", false}).findAll();
    }

    protected void loginAsTest() {
        this.loginUser(this.testUser.getEmail(), "azerty");
    }
}

