/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.MaterielType;
import fr.inra.agrosyst.api.entities.action.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.referential.TypeMaterielFilter;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReferentialServiceTest
extends AbstractAgrosystTest {
    protected ReferentialService referentialService;
    protected ImportService importService;
    private TestDatas testDatas;

    @Before
    public void setupServices() {
        this.referentialService = (ReferentialService)this.serviceFactory.newService(ReferentialService.class);
        this.importService = (ImportService)this.serviceFactory.newService(ImportService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
    }

    @Test
    public void testGetTypeMateriel1List() {
        this.testDatas.importMateriels();
        Map values = this.referentialService.getTypeMateriel1List();
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertEquals((long)5L, (long)((List)values.get(MaterielType.TRACTEUR)).size());
        Assert.assertEquals((long)7L, (long)((List)values.get(MaterielType.AUTOMOTEUR)).size());
        Assert.assertEquals((long)10L, (long)((List)values.get(MaterielType.OUTIL)).size());
        Assert.assertEquals((long)4L, (long)((List)values.get(MaterielType.IRRIGATION)).size());
    }

    @Test
    public void testGetTypeMateriel2List() {
        this.testDatas.importMateriels();
        TypeMaterielFilter filter = new TypeMaterielFilter("TRACTEURS SPECIALISES 4RM VIGNE");
        filter.setType(MaterielType.TRACTEUR);
        List values = this.referentialService.getTypeMateriel2List(filter);
        Assert.assertEquals((long)1L, (long)values.size());
    }

    @Test
    public void testGetTypeMateriel3List() {
        this.testDatas.importMateriels();
        TypeMaterielFilter filter = new TypeMaterielFilter("TRACTEURS SPECIALISES 4RM VIGNE", "Tracteurs Sp\u00e9cialis\u00e9s Vigne 4 RM avec cabine confort");
        filter.setType(MaterielType.TRACTEUR);
        List values = this.referentialService.getTypeMateriel3List(filter);
        Assert.assertEquals((long)6L, (long)values.size());
    }

    @Test
    public void testGetTypeMateriel4List() {
        this.testDatas.importMateriels();
        TypeMaterielFilter filter = new TypeMaterielFilter("TRACTEURS SPECIALISES 4RM VIGNE", "Tracteurs Sp\u00e9cialis\u00e9s Vigne 4 RM avec cabine confort", "46 \u00e0 55 ch");
        filter.setType(MaterielType.TRACTEUR);
        List values = this.referentialService.getTypeMateriel4List(filter);
        Assert.assertEquals((long)1L, (long)values.size());
    }

    @Test
    public void testFindSpecies() {
        InputStream especes = ReferentialServiceTest.class.getResourceAsStream("/referentiels/test/cultures_AEE_complet.csv");
        this.importService.importEspeces(especes);
        InputStream geves = ReferentialServiceTest.class.getResourceAsStream("/referentiels/test/varietes_GEVES.csv");
        this.importService.importVarietesGeves(geves);
        InputStream plantGrape = ReferentialServiceTest.class.getResourceAsStream("/referentiels/test/varietes_PlantGrape.csv");
        this.importService.importVarietesPlantGrape(plantGrape);
        InputStream culturesVarietes = ReferentialServiceTest.class.getResourceAsStream("/referentiels/test/cultures_varietes.csv");
        this.importService.importEspecesToVarietes(culturesVarietes);
        List species = this.referentialService.findSpecies("grosti");
        Assert.assertEquals((long)6L, (long)species.size());
        species = this.referentialService.findSpecies("grostide stolonif\u00e8r");
        Assert.assertEquals((long)1L, (long)species.size());
        RefEspece espece = (RefEspece)species.get(0);
        List varietes = this.referentialService.findVarietes(espece.getTopiaId(), "h");
        Assert.assertEquals((long)2L, (long)varietes.size());
        species = this.referentialService.findSpecies("Vigne");
        Assert.assertEquals((long)2L, (long)species.size());
        espece = (RefEspece)species.get(0);
        Assert.assertEquals((Object)"ZMO", (Object)espece.getCode_espece_botanique());
        varietes = this.referentialService.findVarietes(espece.getTopiaId(), "lima");
        Assert.assertEquals((long)2L, (long)varietes.size());
        Assert.assertTrue((boolean)(varietes.get(0) instanceof RefVarieteGeves));
        Assert.assertTrue((boolean)(varietes.get(1) instanceof RefVarietePlantGrape));
    }

    @Test
    public void testMaterielTypeWithAdditionalSpaces() {
        this.testDatas.importMaterielsOutilsVitiArbo();
        TypeMaterielFilter filter = new TypeMaterielFilter("Broyeur");
        filter.setType(MaterielType.OUTIL);
        List values = this.referentialService.getTypeMateriel2List(filter);
        Assert.assertTrue((boolean)values.contains("Broyeur port\u00e9 VL"));
        Assert.assertFalse((boolean)values.contains("Broyeur port\u00e9  VL"));
    }

    @Test
    public void testReferenceDose() {
        this.testDatas.importEspeces();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importActaGroupeCultures();
        this.testDatas.importLienCulturesEdiActa();
        List species = this.referentialService.findSpecies("Ble tendre");
        RefEspece espece = (RefEspece)Iterables.find((Iterable)species, (Predicate)new Predicate<RefEspece>(){

            public boolean apply(RefEspece input) {
                return "ZFB".equals(input.getCode_type_saisonnier_AEE());
            }
        });
        RefActaDosageSPC refActaDosageSPC = this.referentialService.computeActaReferenceDose("5166", (Set)Sets.newHashSet((Object[])new String[]{espece.getTopiaId()}));
        Assert.assertEquals((Object)"5166", (Object)refActaDosageSPC.getId_produit());
        Assert.assertEquals((long)21L, (long)refActaDosageSPC.getId_culture());
        Assert.assertEquals((double)240.0, (double)refActaDosageSPC.getDosage_spc_valeur(), (double)0.001);
        Assert.assertEquals((Object)PhytoProductUnit.G_HA, (Object)refActaDosageSPC.getDosage_spc_unite());
        refActaDosageSPC = this.referentialService.computeActaReferenceDose("4632", (Set)Sets.newHashSet((Object[])new String[]{espece.getTopiaId()}));
        Assert.assertEquals((Object)"4632", (Object)refActaDosageSPC.getId_produit());
        Assert.assertEquals((long)21L, (long)refActaDosageSPC.getId_culture());
        Assert.assertEquals((double)1.5, (double)refActaDosageSPC.getDosage_spc_valeur(), (double)0.001);
        Assert.assertEquals((Object)PhytoProductUnit.L_HA, (Object)refActaDosageSPC.getDosage_spc_unite());
        refActaDosageSPC = this.referentialService.computeActaReferenceDose("4629", (Set)Sets.newHashSet((Object[])new String[]{espece.getTopiaId()}));
        Assert.assertEquals((Object)"4629", (Object)refActaDosageSPC.getId_produit());
        Assert.assertEquals((long)21L, (long)refActaDosageSPC.getId_culture());
        Assert.assertEquals((double)1.0, (double)refActaDosageSPC.getDosage_spc_valeur(), (double)0.001);
        Assert.assertEquals((Object)PhytoProductUnit.L_HA, (Object)refActaDosageSPC.getDosage_spc_unite());
        species = this.referentialService.findSpecies("Vigne");
        espece = (RefEspece)Iterables.find((Iterable)species, (Predicate)new Predicate<RefEspece>(){

            public boolean apply(RefEspece input) {
                return "J09".equals(input.getCode_categorie_de_cultures()) && "H61".equals(input.getCode_destination_AEE());
            }
        });
        refActaDosageSPC = this.referentialService.computeActaReferenceDose("3494", (Set)Sets.newHashSet((Object[])new String[]{espece.getTopiaId()}));
        Assert.assertEquals((Object)"3494", (Object)refActaDosageSPC.getId_produit());
        Assert.assertEquals((long)14L, (long)refActaDosageSPC.getId_culture());
        Assert.assertEquals((double)3.2, (double)refActaDosageSPC.getDosage_spc_valeur(), (double)0.001);
        Assert.assertEquals((Object)PhytoProductUnit.L_HA, (Object)refActaDosageSPC.getDosage_spc_unite());
        refActaDosageSPC = this.referentialService.computeActaReferenceDose("34941", (Set)Sets.newHashSet((Object[])new String[]{espece.getTopiaId()}));
        Assert.assertEquals((Object)"34941", (Object)refActaDosageSPC.getId_produit());
        Assert.assertEquals((long)428L, (long)refActaDosageSPC.getId_culture());
        Assert.assertEquals((double)2.4, (double)refActaDosageSPC.getDosage_spc_valeur(), (double)0.001);
        Assert.assertEquals((Object)PhytoProductUnit.L_HA, (Object)refActaDosageSPC.getDosage_spc_unite());
    }

    @Test
    public void testCacheOnActaTraitementsProduitsCateg() {
        Assert.assertFalse((boolean)this.getConfig().isBusinessCachingEnabled());
        this.getConfig().setBusinessCachingEnabled(true);
        Assert.assertTrue((boolean)this.getConfig().isBusinessCachingEnabled());
        this.testDatas.importActaTraitementsProduitsCateg();
        Map map = this.referentialService.getAllActiveActaTreatmentProductTypes();
        Assert.assertEquals((long)3L, (long)map.size());
        Map map2 = this.referentialService.getAllActiveActaTreatmentProductTypes();
        Assert.assertEquals((long)3L, (long)map2.size());
        Assert.assertTrue((map == map2 ? 1 : 0) != 0);
    }

    @Test
    public void testCacheOnFindAllActiveAgrosystActions() {
        Assert.assertFalse((boolean)this.getConfig().isBusinessCachingEnabled());
        this.getConfig().setBusinessCachingEnabled(true);
        Assert.assertTrue((boolean)this.getConfig().isBusinessCachingEnabled());
        this.testDatas.importInterventionAgrosystTravailEdi();
        List list = this.referentialService.findAllActiveAgrosystActions();
        Assert.assertEquals((long)50L, (long)list.size());
        List list2 = this.referentialService.findAllActiveAgrosystActions();
        Assert.assertEquals((long)50L, (long)list2.size());
        Assert.assertTrue((list == list2 ? 1 : 0) != 0);
        List list3 = this.referentialService.findAllActiveAgrosystActions(null);
        Assert.assertEquals((long)50L, (long)list3.size());
        Assert.assertTrue((list == list3 ? 1 : 0) != 0);
        List list4 = this.referentialService.findAllActiveAgrosystActions(AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES);
        Assert.assertEquals((long)1L, (long)list4.size());
        Assert.assertFalse((list == list4 ? 1 : 0) != 0);
    }
}

