/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.PriceTopiaDao;
import fr.inra.agrosyst.api.entities.PriceType;
import fr.inra.agrosyst.api.entities.PriceUnit;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFATopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.Referentials;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.referential.ImportServiceImpl;
import fr.inra.agrosyst.services.referential.InseeAndOsmCommunesComparison;
import fr.inra.agrosyst.services.referential.csv.CommuneInseeModel;
import fr.inra.agrosyst.services.referential.csv.CommunePostCodeModel;
import fr.inra.agrosyst.services.referential.csv.CommunesPostCodeOsmModel;
import fr.inra.agrosyst.services.referential.csv.RefLocationDto;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.topia.persistence.TopiaException;

public class ImportServiceTest
extends AbstractAgrosystTest {
    private static final Log log = LogFactory.getLog(ImportServiceTest.class);
    protected static final Comparator<InseeAndOsmCommunesComparison> COMMUNES_COMPARISON_COMPARATOR = new Comparator<InseeAndOsmCommunesComparison>(){

        @Override
        public int compare(InseeAndOsmCommunesComparison o1, InseeAndOsmCommunesComparison o2) {
            String code1 = (String)MoreObjects.firstNonNull((Object)o1.getInseeCode(), (Object)"null");
            String code2 = (String)MoreObjects.firstNonNull((Object)o2.getInseeCode(), (Object)"null");
            return code1.compareTo(code2);
        }
    };
    protected ImportService importService;
    protected ReferentialService referentialService;
    protected TestDatas testDatas;

    @Before
    public void setupServices() {
        this.importService = (ImportService)this.serviceFactory.newService(ImportService.class);
        this.referentialService = (ReferentialService)this.serviceFactory.newService(ReferentialService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
    }

    @Test
    public void testImportCommunesOsm() throws TopiaException {
        ImportResult result = this.testDatas.importCommunesOsm();
        this.testImportCommunes(result, 50);
    }

    @Test
    public void testImportCommunesInsee() throws TopiaException {
        ImportResult result = this.testDatas.importCommunesInsee();
        this.testImportCommunes(result, 50);
    }

    protected void testImportCommunes(ImportResult result, int nb) throws TopiaException {
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)nb, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
        RefLocationTopiaDao refLocationTopiaDao = this.getPersistenceContext().getRefLocationDao();
        Assert.assertEquals((long)nb, (long)refLocationTopiaDao.count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void compareInseeAndOsmCommunes() throws Exception {
        HashMap<String, InseeAndOsmCommunesComparison> comparisons = new HashMap<String, InseeAndOsmCommunesComparison>();
        CommuneInseeModel inseeCsvModel = new CommuneInseeModel();
        CommunePostCodeModel postCodeCsvModel = new CommunePostCodeModel();
        CommunesPostCodeOsmModel osmCsvModel = new CommunesPostCodeOsmModel();
        Import importer = null;
        InputStream osmStream = null;
        InputStream inseeStream = null;
        InputStream postCodesStream = null;
        try {
            String commune;
            InseeAndOsmCommunesComparison comparison;
            String codeInsee;
            osmStream = ImportServiceTest.class.getResourceAsStream("/referentiels/communes_osm.csv");
            inseeStream = ImportServiceTest.class.getResourceAsStream("/referentiels/communes_insee.csv");
            postCodesStream = ImportServiceTest.class.getResourceAsStream("/referentiels/communes_codePosteaux.csv");
            importer = Import.newImport((ImportModel)postCodeCsvModel, (Reader)new InputStreamReader(postCodesStream, this.serviceContext.getConfig().getFileEncoding()));
            ImmutableMap postCodes = Maps.uniqueIndex((Iterable)importer, (Function)ImportServiceImpl.GET_REF_LOCATION_DTO_CODE_INSEE);
            importer.close();
            importer = Import.newImport((ImportModel)inseeCsvModel, (Reader)new InputStreamReader(inseeStream, this.serviceContext.getConfig().getFileEncoding()));
            for (RefLocationDto dto : importer) {
                codeInsee = (String)ImportServiceImpl.GET_REF_LOCATION_DTO_CODE_INSEE.apply((Object)dto);
                comparison = new InseeAndOsmCommunesComparison();
                comparison.setInseeCode(codeInsee);
                InseeAndOsmCommunesComparison previous = comparisons.put(codeInsee, comparison);
                if (previous != null) {
                    log.warn((Object)("2 communes pour le code insee " + codeInsee));
                }
                comparison.setInInseeReferential(true);
                commune = (String)ImportServiceImpl.GET_REF_LOCATION_DTO_PRETTY_COMMUNE.apply((Object)dto);
                comparison.setInseeName(commune);
                String codeInseeForPostCodes = codeInsee.replace("2A", "20").replace("2B", "20");
                if (!postCodes.containsKey((Object)codeInseeForPostCodes)) continue;
                RefLocationDto codePostalDto = (RefLocationDto)postCodes.get((Object)codeInseeForPostCodes);
                comparison.setInseePostCode(Strings.padStart((String)codePostalDto.getCodePostal(), (int)5, (char)'0'));
            }
            importer.close();
            importer = Import.newImport((ImportModel)osmCsvModel, (Reader)new InputStreamReader(osmStream, this.serviceContext.getConfig().getFileEncoding()));
            for (RefLocationDto dto : importer) {
                codeInsee = (String)ImportServiceImpl.GET_REF_LOCATION_DTO_CODE_INSEE.apply((Object)dto);
                comparison = (InseeAndOsmCommunesComparison)comparisons.get(codeInsee);
                if (comparison == null) {
                    comparison = new InseeAndOsmCommunesComparison();
                    comparison.setInseeCode(codeInsee);
                    comparisons.put(codeInsee, comparison);
                }
                comparison.setInOsmReferential(true);
                String codePostal = dto.getCodePostal().split(";")[0];
                comparison.setOsmPostCode(Strings.padStart((String)codePostal, (int)5, (char)'0'));
                commune = (String)ImportServiceImpl.GET_REF_LOCATION_DTO_PRETTY_COMMUNE.apply((Object)dto);
                comparison.setOsmName(commune);
            }
        }
        catch (Exception e) {
            try {
                log.warn((Object)"Erreur \u00e0 l'import ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(importer);
                IOUtils.closeQuietly((InputStream)osmStream);
                IOUtils.closeQuietly((InputStream)inseeStream);
                IOUtils.closeQuietly(postCodesStream);
                throw throwable;
            }
            IOUtils.closeQuietly(importer);
            IOUtils.closeQuietly((InputStream)osmStream);
            IOUtils.closeQuietly((InputStream)inseeStream);
            IOUtils.closeQuietly((InputStream)postCodesStream);
        }
        IOUtils.closeQuietly((Closeable)importer);
        IOUtils.closeQuietly((InputStream)osmStream);
        IOUtils.closeQuietly((InputStream)inseeStream);
        IOUtils.closeQuietly((InputStream)postCodesStream);
        String javaIoTmpDir = System.getProperty("java.io.tmpdir");
        File file = new File(javaIoTmpDir, "compareInseeAndOsmCommunes.log");
        log.warn((Object)("Comparaison des codes postaux OSM/INSEE disponible dans le fichier : " + file.getAbsolutePath()));
        FileWriter writer = new FileWriter(file);
        Collection communesComparisons = comparisons.values();
        Collection osmOnly = Collections2.filter(communesComparisons, (Predicate)new Predicate<InseeAndOsmCommunesComparison>(){

            public boolean apply(InseeAndOsmCommunesComparison iaocc) {
                return iaocc.isInOsmReferential() && !iaocc.isInInseeReferential();
            }
        });
        ArrayList sorted = Lists.newArrayList((Iterable)osmOnly);
        Collections.sort(sorted, COMMUNES_COMPARISON_COMPARATOR);
        writer.write(String.format("Codes INSEE seulement dans le r\u00e9f\u00e9rentiel OSM : %d%n", osmOnly.size()));
        for (InseeAndOsmCommunesComparison iaocc : sorted) {
            writer.write(String.format(" - %s %s%n", iaocc.getInseeCode(), iaocc.getOsmName()));
        }
        writer.write(String.format("%n", new Object[0]));
        Collection inseeOnly = Collections2.filter(communesComparisons, (Predicate)new Predicate<InseeAndOsmCommunesComparison>(){

            public boolean apply(InseeAndOsmCommunesComparison iaocc) {
                return !iaocc.isInOsmReferential() && iaocc.isInInseeReferential();
            }
        });
        sorted = Lists.newArrayList((Iterable)inseeOnly);
        Collections.sort(sorted, COMMUNES_COMPARISON_COMPARATOR);
        writer.write(String.format("Codes INSEE seulement dans le r\u00e9f\u00e9rentiel de l'INSEE : %d%n", inseeOnly.size()));
        for (InseeAndOsmCommunesComparison iaocc : sorted) {
            writer.write(String.format(" - %s %s%n", iaocc.getInseeCode(), iaocc.getInseeName()));
        }
        writer.write(String.format("%n", new Object[0]));
        Collection differentPostCodes = Collections2.filter(communesComparisons, (Predicate)new Predicate<InseeAndOsmCommunesComparison>(){

            public boolean apply(InseeAndOsmCommunesComparison iaocc) {
                return iaocc.isInOsmReferential() && iaocc.isInInseeReferential() && ObjectUtils.notEqual((Object)iaocc.getInseePostCode(), (Object)iaocc.getOsmPostCode());
            }
        });
        sorted = Lists.newArrayList((Iterable)differentPostCodes);
        Collections.sort(sorted, COMMUNES_COMPARISON_COMPARATOR);
        writer.write(String.format("Codes postaux diff\u00e9rents '<Code INSEE> : <Code postal INSEE>/<Code postal OSM> (<Commune>)' : %d%n", differentPostCodes.size()));
        for (InseeAndOsmCommunesComparison iaocc : sorted) {
            writer.write(String.format(" - %s : %s/%s (%s)%n", iaocc.getInseeCode(), iaocc.getInseePostCode(), iaocc.getOsmPostCode(), iaocc.getInseeName()));
        }
        writer.write(String.format("%n", new Object[0]));
        Collection differentNames = Collections2.filter(communesComparisons, (Predicate)new Predicate<InseeAndOsmCommunesComparison>(){

            public boolean apply(InseeAndOsmCommunesComparison iaocc) {
                return iaocc.isInOsmReferential() && iaocc.isInInseeReferential() && ObjectUtils.notEqual((Object)iaocc.getInseeName(), (Object)iaocc.getOsmName());
            }
        });
        sorted = Lists.newArrayList((Iterable)differentNames);
        Collections.sort(sorted, COMMUNES_COMPARISON_COMPARATOR);
        writer.write(String.format("Noms diff\u00e9rents '<Code INSEE> : <Nom INSEE>/<Nom OSM>' : %d%n", differentNames.size()));
        for (InseeAndOsmCommunesComparison iaocc : sorted) {
            writer.write(String.format(" - %s : %s/%s%n", iaocc.getInseeCode(), iaocc.getInseeName(), iaocc.getOsmName()));
        }
        writer.write(String.format("%n", new Object[0]));
        writer.close();
    }

    @Test
    public void testImportSolArvalis() {
        ImportResult result = this.testDatas.importSolArvalis();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
        Map solArvalisRegions = this.referentialService.getSolArvalisRegions();
        Assert.assertEquals((long)2L, (long)solArvalisRegions.size());
        Assert.assertEquals((Object)"Alsace", solArvalisRegions.get(42));
        Assert.assertEquals((Object)"Aquitaine", solArvalisRegions.get(72));
        List refSolArvalis = this.referentialService.getSolArvalis(Integer.valueOf(72));
        Assert.assertEquals((long)28L, (long)refSolArvalis.size());
    }

    @Test
    public void testImportLegalStatus() {
        ImportResult result = this.testDatas.importLegalStatus();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)9L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportEspeces() {
        InputStream stream = null;
        try {
            stream = ImportServiceTest.class.getResourceAsStream("/referentiels/test/cultures_AEE_complet.csv");
            ImportResult result = this.importService.importEspeces(stream);
            Assert.assertFalse((boolean)result.hasErrors());
            Assert.assertEquals((long)58L, (long)result.getCreated());
            Assert.assertEquals((long)0L, (long)result.getIgnored());
            Assert.assertEquals((long)0L, (long)result.getUpdated());
            Assert.assertEquals((long)0L, (long)result.getDeleted());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportVarieteGeves() {
        InputStream stream = null;
        try {
            stream = ImportServiceTest.class.getResourceAsStream("/referentiels/test/varietes_GEVES.csv");
            ImportResult result = this.importService.importVarietesGeves(stream);
            Assert.assertFalse((boolean)result.hasErrors());
            Assert.assertEquals((long)52L, (long)result.getCreated());
            Assert.assertEquals((long)0L, (long)result.getIgnored());
            Assert.assertEquals((long)0L, (long)result.getUpdated());
            Assert.assertEquals((long)0L, (long)result.getDeleted());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Test
    public void testImportVarietePlantGrape() {
        ImportResult result = this.testDatas.importVarietePlantGrape();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)52L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportClonesPlantGrape() {
        ImportResult result = this.testDatas.importClonesPlantGrape();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportEspecesToVarietes() {
        ImportResult result = this.testDatas.importEspecesToVarietes();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportOTEX() {
        ImportResult result = this.testDatas.importOTEX();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportOrientationEdi() {
        ImportResult result = this.testDatas.importOrientationEdi();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)8L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportParcelleZonageEdi() {
        ImportResult result = this.testDatas.importParcelleZonageEdi();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)6L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportSolProfondeurIndigo() {
        ImportResult result = this.testDatas.importSolProfondeurIndigo();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)4L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportSolTextureGeppa() {
        ImportResult result = this.testDatas.importSolTextureGeppa();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)17L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportSolCaracteristiquesIndigo() {
        ImportResult result = this.testDatas.importSolCaracteristiquesIndigo();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)35L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportUnitesEdi() {
        ImportResult result = this.testDatas.importUnitesEdi();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)14L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportFertiMinUnifa() {
        InputStream stream = null;
        try {
            stream = ImportServiceTest.class.getResourceAsStream("/referentiels/test/ferti_min_UNIFA.csv");
            ImportResult result = this.importService.importFertiMinUNIFA(stream);
            Assert.assertFalse((boolean)result.hasErrors());
            Assert.assertEquals((long)35L, (long)result.getCreated());
            Assert.assertEquals((long)0L, (long)result.getIgnored());
            Assert.assertEquals((long)15L, (long)result.getUpdated());
            Assert.assertEquals((long)0L, (long)result.getDeleted());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportFertiMinUnifaWithNull() {
        RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao = this.getPersistenceContext().getRefFertiMinUNIFADao();
        RefFertiMinUNIFA fertiMin = (RefFertiMinUNIFA)refFertiMinUNIFATopiaDao.create("categ", (Object)108, new Object[]{"type_produit", "SULFONITRATE", "codeprod", "0001080012100", "forme", "Granul\u00e9", "n", 21.0, "calcium", 11.0, "mgO", 0.0, "sO3", 16.0, "source", "UNIFA"});
        PriceTopiaDao priceDao = this.getPersistenceContext().getPriceDao();
        Price p = (Price)priceDao.create("displayName", (Object)"test", new Object[]{"category", "test", "type", PriceType.INPUT, "objectId", StringUtils.stripAccents((String)((String)Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL.apply((Object)fertiMin))), "priceUnit", PriceUnit.EURO_KG, "sourceUnit", "test"});
        this.getCurrentTransaction().commit();
        InputStream stream = null;
        try {
            stream = ImportServiceTest.class.getResourceAsStream("/referentiels/test/ferti_min_UNIFA.csv");
            ImportResult result = this.importService.importFertiMinUNIFA(stream);
            Assert.assertFalse((boolean)result.hasErrors());
            Assert.assertEquals((long)34L, (long)result.getCreated());
            Assert.assertEquals((long)0L, (long)result.getIgnored());
            Assert.assertEquals((long)16L, (long)result.getUpdated());
            Assert.assertEquals((long)0L, (long)result.getDeleted());
            p = (Price)priceDao.forTopiaIdEquals(p.getTopiaId()).findUnique();
            Assert.assertEquals((Object)StringUtils.stripAccents((String)((String)Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL.apply((Object)fertiMin))), (Object)p.getObjectId());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="deprecated previous behaviours")
    @Test
    public void testImportFertiMinUnifaWithoutNull() {
        RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao = this.getPersistenceContext().getRefFertiMinUNIFADao();
        RefFertiMinUNIFA fertiMin = (RefFertiMinUNIFA)refFertiMinUNIFATopiaDao.create("categ", (Object)108, new Object[]{"type_produit", "SULFONITRATE", "codeprod", "0001080012100", "forme", "Granul\u00e9", "n", 21.0, "p2O5", 0.0, "k2O", 0.0, "bore", 0.0, "calcium", 11.0, "fer", 0.0, "manganese", 0.0, "molybdene", 0.0, "mgO", 0.0, "oxyde_de_sodium", 0.0, "sO3", 16.0, "cuivre", 0.0, "zinc", 0.0, "source", "UNIFA"});
        PriceTopiaDao priceDao = this.getPersistenceContext().getPriceDao();
        Price p = (Price)priceDao.create("displayName", (Object)"test", new Object[]{"category", "test", "type", PriceType.INPUT, "objectId", fertiMin.getTopiaId(), "priceUnit", PriceUnit.EURO_KG, "sourceUnit", "test"});
        this.getCurrentTransaction().commit();
        InputStream stream = null;
        try {
            stream = ImportServiceTest.class.getResourceAsStream("/referentiels/test/ferti_min_UNIFA.csv");
            ImportResult result = this.importService.importFertiMinUNIFA(stream);
            Assert.assertFalse((boolean)result.hasErrors());
            Assert.assertEquals((long)34L, (long)result.getCreated());
            Assert.assertEquals((long)0L, (long)result.getIgnored());
            Assert.assertEquals((long)16L, (long)result.getUpdated());
            Assert.assertEquals((long)0L, (long)result.getDeleted());
            p = (Price)priceDao.forTopiaIdEquals(p.getTopiaId()).findUnique();
            Assert.assertEquals((Object)Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL.apply((Object)fertiMin), (Object)p.getObjectId());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Test
    public void testImportAdventices() {
        ImportResult result = this.testDatas.importAdventices();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)48L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportNuisiblesEDI() {
        InputStream stream = null;
        try {
            stream = ImportServiceTest.class.getResourceAsStream("/referentiels/test/nuisibles_edi.csv");
            ImportResult result = this.importService.importNuisiblesEDI(stream);
            Assert.assertFalse((boolean)result.hasErrors());
            Assert.assertEquals((long)50L, (long)result.getCreated());
            Assert.assertEquals((long)0L, (long)result.getUpdated());
            Assert.assertEquals((long)0L, (long)result.getDeleted());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Test
    public void testImportFertiTypesEffluents() {
        ImportResult result = this.testDatas.importFertiOrga();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)46L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportStadesEDI() {
        InputStream stream = null;
        try {
            stream = Test.class.getResourceAsStream("/referentiels/test/stades_EDI.csv");
            ImportResult result = this.importService.importStadesEdiCSV(stream);
            Assert.assertFalse((boolean)result.hasErrors());
            Assert.assertEquals((long)50L, (long)result.getCreated());
            Assert.assertEquals((long)0L, (long)result.getIgnored());
            Assert.assertEquals((long)0L, (long)result.getUpdated());
            Assert.assertEquals((long)0L, (long)result.getDeleted());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Test
    public void testImportActionAgrosystTravailEdi() {
        ImportResult result = this.testDatas.importInterventionAgrosystTravailEdi();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportFertiEngraisorg() {
        ImportResult result = this.testDatas.importFertiEngraisorg();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportTypeTravailEDI() {
        ImportResult result = this.testDatas.importTypeTravailEDI();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportStationMeteo() {
        ImportResult result = this.testDatas.importStationMeteo();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)47L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportGesCarburants() {
        ImportResult result = this.testDatas.importGesCarburants();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)1L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportGesEngrais() {
        ImportResult result = this.testDatas.importGesEngrais();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)14L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportGesPhyto() {
        ImportResult result = this.testDatas.importGesPhyto();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)5L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportGesSemences() {
        ImportResult result = this.testDatas.importGesSemences();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)11L, (long)result.getCreated());
        Assert.assertEquals((long)1L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportNrjCarburants() {
        ImportResult result = this.testDatas.importNrjCarburants();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)1L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportNrjEngrais() {
        ImportResult result = this.testDatas.importNrjEngrais();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)14L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportNrjPhyto() {
        ImportResult result = this.testDatas.importNrjPhyto();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)5L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportNrjSemences() {
        ImportResult result = this.testDatas.importNrjSemences();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)11L, (long)result.getCreated());
        Assert.assertEquals((long)1L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportNjrGesOutils() {
        ImportResult result = this.testDatas.importNrjGesOutils();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)5L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportMesure() {
        ImportResult result = this.testDatas.importMesure();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)49L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportInterventionsAgrosystTravailEdi() {
        ImportResult result = this.testDatas.importInterventionAgrosystTravailEdi();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportStadeNuisibleEDI() {
        ImportResult result = this.testDatas.importStadeNuisibleEDI();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportTypeNotationEDI() {
        ImportResult result = this.testDatas.importTypeNotationEDI();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)8L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportValeurQualitativeEDI() {
        ImportResult result = this.testDatas.importValeurQualitativeEDI();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportUnitesQualifiantEDI() {
        ImportResult result = this.testDatas.importUnitesQualifiantEDI();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportSupportOrganeEdi() {
        ImportResult result = this.testDatas.importSupportOrganeEdi();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportActaTraitementsProduits() {
        ImportResult result = this.testDatas.importActaTraitementsProduits();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)58L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportActaSubstanceActive() {
        ImportResult result = this.testDatas.importActaSubstanceActive();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)51L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportProtocoleVgObs() {
        ImportResult result = this.testDatas.importProtocoleVgObs();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportElementVoisinage() {
        ImportResult result = this.testDatas.importElementVoisinage();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)19L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportPhytoSubstanceActiveIphy() {
        ImportResult result = this.testDatas.importPhytoSubstanceActiveIphy();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)63L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportTypeAgriculture() {
        ImportResult result = this.testDatas.importTypeAgriculture();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)4L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportActaDosageSpc() {
        ImportResult result = this.testDatas.importActaDosageSpc();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)220L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportActaGroupeCultures() {
        ImportResult result = this.testDatas.importActaGroupeCultures();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)50L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportLienCulturesEdiActa() {
        ImportResult result = this.testDatas.importLienCulturesEdiActa();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)52L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportSaActaIphy() {
        ImportResult result = this.testDatas.importSaActaIphy();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)54L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportCultureEdiGroupeCouvSol() {
        ImportResult result = this.testDatas.importCultureEdiGroupeCouvSol();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)56L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportCouvSolAnnuelle() {
        ImportResult result = this.testDatas.importCouvSolAnnuelle();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)1404L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportCouvSolPerenne() {
        ImportResult result = this.testDatas.importCouvSolPerenne();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)432L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportTraitSdC() {
        ImportResult result = this.testDatas.importTraitSdC();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)13L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }

    @Test
    public void testImportZoneClimatiqueIphy() {
        ImportResult result = this.testDatas.importZoneClimatiqueIphy();
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((long)96L, (long)result.getCreated());
        Assert.assertEquals((long)0L, (long)result.getIgnored());
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
    }
}

