/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential;

import fr.inra.agrosyst.api.services.referential.ExportService;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.referential.ImportServiceTest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ExportServiceTest
extends AbstractAgrosystTest {
    private static final Log log = LogFactory.getLog(ExportServiceTest.class);
    protected ImportService importService;
    protected ExportService exportService;
    protected ReferentialService referentialService;
    protected TestDatas testDatas;

    @Before
    public void setupServices() {
        this.importService = (ImportService)this.serviceFactory.newService(ImportService.class);
        this.exportService = (ExportService)this.serviceFactory.newService(ExportService.class);
        this.referentialService = (ReferentialService)this.serviceFactory.newService(ReferentialService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportSolsArvalis() throws IOException {
        ImportResult result = this.testDatas.importSolArvalis();
        InputStream is = this.exportService.exportSolArvalisCSV(null);
        InputStream regionsStream = null;
        try {
            regionsStream = ImportServiceTest.class.getResourceAsStream("/referentiels/test/sols_regions.csv");
            ImportResult result2 = this.importService.importSolArvalisCSV(is, regionsStream);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((InputStream)regionsStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportOrientationEDI() throws IOException {
        ImportResult result = this.testDatas.importOrientationEdi();
        InputStream is = this.exportService.exportOrientationEdiCSV(null);
        try {
            ImportResult result2 = this.importService.importOrientationEdiCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMaterielAutomoteur() throws IOException {
        ImportResult result = this.testDatas.importMaterielsAutomoteur();
        InputStream is = this.exportService.exportMaterielAutomoteursCSV(null);
        try {
            ImportResult result2 = this.importService.importMaterielAutomoteursCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMaterielIrrigation() throws IOException {
        ImportResult result = this.testDatas.importMaterielsIrrigation();
        InputStream is = this.exportService.exportMaterielIrrigationCSV(null);
        try {
            ImportResult result2 = this.importService.importMaterielIrrigationCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMaterielOutils() throws IOException {
        ImportResult result = this.testDatas.importMaterielsOutils();
        InputStream is = this.exportService.exportMaterielOutilsCSV(null);
        try {
            ImportResult result2 = this.importService.importMaterielOutilsCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMaterielTraction() throws IOException {
        ImportResult result = this.testDatas.importMaterielsTracteur();
        InputStream is = this.exportService.exportMaterielTracteursCSV(null);
        try {
            ImportResult result2 = this.importService.importMaterielTracteursCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportLegalStatus() {
        ImportResult result = this.testDatas.importLegalStatus();
        InputStream is = this.exportService.exportLegalStatusCSV(null);
        try {
            ImportResult result2 = this.importService.importLegalStatusCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportEspeces() {
        ImportResult result = this.testDatas.importEspeces();
        InputStream is = this.exportService.exportEspeces(null);
        try {
            ImportResult result2 = this.importService.importEspeces(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testExportVarieteGeves() {
        ImportResult result = this.testDatas.importVarieteGeves();
        InputStream is = this.exportService.exportEspecesToVarietes(null);
        try {
            ImportResult result2 = this.importService.importVarietesGeves(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportVarietePlantGrape() {
        ImportResult result = this.testDatas.importVarietePlantGrape();
        InputStream is = this.exportService.exportVarietesPlantGrape(null);
        try {
            ImportResult result2 = this.importService.importVarietesPlantGrape(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportClonesPlantGrape() {
        ImportResult result = this.testDatas.importClonesPlantGrape();
        InputStream is = this.exportService.exportClonesPlantGrape(null);
        try {
            ImportResult result2 = this.importService.importClonesPlantGrape(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportEspecesToVarietes() {
        ImportResult result = this.testDatas.importEspecesToVarietes();
        InputStream is = this.exportService.exportEspecesToVarietes(null);
        try {
            ImportResult result2 = this.importService.importEspecesToVarietes(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportOTEX() {
        ImportResult result = this.testDatas.importOTEX();
        InputStream is = this.exportService.exportOtexCSV(null);
        try {
            ImportResult result2 = this.importService.importOtexCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportParcelleZonageEdi() {
        ImportResult result = this.testDatas.importParcelleZonageEdi();
        InputStream is = this.exportService.exportZonageParcelleEdi(null);
        try {
            ImportResult result2 = this.importService.importZonageParcelleEdi(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportSolProfondeurIndigo() {
        ImportResult result = this.testDatas.importSolProfondeurIndigo();
        InputStream is = this.exportService.exportSolProfondeurIndigo(null);
        try {
            ImportResult result2 = this.importService.importSolProfondeurIndigo(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportSolTextureGeppa() {
        ImportResult result = this.testDatas.importSolTextureGeppa();
        InputStream is = this.exportService.exportSolTextureGeppa(null);
        try {
            ImportResult result2 = this.importService.importSolTextureGeppa(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportSolCaracteristiquesIndigo() throws IOException {
        ImportResult result = this.testDatas.importSolCaracteristiquesIndigo();
        InputStream is = this.exportService.exportSolCarateristiquesIndigo(null);
        try {
            ImportResult result2 = this.importService.importSolCarateristiquesIndigo(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportUniteEDI() {
        ImportResult result = this.testDatas.importUnitesEdi();
        InputStream is = this.exportService.exportUniteEDI(null);
        try {
            ImportResult result2 = this.importService.importUniteEDI(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportFertyMinUnifa() {
        ImportResult result = this.testDatas.importFertiMinUnifa();
        long before = System.currentTimeMillis();
        InputStream is = this.exportService.exportFertiMinUNIFA(null);
        if (log.isInfoEnabled()) {
            long after = System.currentTimeMillis();
            log.info((Object)("Export took " + (after - before) + " ms"));
        }
        try {
            ImportResult result2 = this.importService.importFertiMinUNIFA(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportAdventices() {
        ImportResult result = this.testDatas.importAdventices();
        InputStream is = this.exportService.exportAdventices(null);
        try {
            ImportResult result2 = this.importService.importAdventices(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportNuisiblesEDI() {
        ImportResult result = this.testDatas.importNuisiblesEDI();
        InputStream is = this.exportService.exportNuisiblesEDI(null);
        try {
            ImportResult result2 = this.importService.importNuisiblesEDI(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportFertiOrga() {
        ImportResult result = this.testDatas.importFertiOrga();
        InputStream is = this.exportService.exportFertiOrga(null);
        try {
            ImportResult result2 = this.importService.importFertiOrga(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportStadeEDI() {
        ImportResult result = this.testDatas.importStadesEDI();
        InputStream is = this.exportService.exportStadesEdiCSV(null);
        try {
            ImportResult result2 = this.importService.importStadesEdiCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportActionAgrosystTravailEdi() {
        ImportResult result = this.testDatas.importInterventionAgrosystTravailEdi();
        InputStream is = this.exportService.exportInterventionAgrosystTravailEdiCSV(null);
        try {
            ImportResult result2 = this.importService.importInterventionAgrosystTravailEdiCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportFertiEngraisorg() {
        ImportResult result = this.testDatas.importFertiEngraisorg();
        InputStream is = this.exportService.exportFertiEngraisOrg(null);
        try {
            ImportResult result2 = this.importService.importFertiEngraisOrg(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportTypeTravailEDI() {
        ImportResult result = this.testDatas.importTypeTravailEDI();
        InputStream is = this.exportService.exportTypeTravailEdiCSV(null);
        try {
            ImportResult result2 = this.importService.importTypeTravailEdiCSV(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportStationMeteo() {
        ImportResult result = this.testDatas.importStationMeteo();
        InputStream is = this.exportService.exportStationMeteo(null);
        try {
            ImportResult result2 = this.importService.importStationMeteo(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMesure() {
        ImportResult result = this.testDatas.importMesure();
        InputStream is = this.exportService.exportMesure(null);
        try {
            ImportResult result2 = this.importService.importMesure(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportSupportOrganeEdi() {
        ImportResult result = this.testDatas.importSupportOrganeEdi();
        InputStream is = this.exportService.exportSupportOrganeEDI(null);
        try {
            ImportResult result2 = this.importService.importSupportOrganeEDI(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportStadeNuisibleEDI() {
        ImportResult result = this.testDatas.importStadeNuisibleEDI();
        InputStream is = this.exportService.exportStadeNuisibleEDI(null);
        try {
            ImportResult result2 = this.importService.importStadeNuisibleEDI(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportTypeNotationEDI() {
        ImportResult result = this.testDatas.importTypeNotationEDI();
        InputStream is = this.exportService.exportTypeNotationEDI(null);
        try {
            ImportResult result2 = this.importService.importTypeNotationEDI(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportValeurQualitativeEDI() {
        ImportResult result = this.testDatas.importValeurQualitativeEDI();
        InputStream is = this.exportService.exportValeurQualitativeEDI(null);
        try {
            ImportResult result2 = this.importService.importValeurQualitativeEDI(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportUnitesQualifiantEDI() {
        ImportResult result = this.testDatas.importUnitesQualifiantEDI();
        InputStream is = this.exportService.exportUnitesQualifiantEDI(null);
        try {
            ImportResult result2 = this.importService.importUnitesQualifiantEDI(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportActaTraitementsProduits() {
        ImportResult result = this.testDatas.importActaTraitementsProduits();
        InputStream is = this.exportService.exportActaTraitementsProducts(null);
        try {
            ImportResult result2 = this.importService.importActaTraitementsProduits(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportElementVoisinage() {
        ImportResult result = this.testDatas.importElementVoisinage();
        InputStream is = this.exportService.exportElementVoisinage(null);
        try {
            ImportResult result2 = this.importService.importElementVoisinage(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportPhytoSubstanceActiveIphy() {
        ImportResult result = this.testDatas.importPhytoSubstanceActiveIphy();
        InputStream is = this.exportService.exportPhytoSubstanceActiveIphy(null);
        try {
            ImportResult result2 = this.importService.importPhytoSubstanceActiveIphy(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportTypeAgriculture() {
        ImportResult result = this.testDatas.importTypeAgriculture();
        InputStream is = this.exportService.exportTypeAgriculture(null);
        try {
            ImportResult result2 = this.importService.importTypeAgriculture(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportDosageSpc() {
        ImportResult result = this.testDatas.importActaDosageSpc();
        InputStream is = this.exportService.exportActaDosageSpc(null);
        try {
            ImportResult result2 = this.importService.importActaDosageSpc(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportTraitSdC() {
        ImportResult result = this.testDatas.importTraitSdC();
        InputStream is = this.exportService.exportTraitSdC(null);
        try {
            ImportResult result2 = this.importService.importTraitSdC(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportCultureEdiGroupeCouvSol() throws IOException {
        ImportResult result = this.testDatas.importCultureEdiGroupeCouvSol();
        InputStream is = this.exportService.exportCultureEdiGroupeCouvSol(null);
        try {
            ImportResult result2 = this.importService.importCultureEdiGroupeCouvSol(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportCouvSolPerenne() {
        ImportResult result = this.testDatas.importCouvSolPerenne();
        InputStream is = this.exportService.exportCouvSolPerenne(null);
        try {
            ImportResult result2 = this.importService.importCouvSolPerenne(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportCouvSolAnnuelle() {
        ImportResult result = this.testDatas.importCouvSolAnnuelle();
        InputStream is = this.exportService.exportCouvSolAnnuelle(null);
        try {
            ImportResult result2 = this.importService.importCouvSolAnnuelle(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportZoneClimatiqueIphy() {
        ImportResult result = this.testDatas.importZoneClimatiqueIphy();
        InputStream is = this.exportService.exportZoneClimatiqueIphy(null);
        try {
            ImportResult result2 = this.importService.importZoneClimatiqueIphy(is);
            Assert.assertEquals((long)0L, (long)result2.getCreated());
            Assert.assertEquals((long)result.getCreated(), (long)result2.getUpdated());
            Assert.assertFalse((boolean)result2.hasErrors());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

