/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.practiced;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.AbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.BiologicalControlAction;
import fr.inra.agrosyst.api.entities.action.BiologicalControlActionImpl;
import fr.inra.agrosyst.api.entities.action.BiologicalProductInputImpl;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingActionImpl;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingActionImpl;
import fr.inra.agrosyst.api.entities.action.MineralProductInputImpl;
import fr.inra.agrosyst.api.entities.action.OtherProductInputImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFATopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.api.services.itk.Itk;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleNodeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.practiced.PracticedInterventionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPerennialCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.practiced.RefStadeEdiDto;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.practiced.PracticedSystemServiceMock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.util.beans.BinderFactory;

public class PracticedSystemServiceImplTest
extends AbstractAgrosystTest {
    protected TestDatas testDatas;
    protected PracticedSystemService practicedSystemService;
    protected PracticedSystemServiceMock practicedSystemServiceMock;
    protected ImportService importService;
    protected RefStadeEDITopiaDao refStadeEDITopiaDao;
    protected GrowingSystemTopiaDao growingSystemTopiaDao;
    protected RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao;
    protected PracticedSystemTopiaDao practicedSystemTopiaDao;
    protected PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleTopiaDao;
    protected PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionTopiaDao;
    protected PracticedInterventionTopiaDao practicedInterventionTopiaDao;
    protected PracticedCropCycleNodeTopiaDao practicedCropCycleNodeTopiaDao;
    protected PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleTopiaDao;
    protected PracticedPlotTopiaDao practicedPlotDao;
    protected PracticedCropCycleSpeciesTopiaDao practicedCropCycleSpeciesTopiaDao;
    protected RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao;
    protected AbstractActionTopiaDao abstractActionTopiaDao;
    protected AbstractInputTopiaDao abstractInputDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesesTopiaDao;
    protected RefEspeceTopiaDao refEspeceTopiaDao;
    protected List<CroppingPlanEntry> croppingPlanEntries;
    protected List<GrowingSystem> growingSystems;

    protected static final Map<AgrosystInterventionType, List<RefInterventionAgrosystTravailEDI>> GET_REF_INTERVENTION_TRAVAIL_EDI_BY_TYPE(List<RefInterventionAgrosystTravailEDI> refActionAgrosystTravailEDIs) {
        HashMap result = Maps.newHashMap();
        if (refActionAgrosystTravailEDIs != null) {
            for (RefInterventionAgrosystTravailEDI refActionAgrosystTravailEDI : refActionAgrosystTravailEDIs) {
                AgrosystInterventionType type = refActionAgrosystTravailEDI.getIntervention_agrosyst();
                List travail = (List)result.get(type);
                if (travail == null) {
                    travail = Lists.newArrayList();
                    result.put(type, travail);
                }
                travail.add(refActionAgrosystTravailEDI);
            }
        }
        return result;
    }

    @Before
    public void prepareTest() {
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.testDatas.createCroppingPlanEntry();
        this.testDatas.createTestGrowingSystems();
        this.practicedSystemService = (PracticedSystemService)this.serviceFactory.newService(PracticedSystemService.class);
        this.importService = (ImportService)this.serviceFactory.newService(ImportService.class);
        this.loginAsAdmin();
        this.refStadeEDITopiaDao = this.getPersistenceContext().getRefStadeEDIDao();
        this.refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        this.growingSystemTopiaDao = this.getPersistenceContext().getGrowingSystemDao();
        this.croppingPlanEntryTopiaDao = this.getPersistenceContext().getCroppingPlanEntryDao();
        this.practicedSystemTopiaDao = this.getPersistenceContext().getPracticedSystemDao();
        this.practicedSeasonalCropCycleTopiaDao = this.getPersistenceContext().getPracticedSeasonalCropCycleDao();
        this.practicedCropCycleConnectionTopiaDao = this.getPersistenceContext().getPracticedCropCycleConnectionDao();
        this.practicedInterventionTopiaDao = this.getPersistenceContext().getPracticedInterventionDao();
        this.practicedCropCycleNodeTopiaDao = this.getPersistenceContext().getPracticedCropCycleNodeDao();
        this.practicedPerennialCropCycleTopiaDao = this.getPersistenceContext().getPracticedPerennialCropCycleDao();
        this.practicedPlotDao = this.getPersistenceContext().getPracticedPlotDao();
        this.abstractActionTopiaDao = this.getPersistenceContext().getAbstractActionDao();
        this.abstractInputDao = this.getPersistenceContext().getAbstractInputDao();
        this.croppingPlanSpeciesesTopiaDao = this.getPersistenceContext().getCroppingPlanSpeciesDao();
        this.refEspeceTopiaDao = this.getPersistenceContext().getRefEspeceDao();
        this.practicedCropCycleSpeciesTopiaDao = this.getPersistenceContext().getPracticedCropCycleSpeciesDao();
        this.croppingPlanEntries = this.croppingPlanEntryTopiaDao.findAll();
        this.growingSystems = this.growingSystemTopiaDao.forActiveEquals(true).findAll();
        this.refFertiMinUNIFATopiaDao = this.getPersistenceContext().getRefFertiMinUNIFADao();
        this.practicedSystemServiceMock = new PracticedSystemServiceMock(this.practicedSystemService);
        this.testDatas.importStadesEDI();
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importEspeces();
        this.testDatas.importFertiMinUnifa();
    }

    @Test
    public void createOrUpdatePracticedSeasonalCropCycle() {
        String campains = "2011, 2012, 2013";
        String practicedSystemName = "test-seasonnal";
        GrowingSystem gs = this.growingSystems.get(0);
        String domainCode = gs.getGrowingPlan().getDomain().getCode();
        PracticedSystemImpl practicedSystem = new PracticedSystemImpl();
        practicedSystem.setName(practicedSystemName);
        practicedSystem.setGrowingSystem(gs);
        practicedSystem.setCampaigns(campains);
        PracticedCropCycleNodeDto practicedCropCycleNodeDto1 = new PracticedCropCycleNodeDto();
        practicedCropCycleNodeDto1.setX(1);
        practicedCropCycleNodeDto1.setY(1);
        practicedCropCycleNodeDto1.setInitNodeFrequency(Double.valueOf(50.0));
        practicedCropCycleNodeDto1.setNodeId("new-node-1");
        practicedCropCycleNodeDto1.setCroppingPlanEntryCode(this.croppingPlanEntries.get(0).getCode());
        PracticedCropCycleNodeDto practicedCropCycleNodeDto2 = new PracticedCropCycleNodeDto();
        practicedCropCycleNodeDto2.setX(2);
        practicedCropCycleNodeDto2.setY(2);
        practicedCropCycleNodeDto2.setInitNodeFrequency(Double.valueOf(25.0));
        practicedCropCycleNodeDto2.setNodeId("new-node-2");
        practicedCropCycleNodeDto2.setCroppingPlanEntryCode(this.croppingPlanEntries.get(1).getCode());
        PracticedCropCycleNodeDto practicedCropCycleNodeDto3 = new PracticedCropCycleNodeDto();
        practicedCropCycleNodeDto3.setX(3);
        practicedCropCycleNodeDto3.setY(3);
        practicedCropCycleNodeDto3.setInitNodeFrequency(Double.valueOf(25.0));
        practicedCropCycleNodeDto3.setNodeId("new-node-3");
        practicedCropCycleNodeDto3.setCroppingPlanEntryCode(this.croppingPlanEntries.get(2).getCode());
        String interventionName = "intervention-test-0";
        List<AbstractAction> actions = this.createActions();
        List<AbstractInput> inputs = this.createInputs(actions);
        Map<AgrosystInterventionType, AbstractAction> indexedActions = this.getAgrosystInterventionTypeAbstractActionMap(actions);
        PracticedInterventionDto interventionDto = this.createIntervention(interventionName, actions, inputs, domainCode, 0);
        ArrayList interventions = Lists.newArrayList((Object[])new PracticedInterventionDto[]{interventionDto});
        PracticedCropCycleConnectionDto practicedCropCycleConnectionDto1 = new PracticedCropCycleConnectionDto();
        practicedCropCycleConnectionDto1.setSourceId("new-node-1");
        practicedCropCycleConnectionDto1.setTargetId("new-node-1");
        practicedCropCycleConnectionDto1.setCroppingPlanEntryFrequency(Double.valueOf(50.0));
        practicedCropCycleConnectionDto1.setInterventions((List)interventions);
        PracticedCropCycleConnectionDto practicedCropCycleConnectionDto2 = new PracticedCropCycleConnectionDto();
        practicedCropCycleConnectionDto2.setSourceId("new-node-2");
        practicedCropCycleConnectionDto2.setTargetId("new-node-2");
        practicedCropCycleConnectionDto2.setCroppingPlanEntryFrequency(Double.valueOf(25.0));
        PracticedCropCycleConnectionDto practicedCropCycleConnectionDto3 = new PracticedCropCycleConnectionDto();
        practicedCropCycleConnectionDto3.setSourceId("new-node-3");
        practicedCropCycleConnectionDto3.setTargetId("new-node-3");
        practicedCropCycleConnectionDto3.setCroppingPlanEntryFrequency(Double.valueOf(25.0));
        ArrayList cropCycleNodeDtos = Lists.newArrayList((Object[])new PracticedCropCycleNodeDto[]{practicedCropCycleNodeDto1, practicedCropCycleNodeDto2, practicedCropCycleNodeDto3});
        ArrayList cropCycleConnectionDtos = Lists.newArrayList((Object[])new PracticedCropCycleConnectionDto[]{practicedCropCycleConnectionDto1, practicedCropCycleConnectionDto2, practicedCropCycleConnectionDto3});
        PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto = new PracticedSeasonalCropCycleDto();
        practicedSeasonalCropCycleDto.setCropCycleConnectionDtos((List)cropCycleConnectionDtos);
        practicedSeasonalCropCycleDto.setCropCycleNodeDtos((List)cropCycleNodeDtos);
        ArrayList practicedSeasonalCropCycleDtos = Lists.newArrayList((Object[])new PracticedSeasonalCropCycleDto[]{practicedSeasonalCropCycleDto});
        List persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)0L, (long)persistedPracticedSystems.size());
        this.practicedSystemService.createOrUpdatePracticedSystem((PracticedSystem)practicedSystem, null, (List)practicedSeasonalCropCycleDtos, null);
        persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)1L, (long)persistedPracticedSystems.size());
        PracticedSystem persistedPracticedSystem = (PracticedSystem)persistedPracticedSystems.get(0);
        Assert.assertEquals((Object)campains, (Object)persistedPracticedSystem.getCampaigns());
        List practicedSeasonalCropCycles = this.practicedSeasonalCropCycleTopiaDao.forPracticedSystemEquals(persistedPracticedSystem).findAll();
        Assert.assertEquals((long)1L, (long)practicedSeasonalCropCycles.size());
        PracticedSeasonalCropCycle practicedSeasonalCropCycle = (PracticedSeasonalCropCycle)practicedSeasonalCropCycles.get(0);
        Assert.assertNotNull((Object)practicedSeasonalCropCycle);
        Collection practicedCropCycleNodes = practicedSeasonalCropCycle.getCropCycleNodes();
        Assert.assertEquals((long)3L, (long)practicedCropCycleNodes.size());
        List practicedCropCycleConnections = this.practicedCropCycleConnectionTopiaDao.findAllByCropCycle(practicedSeasonalCropCycle.getTopiaId());
        Assert.assertEquals((long)3L, (long)practicedCropCycleConnections.size());
        ArrayList practicedInterventions = Lists.newArrayList();
        for (PracticedCropCycleConnection practicedCropCycleConnection : practicedCropCycleConnections) {
            Assert.assertNotNull((Object)practicedCropCycleConnection.getSource());
            Assert.assertNotNull((Object)practicedCropCycleConnection.getTarget());
            List persitedInterverventions = this.practicedInterventionTopiaDao.forPracticedCropCycleConnectionEquals(practicedCropCycleConnection).findAll();
            if (persitedInterverventions == null) continue;
            practicedInterventions.addAll(persitedInterverventions);
        }
        Assert.assertEquals((long)1L, (long)practicedInterventions.size());
        PracticedIntervention practicedIntervention = (PracticedIntervention)practicedInterventions.get(0);
        Assert.assertEquals((Object)interventionName, (Object)practicedIntervention.getName());
        List persistedActions = this.abstractActionTopiaDao.forPracticedInterventionEquals(practicedIntervention).findAll();
        Assert.assertEquals((long)3L, (long)persistedActions.size());
        AbstractAction abstractAction = (AbstractAction)persistedActions.get(0);
        int nbActionChecked = this.getNbValidPersistedActions(actions, indexedActions, persistedActions);
        Assert.assertEquals((long)3L, (long)nbActionChecked);
        List persistedInputs = this.abstractInputDao.findAllByPracticedIntervention(practicedIntervention);
        Assert.assertEquals((long)3L, (long)persistedInputs.size());
        this.practicedSystemService.createOrUpdatePracticedSystem(persistedPracticedSystem, null, null, null);
        persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)1L, (long)persistedPracticedSystems.size());
        persistedPracticedSystem = (PracticedSystem)persistedPracticedSystems.get(0);
        Assert.assertEquals((Object)campains, (Object)persistedPracticedSystem.getCampaigns());
        practicedSeasonalCropCycles = this.practicedSeasonalCropCycleTopiaDao.forPracticedSystemEquals(persistedPracticedSystem).findAll();
        Assert.assertTrue((boolean)practicedSeasonalCropCycles.isEmpty());
        Assert.assertFalse((boolean)this.practicedInterventionTopiaDao.forTopiaIdEquals(practicedIntervention.getTopiaId()).exists());
        Assert.assertFalse((boolean)this.abstractActionTopiaDao.forTopiaIdEquals(abstractAction.getTopiaId()).exists());
    }

    @Test
    public void testInterventionRankOrderOnConnection() {
        String campains = "2011, 2012, 2013";
        String practicedSystemName = "test-seasonnal";
        GrowingSystem gs = this.growingSystems.get(0);
        String domainCode = gs.getGrowingPlan().getDomain().getCode();
        PracticedSystemImpl practicedSystem = new PracticedSystemImpl();
        practicedSystem.setName(practicedSystemName);
        practicedSystem.setGrowingSystem(gs);
        practicedSystem.setCampaigns(campains);
        PracticedCropCycleNodeDto practicedCropCycleNodeDto1 = new PracticedCropCycleNodeDto();
        practicedCropCycleNodeDto1.setX(1);
        practicedCropCycleNodeDto1.setY(1);
        practicedCropCycleNodeDto1.setInitNodeFrequency(Double.valueOf(50.0));
        practicedCropCycleNodeDto1.setNodeId("new-node-1");
        practicedCropCycleNodeDto1.setCroppingPlanEntryCode(this.croppingPlanEntries.get(0).getCode());
        PracticedCropCycleNodeDto practicedCropCycleNodeDto2 = new PracticedCropCycleNodeDto();
        practicedCropCycleNodeDto2.setX(2);
        practicedCropCycleNodeDto2.setY(2);
        practicedCropCycleNodeDto2.setInitNodeFrequency(Double.valueOf(25.0));
        practicedCropCycleNodeDto2.setNodeId("new-node-2");
        practicedCropCycleNodeDto2.setCroppingPlanEntryCode(this.croppingPlanEntries.get(1).getCode());
        PracticedCropCycleNodeDto practicedCropCycleNodeDto3 = new PracticedCropCycleNodeDto();
        practicedCropCycleNodeDto3.setX(3);
        practicedCropCycleNodeDto3.setY(3);
        practicedCropCycleNodeDto3.setInitNodeFrequency(Double.valueOf(25.0));
        practicedCropCycleNodeDto3.setNodeId("new-node-3");
        practicedCropCycleNodeDto3.setCroppingPlanEntryCode(this.croppingPlanEntries.get(2).getCode());
        String[] interventionName = new String[]{"intervention-test-1", "intervention-test-2", "intervention-test-3"};
        List<AbstractAction> actions = this.createActions();
        List<AbstractInput> inputs = this.createInputs(actions);
        PracticedInterventionDto interventionDto1 = this.createIntervention(interventionName[0], actions, inputs, domainCode, 0);
        actions = this.createActions();
        inputs = this.createInputs(actions);
        PracticedInterventionDto interventionDto2 = this.createIntervention(interventionName[1], actions, inputs, domainCode, 2);
        actions = this.createActions();
        inputs = this.createInputs(actions);
        PracticedInterventionDto interventionDto3 = this.createIntervention(interventionName[2], actions, inputs, domainCode, 4);
        ArrayList interventions = Lists.newArrayList((Object[])new PracticedInterventionDto[]{interventionDto1, interventionDto2, interventionDto3});
        PracticedCropCycleConnectionDto practicedCropCycleConnectionDto = new PracticedCropCycleConnectionDto();
        practicedCropCycleConnectionDto.setSourceId("new-node-1");
        practicedCropCycleConnectionDto.setTargetId("new-node-1");
        practicedCropCycleConnectionDto.setCroppingPlanEntryFrequency(Double.valueOf(50.0));
        practicedCropCycleConnectionDto.setInterventions((List)interventions);
        ArrayList cropCycleNodeDtos = Lists.newArrayList((Object[])new PracticedCropCycleNodeDto[]{practicedCropCycleNodeDto1, practicedCropCycleNodeDto2, practicedCropCycleNodeDto3});
        List cropCycleConnectionDtos = Lists.newArrayList((Object[])new PracticedCropCycleConnectionDto[]{practicedCropCycleConnectionDto});
        PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto = new PracticedSeasonalCropCycleDto();
        practicedSeasonalCropCycleDto.setCropCycleConnectionDtos(cropCycleConnectionDtos);
        practicedSeasonalCropCycleDto.setCropCycleNodeDtos((List)cropCycleNodeDtos);
        List practicedSeasonalCropCycleDtos = Lists.newArrayList((Object[])new PracticedSeasonalCropCycleDto[]{practicedSeasonalCropCycleDto});
        List persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)0L, (long)persistedPracticedSystems.size());
        PracticedSystem persistedPracticedSystem = this.practicedSystemService.createOrUpdatePracticedSystem((PracticedSystem)practicedSystem, null, practicedSeasonalCropCycleDtos, null);
        practicedSeasonalCropCycleDtos = this.practicedSystemService.getAllPracticedSeasonalCropCycles(persistedPracticedSystem.getTopiaId());
        practicedSeasonalCropCycleDto = (PracticedSeasonalCropCycleDto)practicedSeasonalCropCycleDtos.get(0);
        cropCycleConnectionDtos = practicedSeasonalCropCycleDto.getCropCycleConnectionDtos();
        PracticedCropCycleConnectionDto connectionDto = (PracticedCropCycleConnectionDto)cropCycleConnectionDtos.get(0);
        List interventionDtos = connectionDto.getInterventions();
        Assert.assertEquals((long)3L, (long)interventionDtos.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)((PracticedInterventionDto)interventionDtos.get(i)).getName().equals(interventionName[i]));
            Assert.assertEquals((long)i, (long)((PracticedInterventionDto)interventionDtos.get(i)).getRank());
        }
        ArrayList reorderedInterventions = Lists.newArrayList((Object[])new PracticedInterventionDto[]{(PracticedInterventionDto)interventionDtos.get(1), (PracticedInterventionDto)interventionDtos.get(0), (PracticedInterventionDto)interventionDtos.get(2)});
        String[] interventionName2 = new String[]{((PracticedInterventionDto)interventionDtos.get(1)).getName(), ((PracticedInterventionDto)interventionDtos.get(0)).getName(), ((PracticedInterventionDto)interventionDtos.get(2)).getName()};
        connectionDto.setInterventions((List)reorderedInterventions);
        persistedPracticedSystem = this.practicedSystemService.createOrUpdatePracticedSystem(persistedPracticedSystem, null, practicedSeasonalCropCycleDtos, null);
        practicedSeasonalCropCycleDtos = this.practicedSystemService.getAllPracticedSeasonalCropCycles(persistedPracticedSystem.getTopiaId());
        practicedSeasonalCropCycleDto = (PracticedSeasonalCropCycleDto)practicedSeasonalCropCycleDtos.get(0);
        cropCycleConnectionDtos = practicedSeasonalCropCycleDto.getCropCycleConnectionDtos();
        connectionDto = (PracticedCropCycleConnectionDto)cropCycleConnectionDtos.get(0);
        interventionDtos = connectionDto.getInterventions();
        Assert.assertEquals((long)3L, (long)interventionDtos.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)((PracticedInterventionDto)interventionDtos.get(i)).getName().equals(interventionName2[i]));
            Assert.assertEquals((long)i, (long)((PracticedInterventionDto)interventionDtos.get(i)).getRank());
        }
    }

    protected Map<AgrosystInterventionType, AbstractAction> getAgrosystInterventionTypeAbstractActionMap(List<AbstractAction> actions) {
        HashMap indexedActions = Maps.newHashMapWithExpectedSize((int)actions.size());
        for (AbstractAction action : actions) {
            indexedActions.put(action.getMainAction().getIntervention_agrosyst(), action);
        }
        return indexedActions;
    }

    protected List<AbstractAction> createActions() {
        List refActionAgrosystTravailEDIs = this.refActionAgrosystTravailEDITopiaDao.forActiveEquals(true).findAll();
        Map<AgrosystInterventionType, List<RefInterventionAgrosystTravailEDI>> travailByType = PracticedSystemServiceImplTest.GET_REF_INTERVENTION_TRAVAIL_EDI_BY_TYPE(refActionAgrosystTravailEDIs);
        List<RefInterventionAgrosystTravailEDI> travailEDIs = travailByType.get(AgrosystInterventionType.RECOLTE);
        HarvestingActionImpl harvestingAction = new HarvestingActionImpl();
        harvestingAction.setTopiaId("NEW-ACTION-" + UUID.randomUUID());
        harvestingAction.setMoisturePercent(Double.valueOf(90.0));
        harvestingAction.setExportedWaste(true);
        harvestingAction.setMainAction(travailEDIs.get(0));
        travailEDIs = travailByType.get(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX);
        MineralFertilizersSpreadingActionImpl mineralFertilizersSpreadingAction = new MineralFertilizersSpreadingActionImpl();
        mineralFertilizersSpreadingAction.setTopiaId("NEW-ACTION-" + UUID.randomUUID());
        mineralFertilizersSpreadingAction.setBurial(true);
        mineralFertilizersSpreadingAction.setLocalizedSpreading(true);
        mineralFertilizersSpreadingAction.setMainAction(travailEDIs.get(0));
        travailEDIs = travailByType.get(AgrosystInterventionType.LUTTE_BIOLOGIQUE);
        BiologicalControlActionImpl biologicalControlAction = new BiologicalControlActionImpl();
        biologicalControlAction.setTopiaId("NEW-ACTION-" + UUID.randomUUID());
        biologicalControlAction.setBoiledQuantity(12.5);
        biologicalControlAction.setProportionOfTreatedSurface(5.6);
        biologicalControlAction.setMainAction(travailEDIs.get(0));
        ArrayList actions = Lists.newArrayList((Object[])new AbstractAction[]{harvestingAction, mineralFertilizersSpreadingAction, biologicalControlAction});
        return actions;
    }

    protected List<AbstractInput> createInputs(List<AbstractAction> actions) {
        ArrayList result = Lists.newArrayList();
        for (AbstractAction action : actions) {
            if (action instanceof MineralFertilizersSpreadingAction) {
                MineralFertilizersSpreadingAction mfsa = (MineralFertilizersSpreadingAction)action;
                MineralFertilizersSpreadingActionImpl mineralFertilizersSpreadingAction = new MineralFertilizersSpreadingActionImpl();
                mineralFertilizersSpreadingAction.setTopiaId(mfsa.getTopiaId());
                mineralFertilizersSpreadingAction.setBurial(mfsa.isBurial());
                mineralFertilizersSpreadingAction.setLocalizedSpreading(mfsa.isLocalizedSpreading());
                mineralFertilizersSpreadingAction.setMainAction(mfsa.getMainAction());
                if (this.refFertiMinUNIFATopiaDao.count() == 0L) {
                    this.testDatas.importFertiMinUnifa();
                }
                MineralProductInputImpl mineralProductInput = new MineralProductInputImpl();
                mineralProductInput.setInputType(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX);
                mineralProductInput.setProductName("APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX");
                mineralProductInput.setMineralProduct((RefFertiMinUNIFA)this.refFertiMinUNIFATopiaDao.findAll().get(0));
                mineralProductInput.setMineralFertilizersSpreadingAction((MineralFertilizersSpreadingAction)mineralFertilizersSpreadingAction);
                result.add(mineralProductInput);
            }
            if (!(action instanceof BiologicalControlAction)) continue;
            BiologicalControlAction bca = (BiologicalControlAction)action;
            BiologicalControlActionImpl biologicalControlAction = new BiologicalControlActionImpl();
            biologicalControlAction.setTopiaId(bca.getTopiaId());
            biologicalControlAction.setBoiledQuantity(bca.getBoiledQuantity());
            biologicalControlAction.setProportionOfTreatedSurface(bca.getProportionOfTreatedSurface());
            biologicalControlAction.setMainAction(bca.getMainAction());
            BiologicalProductInputImpl biologicalProductInput = new BiologicalProductInputImpl();
            biologicalProductInput.setInputType(AgrosystInterventionType.LUTTE_BIOLOGIQUE);
            biologicalProductInput.setProductName("LUTTE_BIOLOGIQUE");
            biologicalProductInput.setBiologicalControlAction((BiologicalControlAction)biologicalControlAction);
            result.add(biologicalProductInput);
            OtherProductInputImpl otherProductInput = new OtherProductInputImpl();
            otherProductInput.setProductName("Produit pour traitmement biologique");
            otherProductInput.setBiologicalControlAction((BiologicalControlAction)biologicalControlAction);
            result.add(otherProductInput);
        }
        return result;
    }

    protected void compareMineralFertilizersSpreadingActions(MineralFertilizersSpreadingAction mineralFertilizersSpreadingAction, MineralFertilizersSpreadingAction persistedMineralFertilizersSpreadingAction) {
        Assert.assertEquals((Object)mineralFertilizersSpreadingAction.isBurial(), (Object)persistedMineralFertilizersSpreadingAction.isBurial());
        Assert.assertEquals((Object)mineralFertilizersSpreadingAction.isLocalizedSpreading(), (Object)persistedMineralFertilizersSpreadingAction.isLocalizedSpreading());
    }

    protected void compareHarvestingActions(HarvestingAction harvestingAction, HarvestingAction persistedHarvestingAction) {
        Assert.assertEquals((Object)harvestingAction.getMoisturePercent(), (Object)persistedHarvestingAction.getMoisturePercent());
        Assert.assertEquals((Object)harvestingAction.isExportedWaste(), (Object)persistedHarvestingAction.isExportedWaste());
        Assert.assertSame((Object)harvestingAction.getMainAction().getTopiaId(), (Object)persistedHarvestingAction.getMainAction().getTopiaId());
    }

    protected void compareBiologicalControlActions(BiologicalControlAction biologicalControlAction, BiologicalControlAction persistedBiologicalControlAction) {
        Assert.assertTrue((biologicalControlAction.getBoiledQuantity() == persistedBiologicalControlAction.getBoiledQuantity() ? 1 : 0) != 0);
        Assert.assertTrue((biologicalControlAction.getProportionOfTreatedSurface() == persistedBiologicalControlAction.getProportionOfTreatedSurface() ? 1 : 0) != 0);
        Assert.assertSame((Object)biologicalControlAction.getMainAction().getTopiaId(), (Object)persistedBiologicalControlAction.getMainAction().getTopiaId());
    }

    @Test
    public void createOrUpdatePracticedPerennialCropCycle() {
        String campains = "2011, 2012, 2013";
        String practicedSystemName = "test-Pernennial";
        String interventionName = "intervention-test-1";
        GrowingSystem gs = this.growingSystems.get(1);
        String domainCode = gs.getGrowingPlan().getDomain().getCode();
        PracticedSystemImpl practicedSystem = new PracticedSystemImpl();
        practicedSystem.setName(practicedSystemName);
        practicedSystem.setGrowingSystem(gs);
        practicedSystem.setCampaigns(campains);
        PracticedPerennialCropCycleDto practicedPerennialCropCycleDto = new PracticedPerennialCropCycleDto();
        PracticedCropCyclePhaseDto practicedCropCyclePhaseDto = new PracticedCropCyclePhaseDto();
        practicedCropCyclePhaseDto.setDuration(Integer.valueOf(10));
        practicedCropCyclePhaseDto.setType(CropCyclePhaseType.PLEINE_PRODUCTION);
        PracticedPerennialCropCycleImpl practicedPerennialCropCycle0 = new PracticedPerennialCropCycleImpl();
        practicedPerennialCropCycle0.setCroppingPlanEntryCode(this.croppingPlanEntries.get(0).getCode());
        practicedPerennialCropCycle0.setWeedType(WeedType.PARTIEL);
        ArrayList cropCyclePhaseDtos = Lists.newArrayList((Object[])new PracticedCropCyclePhaseDto[]{practicedCropCyclePhaseDto});
        practicedPerennialCropCycleDto.setCropCyclePhaseDtos((List)cropCyclePhaseDtos);
        practicedPerennialCropCycleDto.setPracticedPerennialCropCycle((PracticedPerennialCropCycle)practicedPerennialCropCycle0);
        String speciesCode = "001";
        List especes = this.refEspeceTopiaDao.forActiveEquals(true).findAll();
        this.croppingPlanSpeciesesTopiaDao.create("croppingPlanEntry", (Object)this.croppingPlanEntries.get(0), new Object[]{"species", especes.get(0), "code", speciesCode});
        PracticedCropCycleSpeciesDto practicedCropCycleSpeciesDto = new PracticedCropCycleSpeciesDto();
        practicedCropCycleSpeciesDto.setCode(speciesCode);
        ArrayList cropCycleSpeciesDtos = Lists.newArrayList((Object[])new PracticedCropCycleSpeciesDto[]{practicedCropCycleSpeciesDto});
        practicedPerennialCropCycleDto.setSpeciesDto((List)cropCycleSpeciesDtos);
        ArrayList actions = this.createActions();
        Map<AgrosystInterventionType, AbstractAction> indexedActions = this.getAgrosystInterventionTypeAbstractActionMap(actions);
        List<AbstractInput> inputs = this.createInputs(actions);
        PracticedInterventionDto interventionDto = this.createIntervention(interventionName, actions, inputs, domainCode, 0);
        List interventionDtos = Lists.newArrayList((Object[])new PracticedInterventionDto[]{interventionDto});
        practicedCropCyclePhaseDto.setInterventions(interventionDtos);
        List<Object> practicedPerennialCropCycleDtos = Lists.newArrayList((Object[])new PracticedPerennialCropCycleDto[]{practicedPerennialCropCycleDto});
        List persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)0L, (long)persistedPracticedSystems.size());
        this.practicedSystemService.createOrUpdatePracticedSystem((PracticedSystem)practicedSystem, (List)practicedPerennialCropCycleDtos, null, null);
        persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)1L, (long)persistedPracticedSystems.size());
        PracticedSystem persistedPracticedSystem = (PracticedSystem)persistedPracticedSystems.get(0);
        Assert.assertEquals((Object)campains, (Object)persistedPracticedSystem.getCampaigns());
        List practicedPerennialCropCycles = this.practicedPerennialCropCycleTopiaDao.forPracticedSystemEquals(persistedPracticedSystem).findAll();
        Assert.assertEquals((long)1L, (long)practicedPerennialCropCycles.size());
        PracticedPerennialCropCycle practicedPerennialCropCycle = (PracticedPerennialCropCycle)practicedPerennialCropCycles.get(0);
        Collection cropCyclePhases = practicedPerennialCropCycle.getCropCyclePhases();
        Assert.assertEquals((long)1L, (long)cropCyclePhases.size());
        PracticedCropCyclePhase cropCyclePhase = (PracticedCropCyclePhase)cropCyclePhases.iterator().next();
        List persistedInterventions = this.practicedInterventionTopiaDao.forPracticedCropCyclePhaseEquals(cropCyclePhase).findAll();
        Assert.assertEquals((long)1L, (long)persistedInterventions.size());
        PracticedIntervention practicedIntervention = (PracticedIntervention)persistedInterventions.get(0);
        Assert.assertEquals((Object)interventionName, (Object)practicedIntervention.getName());
        List persistedActions = this.abstractActionTopiaDao.forPracticedInterventionEquals(practicedIntervention).findAll();
        Assert.assertEquals((long)3L, (long)persistedActions.size());
        int nbActionChecked = this.getNbValidPersistedActions(actions, indexedActions, persistedActions);
        Assert.assertEquals((long)3L, (long)nbActionChecked);
        List persistedInputs = this.abstractInputDao.findAllByPracticedIntervention(practicedIntervention);
        Assert.assertEquals((long)3L, (long)persistedInputs.size());
        List practicedCropCycleSpecieses = this.practicedCropCycleSpeciesTopiaDao.forCroppingPlanSpeciesCodeEquals(speciesCode).findAll();
        Assert.assertEquals((long)1L, (long)practicedCropCycleSpecieses.size());
        PracticedPerennialCropCycle persistedPracticedPerennialCropCycle = ((PracticedCropCycleSpecies)practicedCropCycleSpecieses.get(0)).getCycle();
        Assert.assertEquals((Object)persistedPracticedPerennialCropCycle.getTopiaId(), (Object)practicedPerennialCropCycle.getTopiaId());
        practicedPerennialCropCycleDtos = this.practicedSystemServiceMock.convertPerennialCropCyclesToDto(practicedPerennialCropCycles, persistedPracticedSystem);
        practicedPerennialCropCycleDto = (PracticedPerennialCropCycleDto)practicedPerennialCropCycleDtos.get(0);
        List phases = practicedPerennialCropCycleDto.getCropCyclePhaseDtos();
        PracticedCropCyclePhaseDto phase = (PracticedCropCyclePhaseDto)phases.get(0);
        interventionDtos = phase.getInterventions();
        Assert.assertEquals((long)1L, (long)interventionDtos.size());
        interventionDto = (PracticedInterventionDto)interventionDtos.get(0);
        actions = Lists.newArrayList((Iterable)interventionDto.getActions());
        Assert.assertEquals((long)3L, (long)actions.size());
        this.practicedSystemService.createOrUpdatePracticedSystem((PracticedSystem)practicedSystem, practicedPerennialCropCycleDtos, null, null);
        persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)1L, (long)persistedPracticedSystems.size());
        persistedPracticedSystem = (PracticedSystem)persistedPracticedSystems.get(0);
        Assert.assertEquals((Object)campains, (Object)persistedPracticedSystem.getCampaigns());
        practicedPerennialCropCycles = this.practicedPerennialCropCycleTopiaDao.forPracticedSystemEquals(persistedPracticedSystem).findAll();
        Assert.assertEquals((long)1L, (long)practicedPerennialCropCycles.size());
        practicedPerennialCropCycle = (PracticedPerennialCropCycle)practicedPerennialCropCycles.get(0);
        cropCyclePhases = practicedPerennialCropCycle.getCropCyclePhases();
        Assert.assertEquals((long)1L, (long)cropCyclePhases.size());
        cropCyclePhase = (PracticedCropCyclePhase)cropCyclePhases.iterator().next();
        persistedInterventions = this.practicedInterventionTopiaDao.forPracticedCropCyclePhaseEquals(cropCyclePhase).findAll();
        Assert.assertEquals((long)1L, (long)persistedInterventions.size());
        practicedIntervention = (PracticedIntervention)persistedInterventions.get(0);
        Assert.assertEquals((Object)interventionName, (Object)practicedIntervention.getName());
        persistedActions = this.abstractActionTopiaDao.forPracticedInterventionEquals(practicedIntervention).findAll();
        Assert.assertEquals((long)3L, (long)persistedActions.size());
        nbActionChecked = this.getNbValidPersistedActions(actions, indexedActions, persistedActions);
        Assert.assertEquals((long)3L, (long)nbActionChecked);
        this.practicedSystemService.createOrUpdatePracticedSystem(persistedPracticedSystem, null, null, null);
        persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)1L, (long)persistedPracticedSystems.size());
        persistedPracticedSystem = (PracticedSystem)persistedPracticedSystems.get(0);
        Assert.assertEquals((Object)campains, (Object)persistedPracticedSystem.getCampaigns());
        practicedPerennialCropCycles = this.practicedPerennialCropCycleTopiaDao.forPracticedSystemEquals(persistedPracticedSystem).findAll();
        Assert.assertTrue((boolean)practicedPerennialCropCycles.isEmpty());
        Assert.assertFalse((boolean)this.practicedInterventionTopiaDao.forTopiaIdEquals(practicedIntervention.getTopiaId()).exists());
        for (AbstractAction persistedAction : persistedActions) {
            Assert.assertFalse((boolean)this.abstractActionTopiaDao.forTopiaIdEquals(persistedAction.getTopiaId()).exists());
        }
    }

    @Test
    public void testInterventionRankOnPhase() {
        String campains = "2011, 2012, 2013";
        String practicedSystemName = "test-Pernennial";
        GrowingSystem gs = this.growingSystems.get(1);
        String domainCode = gs.getGrowingPlan().getDomain().getCode();
        PracticedSystemImpl practicedSystem = new PracticedSystemImpl();
        practicedSystem.setName(practicedSystemName);
        practicedSystem.setGrowingSystem(gs);
        practicedSystem.setCampaigns(campains);
        PracticedPerennialCropCycleDto practicedPerennialCropCycleDto = new PracticedPerennialCropCycleDto();
        PracticedCropCyclePhaseDto practicedCropCyclePhaseDto = new PracticedCropCyclePhaseDto();
        practicedCropCyclePhaseDto.setDuration(Integer.valueOf(10));
        practicedCropCyclePhaseDto.setType(CropCyclePhaseType.PLEINE_PRODUCTION);
        PracticedPerennialCropCycleImpl practicedPerennialCropCycle0 = new PracticedPerennialCropCycleImpl();
        practicedPerennialCropCycle0.setCroppingPlanEntryCode(this.croppingPlanEntries.get(0).getCode());
        practicedPerennialCropCycle0.setWeedType(WeedType.PARTIEL);
        ArrayList cropCyclePhaseDtos = Lists.newArrayList((Object[])new PracticedCropCyclePhaseDto[]{practicedCropCyclePhaseDto});
        practicedPerennialCropCycleDto.setCropCyclePhaseDtos((List)cropCyclePhaseDtos);
        practicedPerennialCropCycleDto.setPracticedPerennialCropCycle((PracticedPerennialCropCycle)practicedPerennialCropCycle0);
        String speciesCode = "001";
        List especes = this.refEspeceTopiaDao.forActiveEquals(true).findAll();
        this.croppingPlanSpeciesesTopiaDao.create("croppingPlanEntry", (Object)this.croppingPlanEntries.get(0), new Object[]{"species", especes.get(0), "code", speciesCode});
        PracticedCropCycleSpeciesDto practicedCropCycleSpeciesDto = new PracticedCropCycleSpeciesDto();
        practicedCropCycleSpeciesDto.setCode(speciesCode);
        ArrayList cropCycleSpeciesDtos = Lists.newArrayList((Object[])new PracticedCropCycleSpeciesDto[]{practicedCropCycleSpeciesDto});
        practicedPerennialCropCycleDto.setSpeciesDto((List)cropCycleSpeciesDtos);
        List<AbstractAction> actions = this.createActions();
        List<AbstractInput> inputs = this.createInputs(actions);
        String[] interventionNames = new String[]{"I1", "I2", "I3"};
        PracticedInterventionDto interventionDto1 = this.createIntervention(interventionNames[0], actions, inputs, domainCode, 0);
        actions = this.createActions();
        inputs = this.createInputs(actions);
        PracticedInterventionDto interventionDto2 = this.createIntervention(interventionNames[1], actions, inputs, domainCode, 2);
        actions = this.createActions();
        inputs = this.createInputs(actions);
        PracticedInterventionDto interventionDto3 = this.createIntervention(interventionNames[2], actions, inputs, domainCode, 4);
        List interventionDtos = Lists.newArrayList((Object[])new PracticedInterventionDto[]{interventionDto1, interventionDto2, interventionDto3});
        practicedCropCyclePhaseDto.setInterventions(interventionDtos);
        List practicedPerennialCropCycleDtos = Lists.newArrayList((Object[])new PracticedPerennialCropCycleDto[]{practicedPerennialCropCycleDto});
        List persistedPracticedSystems = this.practicedSystemTopiaDao.forNameEquals(practicedSystemName).findAll();
        Assert.assertEquals((long)0L, (long)persistedPracticedSystems.size());
        PracticedSystem persistedPracticedSystem = this.practicedSystemService.createOrUpdatePracticedSystem((PracticedSystem)practicedSystem, practicedPerennialCropCycleDtos, null, null);
        practicedPerennialCropCycleDtos = this.practicedSystemService.getAllPracticedPerennialCropCycles(persistedPracticedSystem.getTopiaId());
        practicedPerennialCropCycleDto = (PracticedPerennialCropCycleDto)practicedPerennialCropCycleDtos.get(0);
        practicedCropCyclePhaseDto = (PracticedCropCyclePhaseDto)practicedPerennialCropCycleDto.getCropCyclePhaseDtos().get(0);
        interventionDtos = practicedCropCyclePhaseDto.getInterventions();
        Assert.assertEquals((long)3L, (long)interventionDtos.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)((PracticedInterventionDto)interventionDtos.get(i)).getName().equals(interventionNames[i]));
            Assert.assertEquals((long)i, (long)((PracticedInterventionDto)interventionDtos.get(i)).getRank());
        }
        ArrayList reorderedInterventions = Lists.newArrayList((Object[])new PracticedInterventionDto[]{(PracticedInterventionDto)interventionDtos.get(1), (PracticedInterventionDto)interventionDtos.get(0), (PracticedInterventionDto)interventionDtos.get(2)});
        String[] interventionName2 = new String[]{((PracticedInterventionDto)interventionDtos.get(1)).getName(), ((PracticedInterventionDto)interventionDtos.get(0)).getName(), ((PracticedInterventionDto)interventionDtos.get(2)).getName()};
        practicedCropCyclePhaseDto.setInterventions((List)reorderedInterventions);
        this.practicedSystemService.createOrUpdatePracticedSystem(persistedPracticedSystem, practicedPerennialCropCycleDtos, null, null);
        practicedPerennialCropCycleDtos = this.practicedSystemService.getAllPracticedPerennialCropCycles(persistedPracticedSystem.getTopiaId());
        practicedPerennialCropCycleDto = (PracticedPerennialCropCycleDto)practicedPerennialCropCycleDtos.get(0);
        practicedCropCyclePhaseDto = (PracticedCropCyclePhaseDto)practicedPerennialCropCycleDto.getCropCyclePhaseDtos().get(0);
        interventionDtos = practicedCropCyclePhaseDto.getInterventions();
        Assert.assertEquals((long)3L, (long)interventionDtos.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)((PracticedInterventionDto)interventionDtos.get(i)).getName().equals(interventionName2[i]));
            Assert.assertEquals((long)i, (long)((PracticedInterventionDto)interventionDtos.get(i)).getRank());
        }
    }

    protected int getNbValidPersistedActions(List<AbstractAction> actions, Map<AgrosystInterventionType, AbstractAction> indexedActions, List<AbstractAction> persistedActions) {
        int nbActionChecked = 0;
        for (AbstractAction persistedAction : persistedActions) {
            if (persistedAction instanceof HarvestingAction) {
                HarvestingAction persistedHarvestingAction = (HarvestingAction)persistedAction;
                this.compareHarvestingActions((HarvestingAction)indexedActions.get(AgrosystInterventionType.RECOLTE), persistedHarvestingAction);
                ++nbActionChecked;
                continue;
            }
            if (persistedAction instanceof MineralFertilizersSpreadingAction) {
                MineralFertilizersSpreadingAction persistedMineralFertilizersSpreadingAction = (MineralFertilizersSpreadingAction)persistedAction;
                this.compareMineralFertilizersSpreadingActions((MineralFertilizersSpreadingAction)indexedActions.get(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX), persistedMineralFertilizersSpreadingAction);
                ++nbActionChecked;
                continue;
            }
            if (!(persistedAction instanceof BiologicalControlAction)) continue;
            BiologicalControlAction biologicalControlAction = (BiologicalControlAction)persistedAction;
            this.compareBiologicalControlActions((BiologicalControlAction)actions.get(2), biologicalControlAction);
            ++nbActionChecked;
        }
        return nbActionChecked;
    }

    private PracticedInterventionDto createIntervention(String interventionName, List<AbstractAction> actions, List<AbstractInput> inputs, String domainCode, int rank) {
        PracticedInterventionDto interventionDto = new PracticedInterventionDto();
        SpeciesStadeDto speciesStadesDto = new SpeciesStadeDto();
        speciesStadesDto.setSpeciesCode(this.croppingPlanEntries.get(0).getCode());
        List refStadeEDIs = this.refStadeEDITopiaDao.forActiveEquals(true).findAll();
        speciesStadesDto.setStadeMin((RefStadeEdiDto)Itk.STADE_EDI_TO_DTO.apply(refStadeEDIs.get(0)));
        speciesStadesDto.setStadeMax((RefStadeEdiDto)Itk.STADE_EDI_TO_DTO.apply(refStadeEDIs.get(2)));
        PracticedInterventionImpl intervention = new PracticedInterventionImpl();
        intervention.setName(interventionName);
        intervention.setType(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX);
        intervention.setStartingPeriodDate("3/03");
        intervention.setEndingPeriodDate("4/03");
        intervention.setRank(rank);
        BinderFactory.newBinder(PracticedIntervention.class).copy((Object)intervention, (Object)interventionDto, new String[0]);
        interventionDto.setActions(actions);
        interventionDto.setInputs(inputs);
        ArrayList practicedSpeciesStades = Lists.newArrayList((Object[])new SpeciesStadeDto[]{speciesStadesDto});
        interventionDto.setSpeciesStadesDtos((List)practicedSpeciesStades);
        interventionDto.setDomainId(domainCode);
        return interventionDto;
    }

    @Test
    public void testDuplicatePracticedSystem() {
        PracticedSystem psBaulon2013 = this.testDatas.createTestPraticedSystems();
        List<CroppingPlanEntry> croppingPlanEntries = this.testDatas.findCroppingPlanEntries(psBaulon2013.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId());
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(croppingPlanEntries, psBaulon2013);
        PracticedSystemFilter filter = new PracticedSystemFilter();
        List elements = this.practicedSystemService.getFilteredPracticedSystems(filter).getElements();
        int count = 0;
        for (PracticedSystem practicedSystem : elements) {
            this.practicedSystemService.duplicatePracticedSystem(practicedSystem.getTopiaId(), practicedSystem.getGrowingSystem().getTopiaId());
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Ignore
    public void testUniqueConstraint() {
        this.testDatas.createTestPraticedSystems();
        List practicedSystems = this.practicedSystemTopiaDao.findAll();
        PracticedSystem practicedSystem = (PracticedSystem)practicedSystems.get(0);
        this.practicedPlotDao.create("name", (Object)"t0", new Object[]{"waterFlowDistance", WaterFlowDistance.FIVE_TO_TEN, "bufferStrip", BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW, "maxSlope", MaxSlope.ZERO, "practicedSystem", practicedSystem});
        this.practicedPlotDao.create("name", (Object)"t1", new Object[]{"waterFlowDistance", WaterFlowDistance.FIVE_TO_TEN, "bufferStrip", BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW, "maxSlope", MaxSlope.ZERO, "practicedSystem", practicedSystem});
    }
}

