/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.plots;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.SolHorizon;
import fr.inra.agrosyst.api.entities.SolHorizonImpl;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.performance.PerformanceState;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class PlotServiceTest
extends AbstractAgrosystTest {
    protected DomainService domainService;
    protected ReferentialService referentialService;
    protected PlotService plotService;
    protected TestDatas testDatas;
    protected PerformanceTopiaDao performanceTopiaDao;
    protected ZoneTopiaDao zoneTopiaDao;
    protected PlotTopiaDao plotTopiaDao;
    protected AgrosystUserTopiaDao userTopiaDao;

    @Before
    public void setupServices() throws TopiaException {
        this.loginAsAdmin();
        this.performanceTopiaDao = this.getPersistenceContext().getPerformanceDao();
        this.zoneTopiaDao = this.getPersistenceContext().getZoneDao();
        this.plotTopiaDao = this.getPersistenceContext().getPlotDao();
        this.userTopiaDao = this.getPersistenceContext().getAgrosystUserDao();
        this.domainService = (DomainService)this.serviceFactory.newService(DomainService.class);
        this.plotService = (PlotService)this.serviceFactory.newService(PlotService.class);
        this.referentialService = (ReferentialService)this.serviceFactory.newService(ReferentialService.class);
        this.plotService = (PlotService)this.serviceFactory.newService(PlotService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.testDatas.createTestPlots();
    }

    @Test
    public void testPlotSolHorizonExtends() throws DomainExtendException {
        this.testDatas.importSolArvalis();
        List solArvalis = this.referentialService.getSolArvalis(Integer.valueOf(72));
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        Domain domainBaulon = (Domain)this.domainService.getFilteredDomains(domainFilter).getElements().get(0);
        Ground sol = this.domainService.newSol();
        sol.setName("Test sol baulon");
        sol.setRefSolArvalis((RefSolArvalis)solArvalis.get(0));
        ArrayList sols = Lists.newArrayList((Object[])new Ground[]{sol});
        this.domainService.createOrUpdateDomain(domainBaulon, domainBaulon.getLocation().getTopiaId(), null, null, null, null, null, (List)sols, null, null, null);
        List grounds = this.domainService.getGrounds(domainBaulon.getTopiaId());
        Assert.assertEquals((long)1L, (long)grounds.size());
        Assert.assertEquals((Object)sol.getRefSolArvalis(), (Object)((Ground)grounds.get(0)).getRefSolArvalis());
        Assert.assertEquals((Object)sol.getName(), (Object)((Ground)grounds.get(0)).getName());
        List plots = this.getPersistenceContext().getPlotDao().findAllByDomainOrderByName(domainBaulon);
        Assert.assertEquals((long)4L, (long)plots.size());
        Plot plot = (Plot)plots.get(0);
        List plotZones = this.zoneTopiaDao.forPlotEquals(plot).findAll();
        Assert.assertEquals((Object)"Plot Baulon 1", (Object)plot.getName());
        plot.setGround((Ground)grounds.get(0));
        SolHorizonImpl solHorizon = new SolHorizonImpl();
        solHorizon.setLowRating(Double.valueOf(42.0));
        plot.addSolHorizon((SolHorizon)solHorizon);
        this.plotService.createOrUpdatePlot(plot, plot.getDomain().getTopiaId(), plot.getDomain().getLocation().getTopiaId(), plot.getGrowingSystem().getTopiaId(), null, null, null, null, null, null, (Collection)plotZones, null);
        Domain baulon2018 = this.domainService.extendDomain(domainBaulon.getTopiaId(), 2018);
        plots = this.plotService.findAllByDomain(baulon2018);
        Plot plot2018 = (Plot)plots.get(0);
        Assert.assertEquals((Object)"Plot Baulon 1", (Object)plot2018.getName());
        Assert.assertNotEquals((Object)plot, (Object)plot2018);
        Assert.assertEquals((long)1L, (long)plot2018.getSolHorizon().size());
    }

    @Test
    public void testPlotDuplicate() {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        Domain domainBaulon = (Domain)this.domainService.getFilteredDomains(domainFilter).getElements().get(0);
        List plots = this.plotService.findAllByDomain(domainBaulon);
        Assert.assertEquals((long)4L, (long)plots.size());
        Plot plot = (Plot)plots.get(0);
        Plot plot2 = this.plotService.duplicatePlot(plot.getTopiaId());
        Assert.assertNotNull((Object)plot2);
        plots = this.plotService.findAllByDomain(domainBaulon);
        Assert.assertEquals((long)5L, (long)plots.size());
        Assert.assertNotEquals((Object)plot.getCode(), (Object)plot2.getCode());
    }

    @Test
    public void testPlotMerge() {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        Domain domainBaulon = (Domain)this.domainService.getFilteredDomains(domainFilter).getElements().get(0);
        List plots = this.plotService.findAllByDomain(domainBaulon);
        Plot plot1 = (Plot)plots.get(0);
        plot1.setArea(11.0);
        Plot plot2 = this.plotService.duplicatePlot(plot1.getTopiaId());
        plot2.setArea(31.0);
        Plot plot = this.plotService.mergePlots(Arrays.asList(plot1.getTopiaId(), plot2.getTopiaId()));
        Assert.assertEquals((Object)plot2, (Object)plot);
        Assert.assertEquals((double)42.0, (double)plot.getArea(), (double)0.0);
    }

    @Test
    public void testGetDomainTotalArea() {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        Domain domainBaulon = (Domain)this.domainService.getFilteredDomains(domainFilter).getElements().get(0);
        String domainBaulonTopiaId = domainBaulon.getTopiaId();
        double totalArea = this.domainService.getDomainSAUArea(domainBaulonTopiaId);
        Assert.assertEquals((double)100.0, (double)totalArea, (double)0.001);
        double plotTotalArea = this.plotTopiaDao.getDomainPlotTotalArea(domainBaulonTopiaId);
        Assert.assertEquals((double)149.0, (double)plotTotalArea, (double)0.001);
    }

    @Test
    public void testPlotAffected() {
        AgrosystUser user;
        this.testDatas.createTestPlots();
        if (this.userTopiaDao.count() == 0L) {
            this.testDatas.createTestUsers();
            user = (AgrosystUser)this.userTopiaDao.forEmailEquals("jenvoie@atoit.fr").findAny();
        } else {
            user = (AgrosystUser)this.userTopiaDao.findAll().get(0);
        }
        Plot plot = (Plot)this.plotTopiaDao.findAll().get(0);
        List zones = this.zoneTopiaDao.forPlotEquals(plot).findAll();
        Zone zone = (long)zones.size() == 0L ? (Zone)this.zoneTopiaDao.create("plot", (Object)plot, new Object[]{"code", UUID.randomUUID().toString()}) : (Zone)zones.get(0);
        zones = this.zoneTopiaDao.forPlotEquals(plot).findAll();
        this.performanceTopiaDao.create("name", (Object)"perforamnce_test", new Object[]{"updateDate", new Date(), "author", user, "computeStatus", PerformanceState.SUCCESS, "zones", Collections.singleton(zone)});
        this.getCurrentTransaction().commit();
        UsageList usages = this.plotService.getZonesAndUsages(plot.getTopiaId());
        Assert.assertEquals((long)zones.size(), (long)usages.getElements().size());
        Assert.assertEquals((Object)true, usages.getUsageMap().get(zone.getTopiaId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXls() throws IOException {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        Domain domainBaulon = (Domain)this.domainService.getFilteredDomains(domainFilter).getElements().get(0);
        List plots = this.plotService.findAllByDomain(domainBaulon);
        List plotIds = Lists.transform((List)plots, (Function)Entities.GET_TOPIA_ID);
        InputStream is = null;
        try {
            is = this.plotService.exportPlotsAsXlsStream(plotIds);
            Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXlsEmpty() throws IOException {
        InputStream is = null;
        try {
            is = this.plotService.exportPlotsAsXlsStream(null);
            Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportXls() throws IOException {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        Domain domainBaulon = (Domain)this.domainService.getFilteredDomains(domainFilter).getElements().get(0);
        List plots = this.plotService.findAllByDomain(domainBaulon);
        Assert.assertEquals((long)4L, (long)plots.size());
        List plotIds = Lists.transform((List)plots, (Function)Entities.GET_TOPIA_ID);
        InputStream is = null;
        try {
            is = this.plotService.exportPlotsAsXlsStream(plotIds);
            this.plotService.importPlotsForXlsStream(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        plots = this.plotService.findAllByDomain(domainBaulon);
        Assert.assertEquals((long)8L, (long)plots.size());
    }
}

