/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionImpl;
import fr.inra.agrosyst.services.performance.indicators.IndicatorWorkTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class IndicatorWorkTimeTest {
    protected static final SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yyyy");

    @Test
    public void testPracticedMonth1() {
        IndicatorWorkTime indicatorWorkTime = new IndicatorWorkTime();
        PracticedInterventionImpl intervention = new PracticedInterventionImpl();
        intervention.setStartingPeriodDate("1/3");
        intervention.setEndingPeriodDate("31/7");
        Assert.assertEquals((long)2L, (long)indicatorWorkTime.getStartMonth((PracticedIntervention)intervention));
    }

    @Test
    public void testPracticedMonth2() {
        IndicatorWorkTime indicatorWorkTime = new IndicatorWorkTime();
        PracticedInterventionImpl intervention = new PracticedInterventionImpl();
        intervention.setStartingPeriodDate("1/7");
        intervention.setEndingPeriodDate("31/3");
        Assert.assertEquals((long)6L, (long)indicatorWorkTime.getStartMonth((PracticedIntervention)intervention));
    }

    @Test
    public void testPracticedMonthEmpty() {
        IndicatorWorkTime indicatorWorkTime = new IndicatorWorkTime();
        PracticedInterventionImpl intervention = new PracticedInterventionImpl();
        Assert.assertEquals((long)-1L, (long)indicatorWorkTime.getStartMonth((PracticedIntervention)intervention));
    }

    @Test
    public void testEffectiveMonth1() throws ParseException {
        IndicatorWorkTime indicatorWorkTime = new IndicatorWorkTime();
        EffectiveInterventionImpl intervention = new EffectiveInterventionImpl();
        intervention.setStartInterventionDate(SDF.parse("1/03/2013"));
        intervention.setEndInterventionDate(SDF.parse("31/07/2013"));
        Assert.assertEquals((long)2L, (long)indicatorWorkTime.getStartMonth((EffectiveIntervention)intervention));
    }

    @Test
    public void testEffectiveMonth2() throws ParseException {
        IndicatorWorkTime indicatorWorkTime = new IndicatorWorkTime();
        EffectiveInterventionImpl intervention = new EffectiveInterventionImpl();
        intervention.setStartInterventionDate(SDF.parse("1/07/2013"));
        intervention.setEndInterventionDate(SDF.parse("31/03/2014"));
        Assert.assertEquals((long)6L, (long)indicatorWorkTime.getStartMonth((EffectiveIntervention)intervention));
    }

    @Test
    public void testEffectiveMonthEmpty() {
        IndicatorWorkTime indicatorWorkTime = new IndicatorWorkTime();
        EffectiveInterventionImpl intervention = new EffectiveInterventionImpl();
        Assert.assertEquals((long)-1L, (long)indicatorWorkTime.getStartMonth((EffectiveIntervention)intervention));
    }
}

