/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.action.PesticideProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingAction;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingActionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceImpl;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.performance.IndicatorMockWriter;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import fr.inra.agrosyst.services.performance.PerformanceServiceImpl;
import fr.inra.agrosyst.services.performance.indicators.Indicator;
import fr.inra.agrosyst.services.performance.indicators.IndicatorIFT;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class IndicatorIFTTest
extends AbstractAgrosystTest {
    protected PerformanceServiceImpl performanceService;
    protected GrowingSystemService growingSystemService;
    protected EffectiveCropCycleService effectiveCropCycleService;
    protected TestDatas testDatas;
    protected ZoneTopiaDao zoneTopiaDao;
    protected EffectiveCropCyclePhaseTopiaDao cropCyclePhaseDAO;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao;
    protected EffectiveInterventionTopiaDao effectiveInterventionDAO;
    protected EffectiveSpeciesStadeTopiaDao effectiveSpeciesStadeTopiaDao;
    protected PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionTopiaDao;
    protected RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDIDAO;
    protected PesticideProductInputTopiaDao pesticideProductInputTopiaDao;
    protected RefActaTraitementsProduitTopiaDao refActaTraitementsProduitsTopiaDao;
    protected SeedingActionTopiaDao seedingActionTopiaDao;
    protected SeedingActionSpeciesTopiaDao seedingActionSpeciesTopiaDao;
    protected EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao;
    protected EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao;
    protected static final Function<CroppingPlanEntry, String> GET_CPE_NAME = new Function<CroppingPlanEntry, String>(){

        public String apply(CroppingPlanEntry input) {
            return input == null ? null : input.getName();
        }
    };
    protected static final Function<CroppingPlanSpecies, String> GET_CPS_VARIETY_DENOMINATION = new Function<CroppingPlanSpecies, String>(){

        public String apply(CroppingPlanSpecies input) {
            RefVarieteGeves variety = input == null ? null : (RefVarieteGeves)input.getVariety();
            String result = variety == null ? null : variety.getDenomination();
            return result;
        }
    };

    @Before
    public void setupServices() throws TopiaException {
        this.performanceService = (PerformanceServiceImpl)this.serviceFactory.newService(PerformanceService.class);
        this.growingSystemService = (GrowingSystemService)this.serviceFactory.newService(GrowingSystemService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.effectiveCropCycleService = (EffectiveCropCycleService)this.serviceFactory.newService(EffectiveCropCycleService.class);
        this.zoneTopiaDao = this.serviceContext.getPersistenceContext().getZoneDao();
        this.cropCyclePhaseDAO = this.serviceContext.getPersistenceContext().getEffectiveCropCyclePhaseDao();
        this.effectivePerennialCropCycleTopiaDao = this.serviceContext.getPersistenceContext().getEffectivePerennialCropCycleDao();
        this.effectiveInterventionDAO = this.serviceContext.getPersistenceContext().getEffectiveInterventionDao();
        this.effectiveSpeciesStadeTopiaDao = this.serviceContext.getPersistenceContext().getEffectiveSpeciesStadeDao();
        this.pesticidesSpreadingActionTopiaDao = this.serviceContext.getPersistenceContext().getPesticidesSpreadingActionDao();
        this.refActionAgrosystTravailEDIDAO = this.serviceContext.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        this.pesticideProductInputTopiaDao = this.serviceContext.getPersistenceContext().getPesticideProductInputDao();
        this.refActaTraitementsProduitsTopiaDao = this.serviceContext.getPersistenceContext().getRefActaTraitementsProduitDao();
        this.seedingActionTopiaDao = this.serviceContext.getPersistenceContext().getSeedingActionDao();
        this.seedingActionSpeciesTopiaDao = this.serviceContext.getPersistenceContext().getSeedingActionSpeciesDao();
        this.effectiveSeasonalCropCycleTopiaDao = this.serviceContext.getPersistenceContext().getEffectiveSeasonalCropCycleDao();
        this.effectiveCropCycleNodeTopiaDao = this.serviceContext.getPersistenceContext().getEffectiveCropCycleNodeDao();
        this.effectiveCropCycleConnectionTopiaDao = this.serviceContext.getPersistenceContext().getEffectiveCropCycleConnectionDao();
        this.loginAsAdmin();
    }

    @Test
    public void testInraDataIFT() {
        this.testDatas.createTestPlots();
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importActaTraitementsProduits();
        this.testDatas.importActaTraitementsProduitsCateg();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importLienCulturesEdiActa();
        this.testDatas.importActaGroupeCultures();
        List zones = this.zoneTopiaDao.newQueryBuilder().setOrderByArguments(new String[]{"plot.name"}).findAll();
        Zone zpPlotBaulon1 = (Zone)zones.get(0);
        EffectiveCropCyclePhase cropCyclePhase = (EffectiveCropCyclePhase)this.cropCyclePhaseDAO.create("duration", (Object)15, new Object[]{"type", CropCyclePhaseType.PLEINE_PRODUCTION});
        List crops = this.effectiveCropCycleService.getZoneCroppingPlanEntries(zpPlotBaulon1);
        ImmutableMap indexedCrops = Maps.uniqueIndex((Iterable)crops, GET_CPE_NAME);
        CroppingPlanEntry cultureBle = (CroppingPlanEntry)indexedCrops.get("Bl\u00e9");
        CroppingPlanSpecies bleTendreHiver = (CroppingPlanSpecies)cultureBle.getCroppingPlanSpecies().get(0);
        Assert.assertEquals((Object)"ZAR", (Object)bleTendreHiver.getSpecies().getCode_espece_botanique());
        this.effectivePerennialCropCycleTopiaDao.create("zone", (Object)zpPlotBaulon1, new Object[]{"croppingPlanEntry", cultureBle, "phase", cropCyclePhase, "weedType", WeedType.PAS_ENHERBEMENT});
        EffectiveIntervention intervention1 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "Intervention 1", "type", AgrosystInterventionType.LUTTE_BIOLOGIQUE, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention1Stades = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiver, new Object[0]);
        intervention1.addSpeciesStades(intervention1Stades);
        RefInterventionAgrosystTravailEDI actionSEX = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SEX").findAny();
        PesticidesSpreadingAction pestAction1 = (PesticidesSpreadingAction)this.pesticidesSpreadingActionTopiaDao.create("effectiveIntervention", (Object)intervention1, new Object[]{"mainAction", actionSEX, "proportionOfTreatedSurface", 100.0});
        RefActaTraitementsProduit produitArchipel = (RefActaTraitementsProduit)this.refActaTraitementsProduitsTopiaDao.forNaturalId("5166", 147).findUnique();
        this.pesticideProductInputTopiaDao.create("inputType", (Object)AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, new Object[]{"pesticidesSpreadingAction", pestAction1, "qtAvg", 150.0, "phytoProduct", produitArchipel});
        RefActaTraitementsProduit produitActirobB = (RefActaTraitementsProduit)this.refActaTraitementsProduitsTopiaDao.forNaturalId("2838", 124).findUnique();
        this.pesticideProductInputTopiaDao.create("inputType", (Object)AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, new Object[]{"pesticidesSpreadingAction", pestAction1, "qtAvg", 1.0, "phytoProduct", produitActirobB});
        EffectiveIntervention intervention2 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "Intervention 2", "type", AgrosystInterventionType.LUTTE_BIOLOGIQUE, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention2Stades = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiver, new Object[0]);
        intervention2.addSpeciesStades(intervention2Stades);
        PesticidesSpreadingAction pestAction2 = (PesticidesSpreadingAction)this.pesticidesSpreadingActionTopiaDao.create("effectiveIntervention", (Object)intervention2, new Object[]{"mainAction", actionSEX, "proportionOfTreatedSurface", 100.0});
        RefActaTraitementsProduit produitCyclocelCL = (RefActaTraitementsProduit)this.refActaTraitementsProduitsTopiaDao.forNaturalId("4569", 123).findUnique();
        this.pesticideProductInputTopiaDao.create("inputType", (Object)AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, new Object[]{"pesticidesSpreadingAction", pestAction2, "qtAvg", 2.0, "phytoProduct", produitCyclocelCL});
        EffectiveIntervention intervention3 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "Intervention 3", "type", AgrosystInterventionType.LUTTE_BIOLOGIQUE, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 0.75});
        EffectiveSpeciesStade intervention3Stades = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiver, new Object[0]);
        intervention3.addSpeciesStades(intervention3Stades);
        PesticidesSpreadingAction pestAction3 = (PesticidesSpreadingAction)this.pesticidesSpreadingActionTopiaDao.create("effectiveIntervention", (Object)intervention3, new Object[]{"mainAction", actionSEX, "proportionOfTreatedSurface", 100.0});
        RefActaTraitementsProduit produitAllie = (RefActaTraitementsProduit)this.refActaTraitementsProduitsTopiaDao.forNaturalId("5190", 147).findUnique();
        this.pesticideProductInputTopiaDao.create("inputType", (Object)AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, new Object[]{"pesticidesSpreadingAction", pestAction3, "qtAvg", 20.0, "phytoProduct", produitAllie});
        EffectiveIntervention intervention4 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "Intervention 4", "type", AgrosystInterventionType.LUTTE_BIOLOGIQUE, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention4Stades = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiver, new Object[0]);
        intervention4.addSpeciesStades(intervention4Stades);
        PesticidesSpreadingAction pestAction4 = (PesticidesSpreadingAction)this.pesticidesSpreadingActionTopiaDao.create("effectiveIntervention", (Object)intervention4, new Object[]{"mainAction", actionSEX, "proportionOfTreatedSurface", 100.0});
        RefActaTraitementsProduit produitPyrosEW = (RefActaTraitementsProduit)this.refActaTraitementsProduitsTopiaDao.forNaturalId("3154", 140).findUnique();
        this.pesticideProductInputTopiaDao.create("inputType", (Object)AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, new Object[]{"pesticidesSpreadingAction", pestAction4, "qtAvg", 0.7, "phytoProduct", produitPyrosEW});
        EffectiveIntervention intervention5 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "Intervention 5", "type", AgrosystInterventionType.LUTTE_BIOLOGIQUE, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention5Stades = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiver, new Object[0]);
        intervention5.addSpeciesStades(intervention5Stades);
        PesticidesSpreadingAction pestAction5 = (PesticidesSpreadingAction)this.pesticidesSpreadingActionTopiaDao.create("effectiveIntervention", (Object)intervention5, new Object[]{"mainAction", actionSEX, "proportionOfTreatedSurface", 100.0});
        RefActaTraitementsProduit produitOpus = (RefActaTraitementsProduit)this.refActaTraitementsProduitsTopiaDao.forNaturalId("3027", 140).findUnique();
        this.pesticideProductInputTopiaDao.create("inputType", (Object)AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, new Object[]{"pesticidesSpreadingAction", pestAction5, "qtAvg", 0.6, "phytoProduct", produitOpus});
        EffectiveIntervention intervention6 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "Intervention 6", "type", AgrosystInterventionType.LUTTE_BIOLOGIQUE, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention6Stades = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiver, new Object[0]);
        intervention6.addSpeciesStades(intervention6Stades);
        PesticidesSpreadingAction pestAction6 = (PesticidesSpreadingAction)this.pesticidesSpreadingActionTopiaDao.create("effectiveIntervention", (Object)intervention6, new Object[]{"mainAction", actionSEX, "proportionOfTreatedSurface", 100.0});
        RefActaTraitementsProduit produitFandango = (RefActaTraitementsProduit)this.refActaTraitementsProduitsTopiaDao.forNaturalId("4840", 140).findUnique();
        this.pesticideProductInputTopiaDao.create("inputType", (Object)AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, new Object[]{"pesticidesSpreadingAction", pestAction6, "qtAvg", 1.2, "phytoProduct", produitFandango});
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(zpPlotBaulon1.getPlot().getDomain().getTopiaId()), null, null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIFT.class)});
        String content = out.toString();
        Assert.assertTrue((boolean)content.contains("IFT total;2013;Baulon;3.75"));
        Assert.assertTrue((boolean)content.contains("IFT tot hts;2013;Baulon;3.75"));
        Assert.assertTrue((boolean)content.contains("IFT h;2013;Baulon;1.05"));
        Assert.assertTrue((boolean)content.contains("IFT f;2013;Baulon;1.9;"));
        Assert.assertTrue((boolean)content.contains("IFT i;2013;Baulon;0.0;"));
        Assert.assertTrue((boolean)content.contains("IFT a;2013;Baulon;0.8;"));
        Assert.assertTrue((boolean)content.contains("IFT hh;2013;Baulon;2.7;"));
        Assert.assertTrue((boolean)content.contains("IFT biocontrole;2013;Baulon;0.0;"));
        Assert.assertTrue((boolean)content.contains("IFT moyens biologiques;2013;Baulon;0.0;"));
    }

    @Test
    public void testPerennialInraDataIFT2() {
        this.testDatas.createTestPlots();
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importActaTraitementsProduits();
        this.testDatas.importActaTraitementsProduitsCateg();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importLienCulturesEdiActa();
        this.testDatas.importActaGroupeCultures();
        List zones = this.zoneTopiaDao.newQueryBuilder().setOrderByArguments(new String[]{"plot.name"}).findAll();
        Zone zpPlotBaulon1 = (Zone)zones.get(0);
        EffectiveCropCyclePhase cropCyclePhase = (EffectiveCropCyclePhase)this.cropCyclePhaseDAO.create("duration", (Object)15, new Object[]{"type", CropCyclePhaseType.PLEINE_PRODUCTION});
        List crops = this.effectiveCropCycleService.getZoneCroppingPlanEntries(zpPlotBaulon1);
        ImmutableMap indexedCrops = Maps.uniqueIndex((Iterable)crops, GET_CPE_NAME);
        CroppingPlanEntry cultureBle = (CroppingPlanEntry)indexedCrops.get("M\u00e9lange vari\u00e9t\u00e9s bl\u00e9");
        List species = cultureBle.getCroppingPlanSpecies();
        ImmutableMap indexedSpecies = Maps.uniqueIndex((Iterable)species, GET_CPS_VARIETY_DENOMINATION);
        CroppingPlanSpecies bleTendreHiverJosselin = (CroppingPlanSpecies)indexedSpecies.get("Josselin");
        CroppingPlanSpecies bleTendreHiverBarok = (CroppingPlanSpecies)indexedSpecies.get("Barok");
        Assert.assertEquals((Object)"ZAR", (Object)bleTendreHiverJosselin.getSpecies().getCode_espece_botanique());
        this.effectivePerennialCropCycleTopiaDao.create("zone", (Object)zpPlotBaulon1, new Object[]{"croppingPlanEntry", cultureBle, "phase", cropCyclePhase, "weedType", WeedType.PAS_ENHERBEMENT});
        EffectiveIntervention intervention1 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "1", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention1StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention1StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention1.addSpeciesStades(intervention1StadesJosselin);
        intervention1.addSpeciesStades(intervention1StadesBarok);
        RefInterventionAgrosystTravailEDI actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        ArrayList seedingActionSpecieses = Lists.newArrayList();
        SeedingActionSpecies josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        SeedingActionSpecies barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention1, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention2 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "2", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 0.5});
        EffectiveSpeciesStade intervention2StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention2StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention2.addSpeciesStades(intervention2StadesJosselin);
        intervention2.addSpeciesStades(intervention2StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention2, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention3 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "3", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention3StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention3StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention3.addSpeciesStades(intervention3StadesJosselin);
        intervention3.addSpeciesStades(intervention3StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention3, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention4 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "4", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention4StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention4StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention4.addSpeciesStades(intervention4StadesJosselin);
        intervention4.addSpeciesStades(intervention4StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention4, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention5 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCyclePhase", (Object)cropCyclePhase, new Object[]{"name", "5", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention5StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention5StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention5.addSpeciesStades(intervention5StadesJosselin);
        intervention5.addSpeciesStades(intervention5StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", false, "biologicalSeedInoculation", true});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention5, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(zpPlotBaulon1.getPlot().getDomain().getTopiaId()), null, null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIFT.class)});
        String content = out.toString();
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;1.0"));
    }

    @Test
    public void testSeasonalInraDataIFT2() {
        this.testDatas.createTestPlots();
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importActaTraitementsProduits();
        this.testDatas.importActaTraitementsProduitsCateg();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importLienCulturesEdiActa();
        this.testDatas.importActaGroupeCultures();
        List zones = this.zoneTopiaDao.newQueryBuilder().setOrderByArguments(new String[]{"plot.name"}).findAll();
        Zone zpPlotBaulon1 = (Zone)zones.get(0);
        List crops = this.effectiveCropCycleService.getZoneCroppingPlanEntries(zpPlotBaulon1);
        ImmutableMap indexedCrops = Maps.uniqueIndex((Iterable)crops, GET_CPE_NAME);
        CroppingPlanEntry cultureMixBle = (CroppingPlanEntry)indexedCrops.get("M\u00e9lange vari\u00e9t\u00e9s bl\u00e9");
        List species = cultureMixBle.getCroppingPlanSpecies();
        ImmutableMap indexedSpecies = Maps.uniqueIndex((Iterable)species, GET_CPS_VARIETY_DENOMINATION);
        CroppingPlanSpecies bleTendreHiverJosselin = (CroppingPlanSpecies)indexedSpecies.get("Josselin");
        CroppingPlanSpecies bleTendreHiverBarok = (CroppingPlanSpecies)indexedSpecies.get("Barok");
        Assert.assertEquals((Object)"ZAR", (Object)bleTendreHiverJosselin.getSpecies().getCode_espece_botanique());
        EffectiveCropCycleNode cropCycleNode0 = (EffectiveCropCycleNode)this.effectiveCropCycleNodeTopiaDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cultureMixBle});
        EffectiveCropCycleConnection cropCycleConnection = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionTopiaDao.create("target", (Object)cropCycleNode0, new Object[0]);
        ArrayList nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{cropCycleNode0});
        this.effectiveSeasonalCropCycleTopiaDao.create("zone", (Object)zpPlotBaulon1, new Object[]{"nodes", nodes});
        EffectiveIntervention intervention1 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCycleNode", (Object)cropCycleNode0, new Object[]{"name", "1", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention1StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention1StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention1.addSpeciesStades(intervention1StadesJosselin);
        intervention1.addSpeciesStades(intervention1StadesBarok);
        RefInterventionAgrosystTravailEDI actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        ArrayList seedingActionSpecieses = Lists.newArrayList();
        SeedingActionSpecies josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        SeedingActionSpecies barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention1, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention2 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCycleNode", (Object)cropCycleNode0, new Object[]{"name", "2", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 0.5});
        EffectiveSpeciesStade intervention2StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention2StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention2.addSpeciesStades(intervention2StadesJosselin);
        intervention2.addSpeciesStades(intervention2StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention2, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention3 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCycleNode", (Object)cropCycleNode0, new Object[]{"name", "3", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention3StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention3StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention3.addSpeciesStades(intervention3StadesJosselin);
        intervention3.addSpeciesStades(intervention3StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention3, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention4 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCycleNode", (Object)cropCycleNode0, new Object[]{"name", "4", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention4StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention4StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention4.addSpeciesStades(intervention4StadesJosselin);
        intervention4.addSpeciesStades(intervention4StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", true, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention4, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        EffectiveIntervention intervention5 = (EffectiveIntervention)this.effectiveInterventionDAO.create("effectiveCropCycleNode", (Object)cropCycleNode0, new Object[]{"name", "5", "type", AgrosystInterventionType.SEMIS, "workRate", 1.0, "startInterventionDate", new Date(), "endInterventionDate", new Date(), "transitCount", 1, "spatialFrequency", 1});
        EffectiveSpeciesStade intervention5StadesJosselin = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverJosselin, new Object[0]);
        EffectiveSpeciesStade intervention5StadesBarok = (EffectiveSpeciesStade)this.effectiveSpeciesStadeTopiaDao.create("croppingPlanSpecies", (Object)bleTendreHiverBarok, new Object[0]);
        intervention5.addSpeciesStades(intervention5StadesJosselin);
        intervention5.addSpeciesStades(intervention5StadesBarok);
        actionSET = (RefInterventionAgrosystTravailEDI)this.refActionAgrosystTravailEDIDAO.forReference_codeEquals("SET").findAny();
        seedingActionSpecieses = Lists.newArrayList();
        josselinSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverJosselin.getCode(), "treatment", false, "biologicalSeedInoculation", true});
        seedingActionSpecieses.add(josselinSeedingActionSpecies);
        barokSeedingActionSpecies = (SeedingActionSpecies)this.seedingActionSpeciesTopiaDao.create("quantity", (Object)10, new Object[]{"speciesCode", bleTendreHiverBarok.getCode(), "treatment", false, "biologicalSeedInoculation", false});
        seedingActionSpecieses.add(barokSeedingActionSpecies);
        this.seedingActionTopiaDao.create("effectiveIntervention", (Object)intervention5, new Object[]{"mainAction", actionSET, "yealdTarget", 100.0, "seedingSpecies", seedingActionSpecieses});
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(zpPlotBaulon1.getPlot().getDomain().getTopiaId()), null, null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIFT.class)});
        String content = out.toString();
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("1;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("2;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("3;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;1.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("4;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("5;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2013;Baulon;1.0"));
    }
}

