/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.performance.indicators.IndicatorIFT;
import fr.inra.agrosyst.services.performance.indicators.IndicatorSurfaceUTH;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class AbstractIndicatorTest
extends AbstractAgrosystTest {
    protected TestDatas testDatas;
    protected PracticedSystem psBaulon2013;
    protected List<CroppingPlanEntry> croppingPlanEntries;

    @Before
    public void setupServices() throws TopiaException {
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importFertiMinUnifa();
        this.testDatas.importActaSubstanceActive();
        this.testDatas.importIphyReferentials();
        this.psBaulon2013 = this.testDatas.createTestPraticedSystems();
        this.croppingPlanEntries = this.testDatas.findCroppingPlanEntries(this.psBaulon2013.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId());
    }

    @Test
    public void testNodePercentageComputation() {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.loginAsAdmin();
        List connections = this.serviceContext.getPersistenceContext().getPracticedCropCycleConnectionDao().findAll();
        Assert.assertEquals((long)9L, (long)connections.size());
        IndicatorSurfaceUTH indicator = new IndicatorSurfaceUTH();
        Map cumulativeFrequencies = indicator.computeCumulativeFrequencies(connections);
        boolean found35p = false;
        boolean found65p = false;
        for (Double value : cumulativeFrequencies.values()) {
            if (value == 0.35) {
                found35p = true;
            }
            if (value != 0.65) continue;
            found65p = true;
        }
        Assert.assertTrue((boolean)found35p);
        Assert.assertTrue((boolean)found65p);
    }

    @Test
    public void testCycleCampaignsRankCount() {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.loginAsAdmin();
        List connections = this.serviceContext.getPersistenceContext().getPracticedCropCycleConnectionDao().findAll();
        Assert.assertEquals((long)9L, (long)connections.size());
        IndicatorSurfaceUTH indicator = new IndicatorSurfaceUTH();
        Assert.assertEquals((long)4L, (long)indicator.getCampaignsCount(connections));
    }

    @Test
    public void testNodePercentageComputationINRA() {
        PracticedSystem ps = this.testDatas.createINRATestPraticedSystems("Systeme de culture Baulon 1");
        List<CroppingPlanEntry> croppingPlanEntries = this.testDatas.findCroppingPlanEntries(ps.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId());
        this.testDatas.createINRAdatasPracticedSystemTestData(croppingPlanEntries, ps);
        this.loginAsAdmin();
        List connections = this.serviceContext.getPersistenceContext().getPracticedCropCycleConnectionDao().findAll();
        Assert.assertEquals((long)4L, (long)connections.size());
        IndicatorIFT indicator = new IndicatorIFT();
        Map cumulativeFrequencies = indicator.computeCumulativeFrequencies(connections);
        Assert.assertEquals((long)4L, (long)cumulativeFrequencies.size());
        int nb10p = 0;
        int nb90p = 0;
        for (Double value : cumulativeFrequencies.values()) {
            if (value == 0.1) {
                ++nb10p;
            }
            if (value != 0.9) continue;
            ++nb90p;
        }
        Assert.assertEquals((long)2L, (long)nb10p);
        Assert.assertEquals((long)2L, (long)nb90p);
    }

    @Test
    public void testNodePercentageComputation2() {
        this.testDatas.createTestPraticedSystems2();
        this.loginAsAdmin();
        List connections = this.serviceContext.getPersistenceContext().getPracticedCropCycleConnectionDao().findAll();
        Assert.assertEquals((long)3L, (long)connections.size());
        IndicatorIFT indicator = new IndicatorIFT();
        Map cumulativeFrequencies = indicator.computeCumulativeFrequencies(connections);
        Assert.assertEquals((long)3L, (long)cumulativeFrequencies.size());
    }
}

