/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.performance.PerformanceFilter;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.performance.IndicatorMockWriter;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import fr.inra.agrosyst.services.performance.PerformanceServiceImpl;
import fr.inra.agrosyst.services.performance.indicators.Indicator;
import fr.inra.agrosyst.services.performance.indicators.IndicatorFuelConsumption;
import fr.inra.agrosyst.services.performance.indicators.IndicatorIFT;
import fr.inra.agrosyst.services.performance.indicators.IndicatorIPhy;
import fr.inra.agrosyst.services.performance.indicators.IndicatorSurfaceUTH;
import fr.inra.agrosyst.services.performance.indicators.IndicatorTransitCount;
import fr.inra.agrosyst.services.performance.indicators.IndicatorWorkTime;
import fr.inra.agrosyst.services.performance.indicators.IndicatorYield;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaException;

public class PerformanceServiceTest
extends AbstractAgrosystTest {
    protected PerformanceServiceImpl performanceService;
    protected GrowingSystemService growingSystemService;
    protected DomainService domainService;
    protected ImportService importService;
    protected TestDatas testDatas;
    protected PracticedSystem psBaulon2013;
    protected List<CroppingPlanEntry> croppingPlanEntries;

    @Before
    public void setupServices() throws TopiaException {
        this.performanceService = (PerformanceServiceImpl)this.serviceFactory.newService(PerformanceService.class);
        this.importService = (ImportService)this.serviceFactory.newService(ImportService.class);
        this.growingSystemService = (GrowingSystemService)this.serviceFactory.newService(GrowingSystemService.class);
        this.domainService = (DomainService)this.serviceFactory.newService(DomainService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importFertiMinUnifa();
        this.psBaulon2013 = this.testDatas.createTestPraticedSystems();
        this.croppingPlanEntries = this.testDatas.findCroppingPlanEntries(this.psBaulon2013.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId());
        this.loginAsAdmin();
    }

    @Test
    public void getFilteredPerformances() throws InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        ResultList result = this.domainService.getFilteredDomains(null);
        List domains = result.getElements();
        ArrayList domainIds = Lists.newArrayList((Iterable)Iterables.transform((Iterable)domains, (Function)TopiaEntities.getTopiaIdFunction()));
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, (List)domainIds, null, null, null, false);
        PerformanceFilter filter = new PerformanceFilter();
        filter.setPerformanceName("test");
        filter.setDomainName(((Domain)domains.get(0)).getName());
        filter.setGrowingSystemName("test");
        filter.setPlotName("test");
        filter.setZoneName("test");
        filter.setPracticed(true);
        ResultList resultPerfo = this.performanceService.getFilteredPerformances(filter);
        Assert.assertTrue((boolean)resultPerfo.getElements().isEmpty());
    }

    @Test
    public void computeAllOnDomainHssf() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        this.testDatas.importActaTraitementsProduitsCateg();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importLienCulturesEdiActa();
        this.testDatas.importActaSubstanceActive();
        this.testDatas.importIphyReferentials();
        this.testDatas.importSaActaIphy();
        this.testDatas.importZoneClimatiqueIphy();
        this.testDatas.importCultureEdiGroupeCouvSol();
        this.testDatas.importCouvSolAnnuelle();
        this.testDatas.importCouvSolPerenne();
        ResultList result = this.domainService.getFilteredDomains(null);
        List domains = result.getElements();
        ArrayList domainIds = Lists.newArrayList((Iterable)Iterables.transform((Iterable)domains, (Function)TopiaEntities.getTopiaIdFunction()));
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, (List)domainIds, null, null, null, false);
        this.performanceService.generatePerformanceFile(performance.getTopiaId());
        InputStream is = this.performanceService.downloadPerformances(performance.getTopiaId());
        Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        IOUtils.closeQuietly((InputStream)is);
        performance.setPracticed(true);
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, (List)domainIds, null, null, null, false);
        this.performanceService.generatePerformanceFile(performance.getTopiaId());
        is = this.performanceService.downloadPerformances(performance.getTopiaId());
        Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        IOUtils.closeQuietly((InputStream)is);
    }

    @Test
    public void computeIndicatorSurfaceUTH() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        ResultList result = this.domainService.getFilteredDomains(null);
        Domain domain = (Domain)result.getElements().get(0);
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(domain.getTopiaId()), null, null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorSurfaceUTH.class)});
        String content = out.toString();
        Assert.assertTrue((boolean)content.contains("Surface par UTH (ha);2013;Baulon;10.0"));
        performance.setPracticed(true);
        out = new StringWriter();
        writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorSurfaceUTH.class)});
        content = out.toString();
        Assert.assertTrue((boolean)content.contains("Surface par UTH (ha);2013;Baulon;10.0"));
    }

    @Test
    public void computeIndicatorWorkTime() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        GrowingSystem growingSystem = this.testDatas.getGrowingSystemForName("Systeme de culture Baulon 1");
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(growingSystem.getGrowingPlan().getDomain().getTopiaId()), null, null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorWorkTime.class)});
        String content = out.toString();
        performance.setPracticed(true);
        out = new StringWriter();
        writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorWorkTime.class)});
        content = out.toString();
        Assert.assertTrue((String)content, (boolean)content.contains("Temps de travail Mars (h/ha);2013, 2014, 2015;Baulon;1.875"));
        Assert.assertTrue((boolean)content.contains("Temps de travail (h/ha);2013, 2014, 2015;Baulon;1.875"));
    }

    @Test
    public void computeIndicatorFuelConsumption() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        ResultList result = this.growingSystemService.getFilteredGrowingSystems(null);
        GrowingSystem growingSystem = (GrowingSystem)result.getElements().get(0);
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(growingSystem.getGrowingPlan().getDomain().getTopiaId()), Collections.singletonList(growingSystem.getTopiaId()), null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorFuelConsumption.class)});
        String content = out.toString();
        performance.setPracticed(true);
        out = new StringWriter();
        writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorFuelConsumption.class)});
        content = out.toString();
    }

    @Test
    public void computeIndicatorYield() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        ResultList result = this.growingSystemService.getFilteredGrowingSystems(null);
        GrowingSystem growingSystem = (GrowingSystem)result.getElements().get(0);
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(growingSystem.getGrowingPlan().getDomain().getTopiaId()), Collections.singletonList(growingSystem.getTopiaId()), null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorYield.class)});
        String content = out.toString();
        Assert.assertFalse((boolean)content.contains("Baulon;Indicateurs de r\u00e9sultats agronomiques;Rendement"));
        performance.setPracticed(true);
        out = new StringWriter();
        writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorYield.class)});
        content = out.toString();
    }

    @Test
    public void computeIndicatorTransitCount() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        GrowingSystem growingSystem = this.psBaulon2013.getGrowingSystem();
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(growingSystem.getGrowingPlan().getDomain().getTopiaId()), Collections.singletonList(growingSystem.getTopiaId()), null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorTransitCount.class)});
        String content = out.toString();
        performance.setPracticed(true);
        out = new StringWriter();
        writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorTransitCount.class)});
        content = out.toString();
    }

    @Test
    public void computeIndicatorIPhy() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        this.testDatas.importActaSubstanceActive();
        this.testDatas.importIphyReferentials();
        this.testDatas.importSaActaIphy();
        this.testDatas.importZoneClimatiqueIphy();
        this.testDatas.importCultureEdiGroupeCouvSol();
        this.testDatas.importCouvSolAnnuelle();
        this.testDatas.importCouvSolPerenne();
        GrowingSystem growingSystem = this.psBaulon2013.getGrowingSystem();
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(growingSystem.getGrowingPlan().getDomain().getTopiaId()), null, null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIPhy.class)});
        String content = out.toString();
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;rceso;2013;Baulon;9.904"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;rcesu_rd;2013;Baulon;2.290"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;rcesu_de;2013;Baulon;10.0"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;rcair_vo;2013;Baulon;2.037"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;rcair_de;2013;Baulon;10.0"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;iphyeso;2013;Baulon;0.0"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;iphyesu;2013;Baulon;3.746"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;iphyair;2013;Baulon;9.123"));
        Assert.assertTrue((boolean)content.contains("Baulon;I-Phy;iphy;2013;Baulon;3.41"));
        performance.setPracticed(true);
        out = new StringWriter();
        writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIPhy.class)});
        content = out.toString();
    }

    @Test
    public void computeIndicatorIFT() throws IOException, InterruptedException {
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(this.croppingPlanEntries, this.psBaulon2013);
        this.testDatas.createTestEffectiveInterventions();
        this.testDatas.importActaTraitementsProduitsCateg();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importLienCulturesEdiActa();
        GrowingSystem growingSystem = this.psBaulon2013.getGrowingSystem();
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("Test");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(growingSystem.getGrowingPlan().getDomain().getTopiaId()), null, null, null, false);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIFT.class)});
        String content = out.toString();
        Assert.assertTrue((boolean)content.contains("IFT h;2013;Baulon;0.038"));
        performance.setPracticed(true);
        out = new StringWriter();
        writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIFT.class)});
        content = out.toString();
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("IFT tot hts;2013, 2014, 2015;Baulon;0.0"));
    }

    @Test
    public void computeSeasonalIndicatorIFT_fromINRA() throws IOException, InterruptedException {
        this.testDatas.importActaTraitementsProduitsCateg();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importLienCulturesEdiActa();
        PracticedSystem ps = this.testDatas.createINRATestPraticedSystems("Systeme de culture Baulon 1");
        this.croppingPlanEntries = this.testDatas.findCroppingPlanEntries(ps.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId());
        this.testDatas.createTestINRAPracticedSeasonalCropCycle(this.croppingPlanEntries, ps);
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("INRA_DONNEES_SYNTHETISEES");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(ps.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId()), null, null, null, false);
        performance.setPracticed(true);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIFT.class)});
        String content = out.toString();
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2014;Baulon;1.5"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2014;Baulon;1.5"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2014;Baulon;0.6"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2014;Baulon;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2014;Baulon;0.9"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2014;Baulon;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2014;Baulon;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2014;Baulon;0.9"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2014;Baulon;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("Baulon;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2014;Baulon;0.0"));
    }

    @Test
    public void computePerennialIndicatorIFT_fromINRA() throws IOException, InterruptedException {
        this.testDatas.importActaTraitementsProduitsCateg();
        this.testDatas.importActaDosageSpc();
        this.testDatas.importLienCulturesEdiActa();
        PracticedSystem ps = this.testDatas.createINRATestPraticedSystems("Efficience");
        this.croppingPlanEntries = this.testDatas.findCroppingPlanEntries(ps.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId());
        this.testDatas.createTestINRAPracticedPerennialCropCycle(this.croppingPlanEntries, ps);
        GrowingSystem growingSystem = ps.getGrowingSystem();
        PerformanceImpl performance = new PerformanceImpl();
        performance.setName("INRA_DONNEES_SYNTHETISEES");
        performance = this.performanceService.createOrUpdatePerformance((Performance)performance, Collections.singletonList(growingSystem.getGrowingPlan().getDomain().getTopiaId()), null, null, null, false);
        performance.setPracticed(true);
        StringWriter out = new StringWriter();
        IndicatorMockWriter writer = new IndicatorMockWriter(out);
        this.performanceService.convertToWriter((Performance)performance, (IndicatorWriter)writer, new Indicator[]{(Indicator)this.serviceFactory.newInstance(IndicatorIFT.class)});
        String content = out.toString();
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT total;2014;DOMAINE TEST IFT;1.7049999999999998"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT tot hts;2014;DOMAINE TEST IFT;1.7049999999999998"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT h;2014;DOMAINE TEST IFT;1.7049999999999998"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT f;2014;DOMAINE TEST IFT;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT i;2014;DOMAINE TEST IFT;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT ts;2014;DOMAINE TEST IFT;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT a;2014;DOMAINE TEST IFT;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT hh;2014;DOMAINE TEST IFT;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT biocontrole;2014;DOMAINE TEST IFT;0.0"));
        Assert.assertTrue((String)("Can't find pattern in content : " + content), (boolean)content.contains("DOMAINE TEST IFT;Efficience;Efficience;Indicateurs de pression d\u2019utilisation des intrants;IFT moyens biologiques;2014;DOMAINE TEST IFT;0.0"));
    }
}

