/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public class IndicatorMockWriter
implements IndicatorWriter {
    protected Writer writer;

    public IndicatorMockWriter(Writer writer) {
        this.writer = writer;
    }

    public void init() {
    }

    public void finish() {
    }

    protected void writeCsv(String ... args) {
        try {
            for (String arg : args) {
                this.writer.write(arg);
                this.writer.write(";");
            }
            this.writer.write("\n");
        }
        catch (IOException ex) {
            throw new AgrosystTechnicalException("Can't write in memory writer ? seriously ?", (Throwable)ex);
        }
    }

    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, Double value) {
        this.writeCsv(domain.getName(), indicatorCategory, indicatorName, campaigns, domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, Double value) {
        this.writeCsv(domain.getName(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }

    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), practicedSystem.getName(), indicatorCategory, indicatorName, campaigns, domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), plot.getName(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), plot.getName(), zone.getName(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }

    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), croppingPlanEntry.getName(), previousPlanEntry.getName(), indicatorCategory, indicatorName, campaigns, domain.getName(), String.valueOf(value));
    }

    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, PracticedCropCyclePhase phase, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), croppingPlanEntry.getName(), phase.getType().name(), indicatorCategory, indicatorName, campaigns, domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), croppingPlanEntry.getName(), previousPlanEntry.getName(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, CroppingPlanEntry croppingPlanEntry, EffectiveCropCyclePhase phase, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), croppingPlanEntry.getName(), phase.getType().name(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }

    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, PracticedIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), croppingPlanEntry.getName(), previousPlanEntry.getName(), intervention.getName(), indicatorCategory, indicatorName, campaigns, domain.getName(), String.valueOf(value));
    }

    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, PracticedCropCyclePhase phase, PracticedIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), croppingPlanEntry.getName(), phase.getType().name(), intervention.getName(), indicatorCategory, indicatorName, campaigns, domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), plot.getName(), zone.getName(), croppingPlanEntry.getName(), previousPlanEntry != null ? previousPlanEntry.getName() : "", intervention.getName(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }

    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone, CroppingPlanEntry croppingPlanEntry, EffectiveCropCyclePhase phase, EffectiveIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeCsv(domain.getName(), growingSystem.getName(), plot.getName(), zone.getName(), croppingPlanEntry.getName(), phase.getType().name(), intervention.getName(), indicatorCategory, indicatorName, String.valueOf(campaign), domain.getName(), String.valueOf(value));
    }
}

