/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.network;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.network.Networks;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class NetworkServiceTest
extends AbstractAgrosystTest {
    protected NetworkService networkService;

    @Before
    public void setupServices() throws TopiaException {
        this.networkService = (NetworkService)this.serviceFactory.newService(NetworkService.class);
        ((TestDatas)this.serviceFactory.newInstance(TestDatas.class)).createTestNetworks();
        this.loginAsAdmin();
    }

    @Test
    public void testSearchNetworks() {
        String r0TopiaId = (String)this.networkService.findNetworksByName("R0", null).iterator().next();
        String r1TopiaId = (String)this.networkService.findNetworksByName("R1", null).iterator().next();
        String r2TopiaId = (String)this.networkService.findNetworksByName("R2", null).iterator().next();
        String r3TopiaId = (String)this.networkService.findNetworksByName("R3", null).iterator().next();
        String r4TopiaId = (String)this.networkService.findNetworksByName("R4", null).iterator().next();
        String r5TopiaId = (String)this.networkService.findNetworksByName("R5", null).iterator().next();
        LinkedHashMap networks = this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), null, null, true);
        Assert.assertEquals((long)4L, (long)networks.size());
        Assert.assertTrue((boolean)networks.containsKey(r2TopiaId));
        Assert.assertTrue((boolean)networks.containsKey(r3TopiaId));
        Assert.assertTrue((boolean)networks.containsKey(r4TopiaId));
        networks = this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), (Set)Sets.newHashSet((Object[])new String[]{r2TopiaId}), null, true);
        Assert.assertEquals((long)3L, (long)networks.size());
        Assert.assertTrue((boolean)networks.containsKey(r3TopiaId));
        Assert.assertTrue((boolean)networks.containsKey(r4TopiaId));
        networks = this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), (Set)Sets.newHashSet((Object[])new String[]{r2TopiaId}), r3TopiaId, true);
        Assert.assertEquals((long)2L, (long)networks.size());
        Assert.assertTrue((boolean)networks.containsKey(r4TopiaId));
        networks = this.networkService.searchNameFilteredActiveNetworks("3", Integer.valueOf(10), null, null, true);
        Assert.assertEquals((long)1L, (long)networks.size());
        Assert.assertTrue((boolean)networks.containsKey(r3TopiaId));
        Network r2 = this.networkService.getNetwork(r2TopiaId);
        LinkedHashMap networks2 = this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), null, r2TopiaId, true);
        Assert.assertEquals((long)3L, (long)networks2.size());
        Assert.assertTrue((boolean)networks2.containsKey(r3TopiaId));
        Assert.assertTrue((boolean)networks2.containsKey(r4TopiaId));
        this.networkService.createOrUpdateNetwork(r2, Collections2.transform((Collection)r2.getManagers(), (Function)Networks.TO_MANAGER_DTO), (List)Lists.newArrayList((Object[])new String[]{r3TopiaId}));
        networks2 = this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), null, r2TopiaId, true);
        Assert.assertEquals((long)3L, (long)networks2.size());
        Assert.assertTrue((boolean)networks2.containsKey(r3TopiaId));
        Assert.assertTrue((boolean)networks2.containsKey(r4TopiaId));
        networks2 = this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), null, r3TopiaId, true);
        Assert.assertEquals((long)2L, (long)networks2.size());
        Assert.assertTrue((boolean)networks2.containsKey(r4TopiaId));
        networks2 = this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), null, null, false);
        Assert.assertEquals((long)5L, (long)networks2.size());
        Assert.assertTrue((boolean)networks2.containsKey(r0TopiaId));
        Assert.assertTrue((boolean)networks2.containsKey(r1TopiaId));
        Assert.assertTrue((boolean)networks2.containsKey(r2TopiaId));
        Assert.assertTrue((boolean)networks2.containsKey(r4TopiaId));
        Assert.assertTrue((boolean)networks2.containsKey(r5TopiaId));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSearchNetworksFails() {
        String r0TopiaId = (String)this.networkService.findNetworksByName("R0", null).iterator().next();
        this.networkService.searchNameFilteredActiveNetworks("R", Integer.valueOf(10), null, r0TopiaId, false);
    }
}

