/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.measurement;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.measure.HorizonType;
import fr.inra.agrosyst.api.entities.measure.MeasureImpl;
import fr.inra.agrosyst.api.entities.measure.MeasureType;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementSessionImpl;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.measure.ObservationImpl;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefMesureTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObs;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObsTopiaDao;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaDaoSupplier;

public class MeasurementServiceTest
extends AbstractAgrosystTest {
    protected MeasurementService measurementService;
    protected EffectiveCropCycleService effectiveCropCycleService;
    protected DomainService domainService;
    protected PlotService plotService;
    protected TestDatas testDatas;
    protected RefMesureTopiaDao refMesureTopiaDao;
    protected RefProtocoleVgObsTopiaDao refProtocoleVgObsTopiaDao;

    @Before
    public void setUp() {
        this.measurementService = (MeasurementService)this.serviceFactory.newService(MeasurementService.class);
        this.effectiveCropCycleService = (EffectiveCropCycleService)this.serviceFactory.newService(EffectiveCropCycleService.class);
        this.domainService = (DomainService)this.serviceFactory.newService(DomainService.class);
        this.plotService = (PlotService)this.serviceFactory.newService(PlotService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.refMesureTopiaDao = this.serviceContext.getDaoSupplier().getRefMesureDao();
        this.refProtocoleVgObsTopiaDao = this.serviceContext.getDaoSupplier().getRefProtocoleVgObsDao();
        this.loginAsAdmin();
    }

    protected void createTestMesures() {
        this.testDatas.createTestPlots();
        this.testDatas.importMesure();
        this.testDatas.importProtocoleVgObs();
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        Domain domainBaulon = (Domain)this.domainService.getFilteredDomains(domainFilter).getElements().get(0);
        List plots = this.plotService.findAllByDomain(domainBaulon);
        Plot plot1 = (Plot)plots.get(0);
        Zone zone1 = (Zone)this.plotService.getZonesAndUsages(plot1.getTopiaId()).getElements().get(0);
        Assert.assertNotNull((Object)zone1);
        MeasurementSessionImpl session = new MeasurementSessionImpl();
        session.setStartDate(this.serviceContext.getCurrentDate());
        session.setEndDate(this.serviceContext.getCurrentDate());
        MeasureImpl mesureSol = new MeasureImpl();
        mesureSol.setMeasurementType(MeasurementType.SOL);
        mesureSol.setMeasuringProtocol("test");
        mesureSol.setHorizonType(HorizonType.HT_0_15);
        mesureSol.setRepetitionNumber(Integer.valueOf(1));
        mesureSol.setSampling("ech-1");
        mesureSol.setRefMesure((RefMesure)this.refMesureTopiaDao.forNaturalId("Teneur en carbone organique", MeasurementType.SOL, VariableType.ANALYSE_DE_SOL).findUnique());
        mesureSol.setMeasureType(MeasureType.INDIVIDUAL_VALUE_COMPUTED);
        mesureSol.setMeasureUnit("g/kg");
        MeasureImpl measureMeteo = new MeasureImpl();
        measureMeteo.setMeasurementType(MeasurementType.METEO);
        ObservationImpl obsVgObs = new ObservationImpl();
        obsVgObs.setMeasurementType(MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES);
        obsVgObs.setProtocolVgObs(true);
        obsVgObs.setProtocol((RefProtocoleVgObs)this.refProtocoleVgObsTopiaDao.forNaturalId("PR036", "PR036-AEE166ANARLI-1", "1", "AAK36", "").findUnique());
        Assert.assertNotNull((Object)obsVgObs.getProtocol());
        obsVgObs.setComment("taiste");
        ObservationImpl obsStade = new ObservationImpl();
        obsStade.setMeasurementType(MeasurementType.STADE_CULTURE);
        session.addAllMeasurements(Arrays.asList(mesureSol, measureMeteo, obsStade, obsVgObs));
        this.measurementService.updateMeasurementSessions(zone1, Collections.singletonList(session));
    }

    @Test
    public void testEnumGetVariables() {
        this.testDatas.importMesure();
        Assert.assertTrue((this.measurementService.findAllVariableTypes(MeasurementType.PLANTE).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariableTypes(MeasurementType.SOL).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariableTypes(MeasurementType.TRANSFERT_DE_SOLUTES).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariableTypes(MeasurementType.GES).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariableTypes(MeasurementType.METEO).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.measurementService.findAllVariableTypes(MeasurementType.ADVENTICES).isEmpty());
        Assert.assertTrue((boolean)this.measurementService.findAllVariableTypes(MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES).isEmpty());
        Assert.assertTrue((boolean)this.measurementService.findAllVariableTypes(MeasurementType.STADE_CULTURE).isEmpty());
    }

    @Test
    public void testEnumGetMesures() {
        this.testDatas.importMesure();
        Assert.assertTrue((this.measurementService.findAllVariables(MeasurementType.PLANTE, VariableType.ANALYSES).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariables(MeasurementType.SOL, VariableType.ANALYSE_DE_SOL).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariables(MeasurementType.TRANSFERT_DE_SOLUTES, null).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariables(MeasurementType.GES, null).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.measurementService.findAllVariables(MeasurementType.METEO, null).size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void getCroppingPlanEntriesForZone() {
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importFertiMinUnifa();
        this.testDatas.createTestEffectiveInterventions();
        EffectiveZoneFilter plotFilter = new EffectiveZoneFilter();
        plotFilter.setPageSize(1);
        Zone zoneBaulon = (Zone)this.effectiveCropCycleService.getFilteredZones(plotFilter).getElements().get(0);
        TopiaDaoSupplier supplier = this.getDaoSupplier();
        Assert.assertEquals((Object)"TEST_PLOT_2", (Object)zoneBaulon.getPlot().getName());
        Set croppingPlanEntries = this.measurementService.getZoneCroppingPlanEntries(zoneBaulon);
        Assert.assertEquals((long)0L, (long)croppingPlanEntries.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXls() throws IOException {
        this.createTestMesures();
        EffectiveZoneFilter zoneFilter = new EffectiveZoneFilter();
        List zones = this.effectiveCropCycleService.getFilteredZones(zoneFilter).getElements();
        List zoneIds = Lists.transform((List)zones, (Function)Entities.GET_TOPIA_ID);
        InputStream is = null;
        try {
            is = this.measurementService.exportEffectiveMeasurementsAsXlsStream(zoneIds);
            Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXlsEmpty() throws IOException {
        InputStream is = null;
        try {
            is = this.measurementService.exportEffectiveMeasurementsAsXlsStream(null);
            Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportXls() throws IOException {
        this.createTestMesures();
        EffectiveZoneFilter zoneFilter = new EffectiveZoneFilter();
        List zones = this.effectiveCropCycleService.getFilteredZones(zoneFilter).getElements();
        List zoneIds = Lists.transform((List)zones, (Function)Entities.GET_TOPIA_ID);
        int sessionCount = 0;
        int mesureCount = 0;
        for (Zone zone : zones) {
            List sessions = this.measurementService.getZoneMeasurementSessions(zone);
            sessionCount += sessions.size();
            for (MeasurementSession session : sessions) {
                mesureCount += session.getMeasurements().size();
            }
        }
        Assert.assertEquals((long)1L, (long)sessionCount);
        Assert.assertEquals((long)4L, (long)mesureCount);
        InputStream is = null;
        try {
            is = this.measurementService.exportEffectiveMeasurementsAsXlsStream(zoneIds);
            this.measurementService.importEffectiveMeasurementsForXlsStream(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        sessionCount = 0;
        mesureCount = 0;
        for (Zone zone : zones) {
            List sessions = this.measurementService.getZoneMeasurementSessions(zone);
            sessionCount += sessions.size();
            for (MeasurementSession session : sessions) {
                mesureCount += session.getMeasurements().size();
            }
        }
        Assert.assertEquals((long)1L, (long)sessionCount);
        Assert.assertEquals((long)8L, (long)mesureCount);
    }
}

