/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.managementmode;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRuleImpl;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.Section;
import fr.inra.agrosyst.api.entities.managementmode.SectionImpl;
import fr.inra.agrosyst.api.entities.managementmode.SectionType;
import fr.inra.agrosyst.api.entities.managementmode.Strategy;
import fr.inra.agrosyst.api.entities.managementmode.StrategyImpl;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class ManagementModeServiceTest
extends AbstractAgrosystTest {
    protected DomainService domainService;
    protected GrowingSystemService growingSystemService;
    protected ManagementModeService service;
    protected TestDatas testDatas;

    @Before
    public void setupServices() throws TopiaException {
        this.service = (ManagementModeService)this.serviceFactory.newService(ManagementModeService.class);
        this.growingSystemService = (GrowingSystemService)this.serviceFactory.newService(GrowingSystemService.class);
        this.domainService = (DomainService)this.serviceFactory.newService(DomainService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.testDatas.testCreateManagementModes();
        this.loginAsAdmin();
    }

    @Test
    public void testGetBioAgressorTypes() {
        this.testDatas.importNuisiblesEDI();
        this.testDatas.importAdventices();
        List result = this.service.getBioAgressorTypes();
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertEquals((Object)BioAgressorType.ADVENTICE, result.get(0));
        Assert.assertEquals((Object)BioAgressorType.PLANTES_ENVAHISSANTES_ORIGINE_EXOTIQUE, result.get(4));
    }

    @Test
    public void testExtendManagementModeAndRules() throws DomainExtendException {
        GrowingSystemFilter filter = new GrowingSystemFilter();
        filter.setGrowingSystemName("Systeme de culture Baulon 1");
        List growingSystems = this.growingSystemService.getFilteredGrowingSystems(filter).getElements();
        GrowingSystem growingSystem = (GrowingSystem)growingSystems.get(0);
        Domain domain = growingSystem.getGrowingPlan().getDomain();
        ManagementMode managementMode = this.service.getManagementModeByGrowingSystem(growingSystem);
        DecisionRuleImpl rule = new DecisionRuleImpl();
        rule.setName("Rule baulon");
        rule.setInterventionType(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX);
        rule.setActive(true);
        rule.setCode(UUID.randomUUID().toString());
        rule.setVersionNumber(0);
        rule = this.service.createOrUpdateDecisionRule((DecisionRule)rule, growingSystem.getGrowingPlan().getDomain().getCode(), null, null);
        SectionImpl section = new SectionImpl();
        section.setSectionType(SectionType.MALADIES);
        managementMode.addSections((Section)section);
        StrategyImpl strategy = new StrategyImpl();
        strategy.setExplanation("A Kadoc");
        section.addStrategies((Strategy)strategy);
        strategy.addRules((DecisionRule)rule);
        this.service.createOrUpdateManagementMode(managementMode, growingSystem.getTopiaId(), null);
        this.domainService.extendDomain(domain.getTopiaId(), 2016);
        filter.setCampaign(Integer.valueOf(2016));
        growingSystems = this.growingSystemService.getFilteredGrowingSystems(filter).getElements();
        Assert.assertEquals((long)1L, (long)growingSystems.size());
    }

    @Test
    public void testSameDecisionRuleName() throws DomainExtendException {
        DomainFilter df = new DomainFilter();
        df.setDomainName("Baulon");
        ResultList domains = this.domainService.getFilteredDomains(df);
        Domain domain = (Domain)domains.iterator().next();
        DecisionRuleImpl rule = new DecisionRuleImpl();
        rule.setName("Rule baulon");
        rule.setInterventionType(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX);
        rule.setActive(true);
        rule.setCode(UUID.randomUUID().toString());
        rule.setVersionNumber(0);
        DecisionRule decisionRule = this.service.createOrUpdateDecisionRule((DecisionRule)rule, domain.getCode(), null, null);
        DecisionRule newVersion = this.service.createNewDecisonRuleVersion(decisionRule.getCode(), "pouette");
        newVersion.setName("azerty");
        this.service.createOrUpdateDecisionRule(newVersion, domain.getCode(), null, null);
        List list = this.service.getRelatedDecisionRules(newVersion.getCode());
        Assert.assertEquals((long)2L, (long)list.size());
        for (DecisionRule dr : list) {
            Assert.assertEquals((Object)"azerty", (Object)dr.getName());
        }
    }
}

