/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.growingplan;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class GrowingPlanServiceTest
extends AbstractAgrosystTest {
    protected GrowingPlanService service;

    @Before
    public void setupServices() throws TopiaException {
        this.service = (GrowingPlanService)this.serviceFactory.newService(GrowingPlanService.class);
        TestDatas testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        testDatas.createTestGrowingPlans();
        this.loginAsAdmin();
    }

    @Test
    public void getFilterGrowingPlans() {
        ResultList result = this.service.getFilteredGrowingPlans(null);
        Assert.assertEquals((long)5L, (long)result.getPager().getRecords());
        GrowingPlanFilter filter = new GrowingPlanFilter();
        result = this.service.getFilteredGrowingPlans(filter);
        Assert.assertEquals((long)5L, (long)result.getPager().getRecords());
        filter.setGrowingPlanName("Baulon");
        result = this.service.getFilteredGrowingPlans(filter);
        Assert.assertEquals((long)1L, (long)result.getPager().getRecords());
    }

    @Test
    public void testDuplicateGrowingPlan() {
        GrowingPlanFilter filter = new GrowingPlanFilter();
        filter.setGrowingPlanName("Baulon");
        GrowingPlan growingPlan = (GrowingPlan)this.service.getFilteredGrowingPlans(filter).getElements().get(0);
        GrowingPlan duplicate = this.service.duplicateGrowingPlan(growingPlan.getTopiaId(), growingPlan.getDomain().getTopiaId(), true);
        Assert.assertNotNull((Object)duplicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXls() throws IOException {
        GrowingPlanFilter filter = new GrowingPlanFilter();
        List growingPlans = this.service.getFilteredGrowingPlans(filter).getElements();
        List gpIds = Lists.transform((List)growingPlans, (Function)Entities.GET_TOPIA_ID);
        InputStream is = null;
        try {
            is = this.service.exportGrowingPlanAsXlsStream(gpIds);
            Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXlsEmpty() throws IOException {
        InputStream is = null;
        try {
            is = this.service.exportGrowingPlanAsXlsStream(null);
            Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportXls() throws IOException {
        GrowingPlanFilter filter = new GrowingPlanFilter();
        List growingPlans = this.service.getFilteredGrowingPlans(filter).getElements();
        Assert.assertEquals((long)5L, (long)growingPlans.size());
        List gpIds = Lists.transform((List)growingPlans, (Function)Entities.GET_TOPIA_ID);
        InputStream is = null;
        try {
            is = this.service.exportGrowingPlanAsXlsStream(gpIds);
            this.service.importGrowingPlanForXlsStream(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        growingPlans = this.service.getFilteredGrowingPlans(filter).getElements();
        Assert.assertEquals((long)10L, (long)growingPlans.size());
    }
}

