/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.generic;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class GenericServiceTest
extends AbstractAgrosystTest {
    protected GenericEntityService service;
    protected TestDatas testDatas;

    @Before
    public void setupServices() throws TopiaException {
        this.service = (GenericEntityService)this.serviceFactory.newService(GenericEntityService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.loginAsAdmin();
    }

    @Test
    public void testCountEnum() throws Exception {
        Map map = this.service.countEntities(new Class[]{DomainType.class, Sector.class, PracticedSystemSource.class, WaterFlowDistance.class, Zoning.class, MaxSlope.class});
        Assert.assertEquals((long)3L, (long)((Long)map.get(DomainType.class.getName())));
        Assert.assertEquals((long)7L, (long)((Long)map.get(Sector.class.getName())));
        Assert.assertEquals((long)4L, (long)((Long)map.get(WaterFlowDistance.class.getName())));
        Assert.assertEquals((long)0L, (long)((Long)this.service.countEntities(new Class[]{RefLocation.class}).get(RefLocation.class.getName())));
    }

    @Test
    public void testGetEntitiesEnum() throws Exception {
        ResultList map = this.service.listEntities(Sector.class, null);
        Assert.assertEquals((long)7L, (long)map.getElements().size());
    }

    @Test
    public void testGenericSearchFilterLowerInt() {
        this.testDatas.importNuisiblesEDI();
        GenericFilter filter = new GenericFilter();
        HashMap propertyNameAndValues = Maps.newHashMap();
        propertyNameAndValues.put("reference_id", "18352");
        filter.setPropertyNamesAndValues((Map)propertyNameAndValues);
        ResultList result = this.service.listEntities(RefNuisibleEDI.class, filter);
        Assert.assertEquals((long)1L, (long)result.getPager().getRecords());
        propertyNameAndValues.put("reference_id", "18");
        result = this.service.listEntities(RefNuisibleEDI.class, filter);
        Assert.assertEquals((long)0L, (long)result.getPager().getRecords());
    }

    @Test
    public void testGenericSearchFilterLike() {
        this.testDatas.importNuisiblesEDI();
        GenericFilter filter = new GenericFilter();
        HashMap propertyNameAndValues = Maps.newHashMap();
        propertyNameAndValues.put("reference_label", "Acarien");
        filter.setPropertyNamesAndValues((Map)propertyNameAndValues);
        ResultList result = this.service.listEntities(RefNuisibleEDI.class, filter);
        Assert.assertEquals((long)16L, (long)result.getPager().getRecords());
    }

    @Test
    public void testGenericSearchFilterInheritance() {
        this.testDatas.importMaterielsTracteur();
        GenericFilter filter = new GenericFilter();
        HashMap propertyNameAndValues = Maps.newHashMap();
        propertyNameAndValues.put("typeMateriel1", "TRACTEURS CLASSIQUES");
        filter.setPropertyNamesAndValues((Map)propertyNameAndValues);
        ResultList result = this.service.listEntities(RefMaterielTraction.class, filter);
        Assert.assertEquals((long)50L, (long)result.getPager().getRecords());
    }
}

