/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.effective;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.api.services.effective.TargetedZones;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class EffectiveCropCycleServiceTest
extends AbstractAgrosystTest {
    public static final String INTERVENTION_COPY_PREFIX = "COPY OF:";
    protected MeasurementService measurementService;
    protected EffectiveCropCycleService effectiveCropCycleService;
    protected ReferentialService referentialService;
    protected TestDatas testDatas;
    protected ToolsCouplingTopiaDao toolsCouplingDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao;
    public static final Function<CroppingPlanSpecies, String> GET_CROPPING_PLAN_SPECIES_CODE = new Function<CroppingPlanSpecies, String>(){

        public String apply(CroppingPlanSpecies input) {
            return input.getCode();
        }
    };
    protected static final Function<SeedingActionSpecies, String> GET_SEEDING_ACTION_SPECIES_CODE = new Function<SeedingActionSpecies, String>(){

        public String apply(SeedingActionSpecies input) {
            return input == null ? null : input.getSpeciesCode();
        }
    };
    protected static final Function<SpeciesStadeDto, String> GET_SPECIES_STADE_SPECIES_CODE = new Function<SpeciesStadeDto, String>(){

        public String apply(SpeciesStadeDto input) {
            return input == null ? null : input.getSpeciesCode();
        }
    };
    protected static final Function<EffectiveInterventionDto, String> GET_INTERVENTION_BY_NAME = new Function<EffectiveInterventionDto, String>(){

        public String apply(EffectiveInterventionDto input) {
            return input == null ? null : input.getName();
        }
    };

    @Before
    public void setupServices() throws TopiaException {
        this.measurementService = (MeasurementService)this.serviceFactory.newService(MeasurementService.class);
        this.effectiveCropCycleService = (EffectiveCropCycleService)this.serviceFactory.newService(EffectiveCropCycleService.class);
        this.referentialService = (ReferentialService)this.serviceFactory.newService(ReferentialService.class);
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.toolsCouplingDao = this.getPersistenceContext().getToolsCouplingDao();
        this.croppingPlanEntryDao = this.getPersistenceContext().getCroppingPlanEntryDao();
        this.croppingPlanSpeciesDao = this.getPersistenceContext().getCroppingPlanSpeciesDao();
        this.loginAsAdmin();
    }

    @Test
    public void testPreviousYearCroppingPlanEntry() {
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importFertiMinUnifa();
        this.testDatas.createTestEffectiveInterventions();
        EffectiveZoneFilter plotFilter = new EffectiveZoneFilter();
        plotFilter.setPageSize(1);
        Zone zoneBaulon = (Zone)this.effectiveCropCycleService.getFilteredZones(plotFilter).getElements().get(0);
        Assert.assertEquals((Object)"TEST_PLOT_2", (Object)zoneBaulon.getPlot().getName());
        CroppingPlanEntry croppingPlanEntry = this.effectiveCropCycleService.getPreviousCampaignCroppingPlanEntry(zoneBaulon.getTopiaId());
        Assert.assertNull((Object)croppingPlanEntry);
    }

    @Test
    public void testOrderBy() {
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importFertiMinUnifa();
        this.testDatas.createTestEffectiveInterventions();
        EffectiveZoneFilter plotFilter = new EffectiveZoneFilter();
        plotFilter.setPageSize(Integer.MAX_VALUE);
        ResultList zones = this.effectiveCropCycleService.getFilteredZones(plotFilter);
        Assert.assertEquals((long)6L, (long)zones.getElements().size());
    }

    @Test
    public void testDuplicationAndCopy() {
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importFertiMinUnifa();
        this.testDatas.createTestEffectiveInterventionsRelatedToBadSpeciesZones();
        List<Zone> zones = this.testDatas.getPlotNameOrderedZones();
        Zone zpPlotBaulon1 = zones.get(0);
        this.testDatas.getCroppingPlanEntriesForZone(zpPlotBaulon1);
        List<CroppingPlanEntry> croppingPlanEntries = this.testDatas.getCroppingPlanEntriesForZone(zpPlotBaulon1);
        ImmutableMap indexedCroppingPlanEntries = Maps.uniqueIndex(croppingPlanEntries, (Function)Entities.GET_TOPIA_ID);
        HashMap zpPlotBaulon1SpeciesByCodes = Maps.newHashMap();
        for (CroppingPlanEntry croppingPlanEntry : indexedCroppingPlanEntries.values()) {
            List specieses = croppingPlanEntry.getCroppingPlanSpecies();
            for (CroppingPlanSpecies species : specieses) {
                zpPlotBaulon1SpeciesByCodes.put(species.getCode(), species);
            }
        }
        List fromPerennialCropCycles = this.effectiveCropCycleService.getAllEffectivePerennialCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        EffectivePerennialCropCycleDto fromEffectivePerennialCropCycleDto = (EffectivePerennialCropCycleDto)fromPerennialCropCycles.get(0);
        CroppingPlanEntry fromPhaseCroppingPlanEntry = (CroppingPlanEntry)indexedCroppingPlanEntries.get(fromEffectivePerennialCropCycleDto.getCroppingPlanEntryId());
        ImmutableMap phaseSpeciesByCodes = Maps.uniqueIndex((Iterable)fromPhaseCroppingPlanEntry.getCroppingPlanSpecies(), GET_CROPPING_PLAN_SPECIES_CODE);
        List fromSeasonalCropCycles = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        List fromPhaseInterventions = ((EffectiveCropCyclePhaseDto)fromEffectivePerennialCropCycleDto.getPhaseDtos().get(0)).getInterventions();
        EffectiveSeasonalCropCycleDto effectiveSeasonalCropCycleDto = (EffectiveSeasonalCropCycleDto)fromSeasonalCropCycles.get(0);
        List fromNodesDtos = effectiveSeasonalCropCycleDto.getNodeDtos();
        ArrayList fromNodeInterventions = Lists.newArrayList();
        for (EffectiveCropCycleNodeDto fromNodeDto : fromNodesDtos) {
            List interventions = fromNodeDto.getInterventions();
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)interventions));
            fromNodeInterventions.addAll(interventions);
        }
        this.effectiveCropCycleService.duplicateEffectiveCropCycles(zpPlotBaulon1.getTopiaId(), zpPlotBaulon1.getTopiaId());
        List<EffectivePerennialCropCycleDto> perennialDuplicatedCycles = this.validDuplicatedEffectivePerennialCropCycle(zpPlotBaulon1, (Map<String, CroppingPlanEntry>)indexedCroppingPlanEntries, (Map<String, CroppingPlanSpecies>)phaseSpeciesByCodes, fromPhaseInterventions);
        List seasonalDuplicatedCycle = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        this.validDuplicatedSeasonalCropCycle((Map<String, CroppingPlanEntry>)indexedCroppingPlanEntries, zpPlotBaulon1SpeciesByCodes, fromNodeInterventions, seasonalDuplicatedCycle);
        EffectiveCropCycleNodeDto nodeDto = (EffectiveCropCycleNodeDto)((EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0)).getNodeDtos().get(0);
        ArrayList notIntermediateInterventions = Lists.newArrayList();
        for (EffectiveInterventionDto effectiveInterventionDto : nodeDto.getInterventions()) {
            if (effectiveInterventionDto.isIntermediateCrop()) continue;
            notIntermediateInterventions.add(effectiveInterventionDto);
        }
        int nbExpectedInterventions = nodeDto.getInterventions().size() + notIntermediateInterventions.size();
        String cropId = nodeDto.getCroppingPlanEntryId();
        TargetedZones notIntermediateTargetedZone = new TargetedZones();
        notIntermediateTargetedZone.setNodes((List)Lists.newArrayList((Object[])new String[]{nodeDto.getNodeId()}));
        notIntermediateTargetedZone.setCroppingPlanEntryId(cropId);
        notIntermediateTargetedZone.setZoneId(zpPlotBaulon1.getTopiaId());
        ArrayList notIntermediateTargetedZones = Lists.newArrayList((Object[])new TargetedZones[]{notIntermediateTargetedZone});
        for (EffectiveInterventionDto fromEffectiveInterventionDto : notIntermediateInterventions) {
            fromEffectiveInterventionDto.setName(INTERVENTION_COPY_PREFIX + fromEffectiveInterventionDto.getName());
        }
        this.effectiveCropCycleService.copyInterventions((List)notIntermediateTargetedZones, (List)notIntermediateInterventions);
        seasonalDuplicatedCycle = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        EffectiveCropCycleNodeDto targetedNode = (EffectiveCropCycleNodeDto)((EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0)).getNodeDtos().get(0);
        List toInterventionDtos = targetedNode.getInterventions();
        Assert.assertEquals((long)nbExpectedInterventions, (long)toInterventionDtos.size());
        this.validCopiedInterventions(notIntermediateInterventions, toInterventionDtos, zpPlotBaulon1SpeciesByCodes);
        EffectiveCropCycleNodeDto nodeDto2 = (EffectiveCropCycleNodeDto)((EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0)).getNodeDtos().get(1);
        nbExpectedInterventions = nodeDto2.getInterventions().size() + notIntermediateInterventions.size();
        cropId = nodeDto2.getCroppingPlanEntryId();
        notIntermediateTargetedZone = new TargetedZones();
        notIntermediateTargetedZone.setNodes((List)Lists.newArrayList((Object[])new String[]{nodeDto2.getNodeId()}));
        notIntermediateTargetedZone.setCroppingPlanEntryId(cropId);
        notIntermediateTargetedZone.setZoneId(zpPlotBaulon1.getTopiaId());
        notIntermediateTargetedZones = Lists.newArrayList((Object[])new TargetedZones[]{notIntermediateTargetedZone});
        for (EffectiveInterventionDto fromEffectiveInterventionDto : notIntermediateInterventions) {
            fromEffectiveInterventionDto.setName("TO_OTHER_CROP_" + fromEffectiveInterventionDto.getName());
        }
        this.effectiveCropCycleService.copyInterventions((List)notIntermediateTargetedZones, (List)notIntermediateInterventions);
        seasonalDuplicatedCycle = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        targetedNode = (EffectiveCropCycleNodeDto)((EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0)).getNodeDtos().get(1);
        toInterventionDtos = targetedNode.getInterventions();
        Assert.assertEquals((long)nbExpectedInterventions, (long)toInterventionDtos.size());
        this.validCopiedInterventions(notIntermediateInterventions, toInterventionDtos, zpPlotBaulon1SpeciesByCodes);
        targetedNode = (EffectiveCropCycleNodeDto)((EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0)).getNodeDtos().get(0);
        toInterventionDtos = targetedNode.getInterventions();
        String intermediateCropId = null;
        List connectionDtos = ((EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0)).getConnectionDtos();
        for (EffectiveCropCycleConnectionDto connectionDto : connectionDtos) {
            if (!nodeDto.getNodeId().contentEquals(connectionDto.getTargetId())) continue;
            intermediateCropId = connectionDto.getIntermediateCroppingPlanEntryId();
        }
        TargetedZones intermediateTargetedZone = new TargetedZones();
        intermediateTargetedZone.setNodes((List)Lists.newArrayList((Object[])new String[]{nodeDto.getNodeId()}));
        intermediateTargetedZone.setCroppingPlanEntryId(intermediateCropId);
        intermediateTargetedZone.setZoneId(zpPlotBaulon1.getTopiaId());
        ArrayList intermediateTargetedZones = Lists.newArrayList((Object[])new TargetedZones[]{intermediateTargetedZone});
        ArrayList intermediateInterventions = Lists.newArrayList();
        for (EffectiveInterventionDto toInterventionDto : toInterventionDtos) {
            if (!toInterventionDto.isIntermediateCrop()) continue;
            toInterventionDto.setName(INTERVENTION_COPY_PREFIX + toInterventionDto.getName());
            intermediateInterventions.add(toInterventionDto);
        }
        nbExpectedInterventions = targetedNode.getInterventions().size() + intermediateInterventions.size();
        this.effectiveCropCycleService.copyInterventions((List)intermediateTargetedZones, (List)intermediateInterventions);
        seasonalDuplicatedCycle = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        targetedNode = (EffectiveCropCycleNodeDto)((EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0)).getNodeDtos().get(0);
        toInterventionDtos = targetedNode.getInterventions();
        Assert.assertEquals((long)nbExpectedInterventions, (long)toInterventionDtos.size());
        this.validCopiedInterventions(intermediateInterventions, toInterventionDtos, zpPlotBaulon1SpeciesByCodes);
        fromPerennialCropCycles = this.effectiveCropCycleService.getAllEffectivePerennialCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        fromEffectivePerennialCropCycleDto = (EffectivePerennialCropCycleDto)fromPerennialCropCycles.get(0);
        fromPhaseCroppingPlanEntry = (CroppingPlanEntry)indexedCroppingPlanEntries.get(fromEffectivePerennialCropCycleDto.getCroppingPlanEntryId());
        EffectiveCropCyclePhaseDto phaseDto = (EffectiveCropCyclePhaseDto)fromEffectivePerennialCropCycleDto.getPhaseDtos().get(0);
        Assert.assertNotNull((Object)phaseDto);
        fromPhaseInterventions = phaseDto.getInterventions();
        nbExpectedInterventions = fromPhaseInterventions.size() * 2;
        cropId = fromPhaseCroppingPlanEntry.getTopiaId();
        TargetedZones perennialTargetedZone = new TargetedZones();
        perennialTargetedZone.setPhases((List)Lists.newArrayList((Object[])new String[]{phaseDto.getTopiaId()}));
        perennialTargetedZone.setCroppingPlanEntryId(cropId);
        perennialTargetedZone.setZoneId(zpPlotBaulon1.getTopiaId());
        ArrayList perennialTargetedZones = Lists.newArrayList((Object[])new TargetedZones[]{perennialTargetedZone});
        for (EffectiveInterventionDto fromEffectiveInterventionDto : fromPhaseInterventions) {
            fromEffectiveInterventionDto.setName(INTERVENTION_COPY_PREFIX + fromEffectiveInterventionDto.getName());
        }
        this.effectiveCropCycleService.copyInterventions((List)perennialTargetedZones, fromPhaseInterventions);
        List toPerennialCropCycles = this.effectiveCropCycleService.getAllEffectivePerennialCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        EffectivePerennialCropCycleDto toEffectivePerennialCropCycleDto = (EffectivePerennialCropCycleDto)toPerennialCropCycles.get(0);
        EffectiveCropCyclePhaseDto toPhaseDto = (EffectiveCropCyclePhaseDto)toEffectivePerennialCropCycleDto.getPhaseDtos().get(0);
        Assert.assertNotNull((Object)toPhaseDto);
        toInterventionDtos = toPhaseDto.getInterventions();
        Assert.assertEquals((long)nbExpectedInterventions, (long)toInterventionDtos.size());
        this.validCopiedInterventions(fromPhaseInterventions, toInterventionDtos, zpPlotBaulon1SpeciesByCodes);
        EffectiveSeasonalCropCycleDto seasonalCropCycleDto = (EffectiveSeasonalCropCycleDto)seasonalDuplicatedCycle.get(0);
        seasonalCropCycleDto.setNodeDtos(null);
        this.effectiveCropCycleService.updateEffectiveCropCycles(zpPlotBaulon1.getTopiaId(), seasonalDuplicatedCycle, perennialDuplicatedCycles, null);
        seasonalDuplicatedCycle = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        Assert.assertTrue((boolean)seasonalDuplicatedCycle.isEmpty());
    }

    protected void validDuplicatedSeasonalCropCycle(Map<String, CroppingPlanEntry> indexedCroppingPlanEntries, Map<String, CroppingPlanSpecies> zpPlotBaulon1SpeciesByCodes, List<EffectiveInterventionDto> fromNodeInterventions, List<EffectiveSeasonalCropCycleDto> seasonalDuplicatedCycle) {
        Assert.assertEquals((long)1L, (long)seasonalDuplicatedCycle.size());
        Assert.assertTrue((seasonalDuplicatedCycle.get(0).getNodeDtos().size() > 0 ? 1 : 0) != 0);
        List nodes = seasonalDuplicatedCycle.get(0).getNodeDtos();
        ArrayList toNodeInterventions = Lists.newArrayList();
        for (EffectiveCropCycleNodeDto node : nodes) {
            CroppingPlanEntry croppingPlanEntry = indexedCroppingPlanEntries.get(node.getCroppingPlanEntryId());
            Assert.assertNotNull((Object)croppingPlanEntry);
            toNodeInterventions.addAll(node.getInterventions());
        }
        this.validDuplicatedInterventions(fromNodeInterventions, toNodeInterventions, zpPlotBaulon1SpeciesByCodes);
    }

    protected List<EffectivePerennialCropCycleDto> validDuplicatedEffectivePerennialCropCycle(Zone zpPlotBaulon1, Map<String, CroppingPlanEntry> indexedCroppingPlanEntries, Map<String, CroppingPlanSpecies> phaseSpeciesByCodes, List<EffectiveInterventionDto> fromPhaseInterventions) {
        List perennialDuplicatedCycles = this.effectiveCropCycleService.getAllEffectivePerennialCropCyclesDtos(zpPlotBaulon1.getTopiaId());
        Assert.assertEquals((long)1L, (long)perennialDuplicatedCycles.size());
        EffectivePerennialCropCycleDto perennialCropCycleDto = (EffectivePerennialCropCycleDto)perennialDuplicatedCycles.get(0);
        Assert.assertNotNull((Object)indexedCroppingPlanEntries.get(perennialCropCycleDto.getCroppingPlanEntryId()));
        List speciesStadeDtos = ((EffectiveInterventionDto)((EffectiveCropCyclePhaseDto)perennialCropCycleDto.getPhaseDtos().get(0)).getInterventions().get(0)).getSpeciesStadesDtos();
        Assert.assertEquals((long)1L, (long)speciesStadeDtos.size());
        List phaseDtos = ((EffectivePerennialCropCycleDto)perennialDuplicatedCycles.get(0)).getPhaseDtos();
        Assert.assertTrue((!phaseDtos.isEmpty() ? 1 : 0) != 0);
        for (EffectiveCropCyclePhaseDto phaseDto : phaseDtos) {
            List perennialInterventions = phaseDto.getInterventions();
            this.validDuplicatedInterventions(fromPhaseInterventions, perennialInterventions, phaseSpeciesByCodes);
        }
        return perennialDuplicatedCycles;
    }

    protected void validCopiedInterventions(List<EffectiveInterventionDto> fromInterventions, List<EffectiveInterventionDto> toInterventions, Map<String, CroppingPlanSpecies> zpPlotBaulon1SpeciesByCode) {
        for (EffectiveInterventionDto copiedInterventionDto : toInterventions) {
            if (!copiedInterventionDto.getName().contains(INTERVENTION_COPY_PREFIX)) continue;
            String fromName = StringUtils.remove((String)copiedInterventionDto.getName(), (String)INTERVENTION_COPY_PREFIX);
            for (EffectiveInterventionDto fromInterventionDto : fromInterventions) {
                if (!fromInterventionDto.getName().contains(fromName)) continue;
                this.validFromToIntervention(fromInterventionDto, copiedInterventionDto, zpPlotBaulon1SpeciesByCode);
            }
        }
    }

    public void validDuplicatedInterventions(List<EffectiveInterventionDto> fromInterventionDtos, List<EffectiveInterventionDto> toInterventionDtos, Map<String, CroppingPlanSpecies> zpPlotBaulon1SpeciesByCode) {
        Assert.assertNotNull(toInterventionDtos);
        Assert.assertTrue((!toInterventionDtos.isEmpty() ? 1 : 0) != 0);
        ImmutableMap toInterventionsByNames = Maps.uniqueIndex(toInterventionDtos, GET_INTERVENTION_BY_NAME);
        for (EffectiveInterventionDto fromInterventionDto : fromInterventionDtos) {
            EffectiveInterventionDto toIntervention = (EffectiveInterventionDto)toInterventionsByNames.get(fromInterventionDto.getName());
            this.validFromToIntervention(fromInterventionDto, toIntervention, zpPlotBaulon1SpeciesByCode);
        }
    }

    protected void validFromToIntervention(EffectiveInterventionDto fromIntervention, EffectiveInterventionDto toIntervention, Map<String, CroppingPlanSpecies> zpPlotBaulon1SpeciesByCode) {
        if (!"Bad node intervention".contains(fromIntervention.getName())) {
            Assert.assertNotNull((Object)toIntervention);
            List fromSpeciesStadeDtos = fromIntervention.getSpeciesStadesDtos();
            Set fromToolsCouplingsCodes = fromIntervention.getToolsCouplingCodes();
            List fromAbstractInputs = fromIntervention.getInputs();
            Collection fromAbstractActions = fromIntervention.getActions();
            List toSpeciesStadeDtos = toIntervention.getSpeciesStadesDtos();
            Set toToolsCouplingsCodes = toIntervention.getToolsCouplingCodes();
            List toAbstractInputs = toIntervention.getInputs();
            Collection toAbstractActions = toIntervention.getActions();
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)toSpeciesStadeDtos));
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)toToolsCouplingsCodes));
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)toAbstractInputs));
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)toAbstractActions));
            Assert.assertEquals((long)fromSpeciesStadeDtos.size(), (long)toSpeciesStadeDtos.size());
            Assert.assertEquals((long)fromToolsCouplingsCodes.size(), (long)toToolsCouplingsCodes.size());
            Assert.assertEquals((long)fromAbstractInputs.size(), (long)toAbstractInputs.size());
            Assert.assertEquals((long)fromAbstractActions.size(), (long)toAbstractActions.size());
            Assert.assertEquals((Object)fromIntervention.getComment(), (Object)toIntervention.getComment());
            Assert.assertEquals((Object)fromIntervention.getStartInterventionDate(), (Object)toIntervention.getStartInterventionDate());
            Assert.assertEquals((Object)fromIntervention.isIntermediateCrop(), (Object)toIntervention.isIntermediateCrop());
            Assert.assertEquals((Object)fromIntervention.getTillageDepth(), (Object)toIntervention.getTillageDepth());
            Assert.assertEquals((Object)fromIntervention.getOtherToolSettings(), (Object)toIntervention.getOtherToolSettings());
            Assert.assertEquals((Object)fromIntervention.getWorkRate(), (Object)toIntervention.getWorkRate());
            Assert.assertEquals((Object)fromIntervention.getWorkRateUnit(), (Object)toIntervention.getWorkRateUnit());
            Assert.assertEquals((Object)fromIntervention.getProgressionSpeed(), (Object)toIntervention.getProgressionSpeed());
            Assert.assertEquals((Object)fromIntervention.getInvolvedPeopleCount(), (Object)toIntervention.getInvolvedPeopleCount());
            Assert.assertEquals((Object)fromIntervention.getEndInterventionDate(), (Object)toIntervention.getEndInterventionDate());
            Assert.assertEquals((long)fromIntervention.getTransitCount(), (long)toIntervention.getTransitCount());
            Assert.assertEquals((Object)fromIntervention.getTransitVolume(), (Object)toIntervention.getTransitVolume());
            Assert.assertEquals((Object)fromIntervention.getTransitVolumeUnit(), (Object)toIntervention.getTransitVolumeUnit());
            Assert.assertEquals((Object)fromIntervention.getNbBalls(), (Object)toIntervention.getNbBalls());
            Assert.assertEquals((Object)fromIntervention.getEdaplosIssuerId(), (Object)toIntervention.getEdaplosIssuerId());
            Assert.assertTrue((fromIntervention.getSpatialFrequency() == toIntervention.getSpatialFrequency() ? 1 : 0) != 0);
            this.validSpeciesStades(fromSpeciesStadeDtos, toIntervention, zpPlotBaulon1SpeciesByCode);
            this.validToolsCouplingCode(fromToolsCouplingsCodes, toToolsCouplingsCodes);
            this.validActions(fromAbstractActions, toIntervention);
        }
    }

    protected void validSpeciesStades(List<SpeciesStadeDto> fromSpeciesStades, EffectiveInterventionDto toIntervention, Map<String, CroppingPlanSpecies> zpPlotBaulon1SpeciesByCode) {
        List toSpeciesStades = toIntervention.getSpeciesStadesDtos();
        ImmutableMap speciesStadeDtoBySpeciesCodes = Maps.uniqueIndex(fromSpeciesStades, GET_SPECIES_STADE_SPECIES_CODE);
        for (SpeciesStadeDto toSpeciesStade : toSpeciesStades) {
            Assert.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{toSpeciesStade.getSpeciesCode()}));
            CroppingPlanSpecies species = zpPlotBaulon1SpeciesByCode.get(toSpeciesStade.getSpeciesCode());
            if (!toIntervention.getName().contains("Baulon seasonnal intervention_n1")) {
                Assert.assertTrue((species != null ? 1 : 0) != 0);
                SpeciesStadeDto fromSpeciesStade = (SpeciesStadeDto)speciesStadeDtoBySpeciesCodes.get(toSpeciesStade.getSpeciesCode());
                Assert.assertTrue((fromSpeciesStade != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)fromSpeciesStade.getStadeMin().getTopiaId().contentEquals(toSpeciesStade.getStadeMin().getTopiaId()));
                Assert.assertTrue((boolean)fromSpeciesStade.getStadeMax().getTopiaId().contentEquals(toSpeciesStade.getStadeMax().getTopiaId()));
                continue;
            }
            Assert.assertNull((Object)toSpeciesStade.getStadeMax());
            Assert.assertNull((Object)toSpeciesStade.getStadeMin());
            Assert.assertNotNull((Object)toSpeciesStade.getSpeciesCode());
        }
    }

    protected void validToolsCouplingCode(Set<String> fromToolsCouplingsCodes, Set<String> toToolsCouplingsCodes) {
        for (String fromToolsCouplingsCode : fromToolsCouplingsCodes) {
            Assert.assertTrue((boolean)toToolsCouplingsCodes.contains(fromToolsCouplingsCode));
        }
    }

    protected void validActions(Collection<AbstractAction> fromActions, EffectiveInterventionDto toIntervention) {
        Collection toActions = toIntervention.getActions();
        boolean seedingActionSpeciesFound = false;
        for (AbstractAction fromAction : fromActions) {
            if (!(fromAction instanceof SeedingAction)) continue;
            for (AbstractAction toAction : toActions) {
                if (!(toAction instanceof SeedingAction)) continue;
                Collection seedingActionSpecieses = ((SeedingAction)toAction).getSeedingSpecies();
                ImmutableMap indexedSeedingActionSpecies = Maps.uniqueIndex((Iterable)seedingActionSpecieses, GET_SEEDING_ACTION_SPECIES_CODE);
                int nbExpected = 1;
                Assert.assertEquals((long)nbExpected, (long)seedingActionSpecieses.size());
                seedingActionSpeciesFound = true;
                for (SeedingActionSpecies seedingActionSpeciese : seedingActionSpecieses) {
                    Assert.assertNotNull(indexedSeedingActionSpecies.get(seedingActionSpeciese.getSpeciesCode()));
                }
            }
        }
        Assert.assertTrue((boolean)seedingActionSpeciesFound);
    }
}

