/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.domain;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainImpl;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.EquipmentImpl;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.MaterielType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingImpl;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingResult;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingStatus;
import fr.inra.agrosyst.api.services.edaplos.EdaplosService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.referential.TypeMaterielFilter;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import fr.inra.agrosyst.services.domain.DomainServiceImplTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.util.FileUtil;

public class DomainServiceTest
extends AbstractAgrosystTest {
    private static final Log log = LogFactory.getLog(DomainServiceTest.class);
    protected DomainService domainService;
    protected EdaplosService edaplosService;
    protected PlotService plotService;
    protected ReferentialService referentialService;
    protected ImportService importService;
    protected TestDatas testDatas;
    protected DomainTopiaDao domainTopiaDao;
    protected ZoneTopiaDao zoneTopiaDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao;
    protected EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao;
    public static final String JAVA_IO_TMPDIR = System.getProperty("java.io.tmpdir") + "/";

    @Before
    public void setupServices() throws TopiaException {
        this.domainService = (DomainService)this.serviceFactory.newService(DomainService.class);
        this.referentialService = (ReferentialService)this.serviceFactory.newService(ReferentialService.class);
        this.importService = (ImportService)this.serviceFactory.newService(ImportService.class);
        this.plotService = (PlotService)this.serviceFactory.newService(PlotService.class);
        this.edaplosService = (EdaplosService)this.serviceFactory.newService(EdaplosService.class);
        this.loginAsAdmin();
        this.domainTopiaDao = this.getPersistenceContext().getDomainDao();
        this.croppingPlanEntryTopiaDao = this.getPersistenceContext().getCroppingPlanEntryDao();
        this.effectiveCropCycleNodeTopiaDao = this.getPersistenceContext().getEffectiveCropCycleNodeDao();
        this.effectiveCropCycleConnectionTopiaDao = this.getPersistenceContext().getEffectiveCropCycleConnectionDao();
        this.effectivePerennialCropCycleTopiaDao = this.getPersistenceContext().getEffectivePerennialCropCycleDao();
        this.zoneTopiaDao = this.getPersistenceContext().getZoneDao();
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.testDatas.createTestNetworks();
        this.testDatas.importStadesEDI();
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importEspeces();
        this.testDatas.importFertiMinUnifa();
    }

    @Test
    public void getAllDomainByDomainService() {
        List domains = this.domainService.getAllDomains();
        Assert.assertTrue((domains.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getFilterDomains() {
        ResultList result = this.domainService.getFilteredDomains(null);
        Assert.assertEquals((long)7L, (long)result.getPager().getRecords());
        DomainFilter domainFilter = new DomainFilter();
        result = this.domainService.getFilteredDomains(domainFilter);
        Assert.assertEquals((long)7L, (long)result.getPager().getRecords());
        domainFilter.setDomainName("Le clos");
        result = this.domainService.getFilteredDomains(domainFilter);
        Assert.assertEquals((long)1L, (long)result.getPager().getRecords());
        domainFilter.setDomainName("\u00e9");
        result = this.domainService.getFilteredDomains(domainFilter);
        Assert.assertEquals((long)6L, (long)result.getPager().getRecords());
        domainFilter.setDomainName(null);
        NavigationContext context = new NavigationContext();
        domainFilter.setNavigationContext(context);
        context.setCampaigns((Set)Sets.newHashSet((Object[])new Integer[]{2015}));
        result = this.domainService.getFilteredDomains(domainFilter);
        Assert.assertEquals((long)1L, (long)result.getPager().getRecords());
        context.setCampaigns((Set)Sets.newHashSet((Object[])new Integer[]{2014}));
        result = this.domainService.getFilteredDomains(domainFilter);
        Assert.assertEquals((long)5L, (long)result.getPager().getRecords());
        context.setCampaigns((Set)Sets.newHashSet((Object[])new Integer[]{2013}));
        result = this.domainService.getFilteredDomains(domainFilter);
        Assert.assertEquals((long)1L, (long)result.getPager().getRecords());
        context.setCampaigns(null);
        Domain testDomain = (Domain)result.getElements().get(0);
        HashSet<String> domains = new HashSet<String>();
        domains.add(testDomain.getTopiaId());
        context.setDomains(domains);
        result = this.domainService.getFilteredDomains(domainFilter);
        Assert.assertEquals((long)1L, (long)result.getPager().getRecords());
    }

    @Test
    public void testExtendDomains() throws Exception {
        DomainTopiaDao domainTopiaDao = this.getPersistenceContext().getDomainDao();
        GrowingPlanTopiaDao growingPlanTopiaDao = this.getPersistenceContext().getGrowingPlanDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = this.getPersistenceContext().getGrowingSystemDao();
        NetworkTopiaDao networkTopiaDao = this.getPersistenceContext().getNetworkDao();
        String gsWithNetworks = "Systeme de culture Baulon 1";
        List originalGS = growingSystemTopiaDao.forNameEquals(gsWithNetworks).findAll();
        Assert.assertEquals((long)1L, (long)originalGS.size());
        Assert.assertEquals((long)2L, (long)((GrowingSystem)originalGS.get(0)).getNetworks().size());
        Assert.assertEquals((long)7L, (long)domainTopiaDao.count());
        Assert.assertEquals((long)5L, (long)growingPlanTopiaDao.count());
        Assert.assertEquals((long)7L, (long)growingSystemTopiaDao.count());
        Assert.assertEquals((long)6L, (long)networkTopiaDao.count());
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("Baulon");
        domainFilter.setCampaign(Integer.valueOf(2013));
        List domains2013 = this.domainService.getFilteredDomains(domainFilter).getElements();
        Assert.assertEquals((long)1L, (long)domains2013.size());
        Domain firstDomain = (Domain)domains2013.get(0);
        Assert.assertEquals((long)1L, (long)this.domainService.getRelatedDomains(firstDomain.getCode()).size());
        Assert.assertTrue((boolean)firstDomain.isActive());
        Domain extendedDomain = this.domainService.extendDomain(firstDomain.getTopiaId(), 2016);
        Assert.assertTrue((boolean)extendedDomain.isActive());
        Assert.assertEquals((long)8L, (long)domainTopiaDao.count());
        Assert.assertEquals((long)6L, (long)growingPlanTopiaDao.count());
        Assert.assertEquals((long)9L, (long)growingSystemTopiaDao.count());
        Assert.assertEquals((long)2L, (long)this.domainService.getRelatedDomains(firstDomain.getCode()).size());
        Assert.assertEquals((long)6L, (long)networkTopiaDao.count());
        GrowingPlanService growingPlanService = (GrowingPlanService)this.serviceFactory.newService(GrowingPlanService.class);
        List extendedGrowingPlans = growingPlanService.findAllByDomain(extendedDomain);
        Assert.assertEquals((long)1L, (long)extendedGrowingPlans.size());
        GrowingPlan extendedGP = (GrowingPlan)extendedGrowingPlans.get(0);
        LinkedHashMap relatedGPs = growingPlanService.getRelatedGrowingPlans(extendedGP.getCode());
        Assert.assertNotNull((Object)relatedGPs);
        Assert.assertEquals((long)2L, (long)relatedGPs.size());
        GrowingSystemService growingSystemService = (GrowingSystemService)this.serviceFactory.newService(GrowingSystemService.class);
        List allGrowingSystems = growingSystemService.findAllByGrowingPlan(extendedGP);
        Assert.assertNotNull((Object)allGrowingSystems);
        Assert.assertEquals((long)2L, (long)allGrowingSystems.size());
        GrowingSystem firstGs = (GrowingSystem)allGrowingSystems.get(0);
        LinkedHashMap extendedGrowingSystems = growingSystemService.getRelatedGrowingSystems(firstGs.getCode());
        Assert.assertNotNull((Object)extendedGrowingSystems);
        Assert.assertEquals((long)2L, (long)extendedGrowingSystems.size());
        List duplicatedGrowingSystems = growingSystemTopiaDao.findAllByName(gsWithNetworks);
        Assert.assertEquals((long)2L, (long)duplicatedGrowingSystems.size());
        for (GrowingSystem duplicatedGrowingSystem : duplicatedGrowingSystems) {
            Assert.assertEquals((long)2L, (long)duplicatedGrowingSystem.getNetworks().size());
        }
        Assert.assertEquals((long)2L, (long)extendedDomain.getWeatherStations().size());
        Assert.assertTrue((boolean)extendedDomain.getWeatherStations().contains(extendedDomain.getDefaultWeatherStation()));
    }

    @Test(expected=DomainExtendException.class)
    public void testExtendDomainsFail() throws Exception {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("La Bouineli\u00e8re");
        domainFilter.setCampaign(Integer.valueOf(2014));
        List domains = this.domainService.getFilteredDomains(domainFilter).getElements();
        Assert.assertEquals((long)1L, (long)domains.size());
        Domain firstDomain = (Domain)domains.get(0);
        this.domainService.extendDomain(firstDomain.getTopiaId(), 2014);
    }

    @Test
    public void testRelatedDomains() throws DomainExtendException {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("La Bouineli\u00e8re");
        domainFilter.setCampaign(Integer.valueOf(2014));
        List domains = this.domainService.getFilteredDomains(domainFilter).getElements();
        Domain firstDomain = (Domain)domains.get(0);
        this.domainService.extendDomain(firstDomain.getTopiaId(), 2015);
        this.domainService.extendDomain(firstDomain.getTopiaId(), 2016);
        LinkedHashMap relatedDomains = this.domainService.getRelatedDomains(firstDomain.getCode());
        Assert.assertEquals((long)3L, (long)relatedDomains.size());
        Assert.assertTrue((boolean)relatedDomains.containsValue(firstDomain.getTopiaId()));
    }

    @Test
    public void testCheckDomainExistence() {
        Assert.assertTrue((boolean)this.domainService.checkDomainExistence("Le clos Gautier"));
        Assert.assertTrue((boolean)this.domainService.checkDomainExistence("le clos gautier"));
        Assert.assertTrue((boolean)this.domainService.checkDomainExistence("Le clos gAutier"));
        Assert.assertFalse((boolean)this.domainService.checkDomainExistence("Le clos Gatier"));
        Assert.assertFalse((boolean)this.domainService.checkDomainExistence("Le clos gatier"));
    }

    @Test
    public void testRemoveCroppingPlanEntry() {
        this.testDatas.importEspeces();
        Domain domain = (Domain)this.domainService.getAllDomains().get(0);
        ArrayList croppingPlan = Lists.newArrayList();
        CroppingPlanEntryDto croppingPlanEntryDto = new CroppingPlanEntryDto();
        croppingPlanEntryDto.setName("Azerty");
        croppingPlanEntryDto.setType(CroppingEntryType.MAIN);
        croppingPlan.add(croppingPlanEntryDto);
        ArrayList species = Lists.newArrayList();
        croppingPlanEntryDto.setSpecies((Collection)species);
        CroppingPlanSpeciesDto croppingPlanSpeciesDto = new CroppingPlanSpeciesDto();
        RefEspece espece = (RefEspece)this.referentialService.findSpecies("g").get(0);
        String expectedName = espece.getLibelle_espece_botanique();
        croppingPlanSpeciesDto.setSpeciesId(espece.getTopiaId());
        species.add(croppingPlanSpeciesDto);
        domain = this.domainService.createOrUpdateDomain(domain, domain.getLocation().getTopiaId(), null, null, (List)croppingPlan, null, null, null, null, null, null);
        UsageList croppingPlanEntryDtoAndUsage = this.domainService.getCroppingPlanEntryDtoAndUsage(domain.getTopiaId());
        List croppingPlan2 = croppingPlanEntryDtoAndUsage.getElements();
        Assert.assertEquals((long)1L, (long)croppingPlan2.size());
        CroppingPlanEntryDto croppingPlanEntry = (CroppingPlanEntryDto)croppingPlan2.get(0);
        Assert.assertEquals((Object)"Azerty", (Object)croppingPlanEntry.getName());
        Collection croppingPlanSpeciesList = croppingPlanEntry.getSpecies();
        Assert.assertEquals((long)1L, (long)croppingPlanSpeciesList.size());
        CroppingPlanSpeciesDto croppingPlanSpecies = (CroppingPlanSpeciesDto)croppingPlanSpeciesList.iterator().next();
        Assert.assertEquals((Object)expectedName, (Object)croppingPlanSpecies.getSpeciesEspece());
        ArrayList emptyCroppingPlan = Lists.newArrayList();
        this.domainService.createOrUpdateDomain(domain, domain.getLocation().getTopiaId(), null, null, (List)emptyCroppingPlan, null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXls() throws IOException {
        DomainFilter domainFilter = new DomainFilter();
        List domains = this.domainService.getFilteredDomains(domainFilter).getElements();
        List domainIds = Lists.transform((List)domains, (Function)Entities.GET_TOPIA_ID);
        InputStream is = null;
        try {
            FileUtil.createDirectoryIfNecessary((File)new File(JAVA_IO_TMPDIR));
            File file = new File(JAVA_IO_TMPDIR + "export.xls");
            is = this.domainService.exportDomainAsXlsStream(domainIds);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
            log.info((Object)("fr.inra.agrosyst.services.domain.DomainServiceTest.testExportXls output: " + file.getAbsolutePath()));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportXlsEmpty() throws IOException {
        InputStream is = null;
        try {
            is = this.domainService.exportDomainAsXlsStream(null);
            Assert.assertTrue((is.available() > 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportXls() throws IOException {
        DomainFilter domainFilter = new DomainFilter();
        List domains = this.domainService.getFilteredDomains(domainFilter).getElements();
        List domainIds = Lists.transform((List)domains, (Function)Entities.GET_TOPIA_ID);
        InputStream is = null;
        try {
            is = this.domainService.exportDomainAsXlsStream(domainIds);
            this.domainService.importDomainForXlsStream(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    @Test
    public void testMultipleAccentInDomainName() {
        this.testDatas.importCommunesOsm();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain d1 = this.domainService.newDomain();
        d1.setCampaign(2014);
        d1.setName("L'Inra a \u00e9t\u00e9 fond\u00e9 en 1946. Il contribuer \u00e0 l'expertise, \u00e0 la formation, \u00e0 la promotion de la culture scientifique et technique, au d\u00e9bat science/soci\u00e9t\u00e9");
        d1.setMainContact("test");
        d1.setType(DomainType.DOMAINE_EXPERIMENTAL);
        this.domainService.createOrUpdateDomain(d1, location.getTopiaId(), null, null, null, null, null, null, null, null, null);
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("fonde");
        Assert.assertEquals((long)1L, (long)this.domainService.getFilteredDomains(domainFilter).getPager().getRecords());
        domainFilter.setDomainName("a la p");
        Assert.assertEquals((long)1L, (long)this.domainService.getFilteredDomains(domainFilter).getPager().getRecords());
    }

    @Test
    public void testValidate() throws Exception {
        this.testDatas.importEspeces();
        Domain domain = (Domain)this.domainService.getAllDomains().iterator().next();
        Assert.assertFalse((boolean)domain.isValidated());
        Assert.assertNull((Object)domain.getValidationDate());
        Assert.assertNotNull((Object)domain.getUpdateDate());
        String domainId = domain.getTopiaId();
        ArrayList list = Lists.newArrayList();
        CroppingPlanEntryDto dto = new CroppingPlanEntryDto();
        dto.setName("azerty");
        dto.setType(CroppingEntryType.MAIN);
        list.add(dto);
        CroppingPlanSpeciesDto speciesDto = new CroppingPlanSpeciesDto();
        RefEspece espece = (RefEspece)this.referentialService.findSpecies("g").get(0);
        speciesDto.setSpeciesId(espece.getTopiaId());
        ArrayList speciesList = Lists.newArrayList((Object[])new CroppingPlanSpeciesDto[]{speciesDto});
        dto.setSpecies((Collection)speciesList);
        this.domainService.createOrUpdateDomain(domain, domain.getLocation().getTopiaId(), null, null, (List)list, null, null, null, null, null, null);
        domain = this.domainService.validateAndCommit(domainId);
        Assert.assertTrue((boolean)domain.isValidated());
        Assert.assertNotNull((Object)domain.getValidationDate());
        Assert.assertEquals((Object)domain.getUpdateDate(), (Object)domain.getValidationDate());
        UsageList croppingPlanEntryDtoAndUsage = this.domainService.getCroppingPlanEntryDtoAndUsage(domain.getTopiaId());
        List croppingPlan = croppingPlanEntryDtoAndUsage.getElements();
        for (CroppingPlanEntryDto croppingPlanEntryDto : croppingPlan) {
            Assert.assertTrue((boolean)croppingPlanEntryDto.isValidated());
            for (CroppingPlanSpeciesDto croppingPlanSpeciesDto : croppingPlanEntryDto.getSpecies()) {
                Assert.assertTrue((boolean)croppingPlanSpeciesDto.isValidated());
            }
        }
    }

    @Test
    public void testMaterielAndToolsCouplingDeletion() {
        this.testDatas.importMateriels();
        this.testDatas.importInterventionAgrosystTravailEdi();
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("La Bouineli\u00e8re");
        domainFilter.setCampaign(Integer.valueOf(2014));
        List domains = this.domainService.getFilteredDomains(domainFilter).getElements();
        Domain firstDomain = (Domain)domains.get(0);
        EquipmentImpl mat = new EquipmentImpl();
        mat.setTopiaId("NEW-EQUIPMENT-1");
        mat.setCode(UUID.randomUUID().toString());
        mat.setName("Test");
        RefMateriel refMateriel = this.getTractorVigne();
        mat.setRefMateriel(refMateriel);
        EquipmentImpl matBroy = new EquipmentImpl();
        matBroy.setTopiaId("NEW-EQUIPMENT-2");
        matBroy.setCode(UUID.randomUUID().toString());
        matBroy.setName("Broyeur");
        RefMateriel refMaterielBroy = this.getBroyeur();
        matBroy.setRefMateriel(refMaterielBroy);
        RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        List refInterventionAgrosystTravailEDIs = refActionAgrosystTravailEDITopiaDao.findAll();
        ArrayList mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{(RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(0), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(1), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(2)});
        ToolsCouplingImpl attelage = new ToolsCouplingImpl();
        attelage.setCode(UUID.randomUUID().toString());
        attelage.setToolsCouplingName("Test");
        attelage.setMainsActions((Collection)mainsActions);
        EquipmentImpl tractor = new EquipmentImpl();
        tractor.setName("tractor");
        tractor.setTopiaId("NEW-EQUIPMENT-1");
        attelage.setTractor((Equipment)tractor);
        EquipmentImpl coupling = new EquipmentImpl();
        coupling.setName("coupling");
        coupling.setTopiaId("NEW-EQUIPMENT-2");
        attelage.addEquipments((Equipment)coupling);
        ArrayList materiels = Lists.newArrayList((Object[])new Equipment[]{mat, matBroy});
        firstDomain = this.domainService.createOrUpdateDomain(firstDomain, firstDomain.getLocation().getTopiaId(), null, null, null, null, null, null, (List)materiels, Collections.singletonList(attelage), null);
        this.domainService.createOrUpdateDomain(firstDomain, firstDomain.getLocation().getTopiaId(), null, null, null, null, null, null, new ArrayList(), new ArrayList(), null);
    }

    @Test(expected=RuntimeException.class)
    public void testMaterielAndToolsCouplingNotValidToolsCoupling() {
        this.testDatas.importMateriels();
        this.testDatas.importInterventionAgrosystTravailEdi();
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("La Bouineli\u00e8re");
        domainFilter.setCampaign(Integer.valueOf(2014));
        List domains = this.domainService.getFilteredDomains(domainFilter).getElements();
        Domain firstDomain = (Domain)domains.get(0);
        EquipmentImpl mat = new EquipmentImpl();
        mat.setTopiaId("NEW-EQUIPMENT-1");
        mat.setCode(UUID.randomUUID().toString());
        mat.setName("Test");
        RefMateriel refMateriel = this.getTractorVigne();
        mat.setRefMateriel(refMateriel);
        RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        List refInterventionAgrosystTravailEDIs = refActionAgrosystTravailEDITopiaDao.findAll();
        ArrayList mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{(RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(0), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(1), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(2)});
        ToolsCouplingImpl attelage = new ToolsCouplingImpl();
        attelage.setCode(UUID.randomUUID().toString());
        attelage.setToolsCouplingName("Test");
        attelage.setMainsActions((Collection)mainsActions);
        EquipmentImpl tractor = new EquipmentImpl();
        tractor.setTopiaId("NEW-EQUIPMENT-1");
        attelage.setTractor((Equipment)tractor);
        this.domainService.createOrUpdateDomain(firstDomain, firstDomain.getLocation().getTopiaId(), null, null, null, null, null, null, Collections.singletonList(mat), Collections.singletonList(attelage), null);
    }

    @Test
    public void testAutomoteurMaterielAndToolsCouplingDeletion() {
        this.testDatas.importMateriels();
        this.testDatas.importInterventionAgrosystTravailEdi();
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setDomainName("La Bouineli\u00e8re");
        domainFilter.setCampaign(Integer.valueOf(2014));
        List domains = this.domainService.getFilteredDomains(domainFilter).getElements();
        Domain firstDomain = (Domain)domains.get(0);
        EquipmentImpl automoteur = new EquipmentImpl();
        automoteur.setTopiaId("NEW-EQUIPMENT-1");
        automoteur.setCode(UUID.randomUUID().toString());
        automoteur.setName("Automoteur");
        RefMateriel refMateriel = this.getAutomoteur();
        automoteur.setRefMateriel(refMateriel);
        EquipmentImpl matEquipment2 = new EquipmentImpl();
        matEquipment2.setTopiaId("NEW-EQUIPMENT-2");
        matEquipment2.setCode(UUID.randomUUID().toString());
        matEquipment2.setName("Equipement 1");
        RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        List refInterventionAgrosystTravailEDIs = refActionAgrosystTravailEDITopiaDao.findAll();
        ArrayList mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{(RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(0), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(1), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(2)});
        ToolsCouplingImpl attelage = new ToolsCouplingImpl();
        attelage.setCode(UUID.randomUUID().toString());
        attelage.setToolsCouplingName("Test");
        attelage.setMainsActions((Collection)mainsActions);
        EquipmentImpl tractor = new EquipmentImpl();
        tractor.setName("Tractor");
        tractor.setTopiaId("NEW-EQUIPMENT-1");
        attelage.setTractor((Equipment)tractor);
        EquipmentImpl equipment1 = new EquipmentImpl();
        equipment1.setName("equipment1");
        equipment1.setTopiaId("NEW-EQUIPMENT-2");
        attelage.addEquipments((Equipment)equipment1);
        firstDomain = this.domainService.createOrUpdateDomain(firstDomain, firstDomain.getLocation().getTopiaId(), null, null, null, null, null, null, (List)Lists.newArrayList((Object[])new Equipment[]{automoteur, matEquipment2}), Collections.singletonList(attelage), null);
        this.domainService.createOrUpdateDomain(firstDomain, firstDomain.getLocation().getTopiaId(), null, null, null, null, null, null, new ArrayList(), new ArrayList(), null);
    }

    @Test
    public void testAffectedCroppingPlan() {
        this.testDatas.importCommunesOsm();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain d1 = this.domainService.newDomain();
        d1.setCampaign(2014);
        d1.setName("Test CroppingPlan");
        d1.setMainContact("test");
        d1.setType(DomainType.DOMAINE_EXPERIMENTAL);
        ArrayList croppingPlanEntries = Lists.newArrayList((Object[])new CroppingPlanEntryDto[]{this.createCroppingPlanEntry("CP1", CroppingEntryType.MAIN), this.createCroppingPlanEntry("CPi", CroppingEntryType.INTERMEDIATE)});
        Domain domain = this.domainService.createOrUpdateDomain(d1, location.getTopiaId(), null, null, (List)croppingPlanEntries, null, null, null, null, null, null);
        UsageList croppingPlanEntryDtoAndUsage = this.domainService.getCroppingPlanEntryDtoAndUsage(domain.getTopiaId());
        List croppingPlanEntryDtos = croppingPlanEntryDtoAndUsage.getElements();
        Map areAffectedCPEs = croppingPlanEntryDtoAndUsage.getUsageMap();
        Assert.assertEquals((long)2L, (long)croppingPlanEntryDtos.size());
        Assert.assertFalse((boolean)((Boolean)areAffectedCPEs.get(((CroppingPlanEntryDto)croppingPlanEntryDtos.get(0)).getTopiaId())));
        Assert.assertFalse((boolean)((Boolean)areAffectedCPEs.get(((CroppingPlanEntryDto)croppingPlanEntryDtos.get(1)).getTopiaId())));
        croppingPlanEntryDtos = Lists.newArrayList((Iterable)croppingPlanEntryDtoAndUsage.getElements());
        int nbNewCP = 6;
        for (int i = 2; i < nbNewCP; ++i) {
            croppingPlanEntryDtos.add(this.createCroppingPlanEntry("CP" + i, CroppingEntryType.MAIN));
        }
        domain = this.domainService.createOrUpdateDomain(domain, location.getTopiaId(), null, null, croppingPlanEntryDtos, null, null, null, null, null, null);
        croppingPlanEntryDtoAndUsage = this.domainService.getCroppingPlanEntryDtoAndUsage(domain.getTopiaId());
        croppingPlanEntryDtos = croppingPlanEntryDtoAndUsage.getElements();
        areAffectedCPEs = croppingPlanEntryDtoAndUsage.getUsageMap();
        Assert.assertEquals((long)nbNewCP, (long)croppingPlanEntryDtos.size());
        for (CroppingPlanEntryDto croppingPlanEntryDto : croppingPlanEntries) {
            Assert.assertNull(areAffectedCPEs.get(croppingPlanEntryDto.getTopiaId()));
        }
        this.testDatas.importInterventionAgrosystTravailEdi();
        this.testDatas.importActaTraitementsProduits();
        GrowingPlan growingPlan = this.testDatas.createGrowingPlan(domain);
        GrowingSystem gs = this.testDatas.createGrowingSystem(growingPlan);
        ArrayList affectedCPs = Lists.newArrayList((Object[])new CroppingPlanEntryDto[]{(CroppingPlanEntryDto)croppingPlanEntryDtos.get(0), (CroppingPlanEntryDto)croppingPlanEntryDtos.get(1)});
        String affectedCPId = ((CroppingPlanEntryDto)affectedCPs.get(0)).getTopiaId();
        String affectedCPId2 = ((CroppingPlanEntryDto)affectedCPs.get(1)).getTopiaId();
        PracticedSystem ps = this.testDatas.createPracticedSystem(gs, affectedCPs);
        ArrayList newCroppingPlanEntries = Lists.newArrayListWithCapacity((int)affectedCPs.size());
        for (CroppingPlanEntryDto croppingPlanEntryDto : affectedCPs) {
            newCroppingPlanEntries.add(this.croppingPlanEntryTopiaDao.forTopiaIdEquals(croppingPlanEntryDto.getTopiaId()).findUnique());
        }
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(newCroppingPlanEntries, ps);
        croppingPlanEntryDtoAndUsage = this.domainService.getCroppingPlanEntryDtoAndUsage(domain.getTopiaId());
        List cpes = croppingPlanEntryDtoAndUsage.getElements();
        areAffectedCPEs = croppingPlanEntryDtoAndUsage.getUsageMap();
        Assert.assertEquals((long)nbNewCP, (long)cpes.size());
        for (CroppingPlanEntryDto croppingPlanEntryDto : cpes) {
            if (croppingPlanEntryDto.getTopiaId().equals(affectedCPId) || croppingPlanEntryDto.getTopiaId().equals(affectedCPId2)) {
                Assert.assertTrue((boolean)((Boolean)areAffectedCPEs.get(croppingPlanEntryDto.getTopiaId())));
                continue;
            }
            Assert.assertFalse((boolean)((Boolean)areAffectedCPEs.get(croppingPlanEntryDto.getTopiaId())));
        }
    }

    @Test
    public void testAffectedCroppingSpecies() {
        this.testDatas.createTestPraticedSystems();
        PracticedSystem psBaulon2013 = this.testDatas.createTestPraticedSystems();
        List<CroppingPlanEntry> croppingPlanEntries = this.testDatas.findCroppingPlanEntries(psBaulon2013.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId());
        this.testDatas.createTestPracticedSystemPerennailAndSeasonnalCycle(croppingPlanEntries, psBaulon2013);
        Domain domain = (Domain)this.domainTopiaDao.forProperties("name", (Object)"Baulon", new Object[]{"campaign", 2013}).findAnyOrNull();
        Map cpSpeciesUsages = this.domainService.getCroppingPlanSpeciesUsage(domain.getTopiaId());
        Assert.assertEquals((long)4L, (long)cpSpeciesUsages.size());
    }

    protected CroppingPlanEntryDto createCroppingPlanEntry(String name, CroppingEntryType type) {
        CroppingPlanEntryDto croppingPlanEntryDto = new CroppingPlanEntryDto();
        croppingPlanEntryDto.setName(name);
        croppingPlanEntryDto.setType(type);
        return croppingPlanEntryDto;
    }

    @Test
    public void testToolsCouplingAffected() {
        this.testDatas.importCommunesOsm();
        this.testDatas.importMateriels();
        this.testDatas.importInterventionAgrosystTravailEdi();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain d1 = this.domainService.newDomain();
        d1.setCampaign(2014);
        d1.setName("Test toolsCouplingAffected");
        d1.setMainContact("test");
        d1.setType(DomainType.DOMAINE_EXPERIMENTAL);
        EquipmentImpl mat = new EquipmentImpl();
        mat.setTopiaId("NEW-EQUIPMENT-1");
        mat.setCode(UUID.randomUUID().toString());
        mat.setName("Test");
        RefMateriel refMateriel = this.getTractorVigne();
        mat.setRefMateriel(refMateriel);
        EquipmentImpl matBroy = new EquipmentImpl();
        matBroy.setTopiaId("NEW-EQUIPMENT-2");
        matBroy.setCode(UUID.randomUUID().toString());
        matBroy.setName("Broyeur");
        RefMateriel refMaterielBroy = this.getBroyeur();
        matBroy.setRefMateriel(refMaterielBroy);
        RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        List refInterventionAgrosystTravailEDIs = refActionAgrosystTravailEDITopiaDao.findAll();
        ArrayList mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{(RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(0), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(1), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(2)});
        ToolsCouplingImpl attelage = new ToolsCouplingImpl();
        attelage.setCode(UUID.randomUUID().toString());
        attelage.setToolsCouplingName("Test");
        attelage.setMainsActions((Collection)mainsActions);
        EquipmentImpl tractor = new EquipmentImpl();
        tractor.setName("tractor");
        tractor.setTopiaId("NEW-EQUIPMENT-1");
        attelage.setTractor((Equipment)tractor);
        EquipmentImpl coupling = new EquipmentImpl();
        coupling.setName("coupling");
        coupling.setTopiaId("NEW-EQUIPMENT-2");
        attelage.addEquipments((Equipment)coupling);
        ArrayList materiels = Lists.newArrayList((Object[])new Equipment[]{mat, matBroy});
        Domain domain = this.domainService.createOrUpdateDomain(d1, location.getTopiaId(), null, null, null, null, null, null, (List)materiels, Collections.singletonList(attelage), null);
        UsageList usageList = this.domainService.getToolsCouplingAndUsage(domain.getTopiaId());
        Assert.assertTrue((usageList.getUsageMap().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testToolsCouplingCopy() {
        this.testDatas.importCommunesOsm();
        this.testDatas.importMateriels();
        this.testDatas.importInterventionAgrosystTravailEdi();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain fromDomain = this.domainService.newDomain();
        fromDomain.setName("Test toolsCouplingCopy source");
        fromDomain.setMainContact("test");
        fromDomain.setType(DomainType.DOMAINE_EXPERIMENTAL);
        fromDomain.setCampaign(2014);
        Domain toDomain = this.domainService.newDomain();
        toDomain.setName("Test toolsCouplingCopy target");
        toDomain.setMainContact("test");
        toDomain.setType(DomainType.DOMAINE_EXPERIMENTAL);
        toDomain.setCampaign(2015);
        EquipmentImpl mat = new EquipmentImpl();
        mat.setTopiaId("NEW-EQUIPMENT-1");
        mat.setCode(UUID.randomUUID().toString());
        mat.setName("Test");
        RefMateriel refMateriel = this.getTractorVigne();
        mat.setRefMateriel(refMateriel);
        EquipmentImpl matBroy = new EquipmentImpl();
        matBroy.setTopiaId("NEW-EQUIPMENT-2");
        matBroy.setCode(UUID.randomUUID().toString());
        matBroy.setName("Broyeur");
        RefMateriel refMaterielBroy = this.getBroyeur();
        matBroy.setRefMateriel(refMaterielBroy);
        RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        List refInterventionAgrosystTravailEDIs = refActionAgrosystTravailEDITopiaDao.findAll();
        ArrayList mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{(RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(0), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(1), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(2)});
        ToolsCouplingImpl attelage = new ToolsCouplingImpl();
        attelage.setCode(UUID.randomUUID().toString());
        attelage.setToolsCouplingName("Test");
        attelage.setMainsActions((Collection)mainsActions);
        EquipmentImpl tractor = new EquipmentImpl();
        tractor.setName("tractor");
        tractor.setTopiaId("NEW-EQUIPMENT-1");
        attelage.setTractor((Equipment)tractor);
        EquipmentImpl coupling = new EquipmentImpl();
        coupling.setName("coupling");
        coupling.setTopiaId("NEW-EQUIPMENT-2");
        attelage.addEquipments((Equipment)coupling);
        ArrayList materiels = Lists.newArrayList((Object[])new Equipment[]{mat, matBroy});
        Domain source = this.domainService.createOrUpdateDomain(fromDomain, location.getTopiaId(), null, null, null, null, null, null, (List)materiels, Collections.singletonList(attelage), null);
        Domain target = this.domainService.createOrUpdateDomain(toDomain, location.getTopiaId(), null, null, null, null, null, null, null, null, null);
        List equipments = this.domainService.getEquipments(source.getTopiaId());
        List toolsCouplingSource = this.domainService.getToolsCouplings(source.getTopiaId());
        this.domainService.copyTools(source.getTopiaId(), (List)Lists.newArrayList((Object[])new String[]{target.getTopiaId()}), Boolean.valueOf(false), equipments, null);
        this.domainService.copyTools(source.getTopiaId(), (List)Lists.newArrayList((Object[])new String[]{target.getTopiaId()}), Boolean.valueOf(true), equipments, (List)Lists.newArrayList((Iterable)toolsCouplingSource));
        toolsCouplingSource = this.domainService.getToolsCouplings(target.getTopiaId());
        Assert.assertEquals((long)1L, (long)toolsCouplingSource.size());
        Equipment copiedTractor = ((ToolsCoupling)toolsCouplingSource.get(0)).getTractor();
        Assert.assertNotNull((Object)copiedTractor);
        Domain relatedDomain = (Domain)this.domainTopiaDao.create("topiaId", (Object)"TAGETED_DOMAIN_ID", new Object[]{"name", "TAGETED_DOMAIN", "code", source.getCode(), "campaign", source.getCampaign() + 1, "location", location, "mainContact", "INRA", "type", DomainType.DOMAINE_EXPERIMENTAL, "updateDate", new Date()});
        equipments = this.domainService.getEquipments(source.getTopiaId());
        toolsCouplingSource = this.domainService.getToolsCouplings(source.getTopiaId());
        ArrayList codes = Lists.newArrayList();
        for (Equipment equipment : equipments) {
            codes.add(equipment.getCode());
        }
        this.domainService.copyTools(source.getTopiaId(), (List)Lists.newArrayList((Object[])new String[]{relatedDomain.getTopiaId()}), Boolean.valueOf(false), equipments, null);
        List targetedEquipement = this.domainService.getEquipments(relatedDomain.getTopiaId());
        Assert.assertEquals((long)2L, (long)targetedEquipement.size());
        this.domainService.copyTools(source.getTopiaId(), (List)Lists.newArrayList((Object[])new String[]{relatedDomain.getTopiaId()}), Boolean.valueOf(true), equipments, (List)Lists.newArrayList((Iterable)toolsCouplingSource));
        targetedEquipement = this.domainService.getEquipments(relatedDomain.getTopiaId());
        Assert.assertEquals((long)2L, (long)targetedEquipement.size());
        List toolsCouplingTarget = this.domainService.getToolsCouplings(relatedDomain.getTopiaId());
        Assert.assertEquals((long)1L, (long)toolsCouplingTarget.size());
        Assert.assertNotNull((Object)((ToolsCoupling)toolsCouplingTarget.get(0)).getTractor());
        Assert.assertTrue((boolean)codes.contains(((ToolsCoupling)toolsCouplingTarget.get(0)).getTractor().getCode()));
    }

    @Test
    public void testToolsCouplingCreation() {
        this.testDatas.importCommunesOsm();
        this.testDatas.importMateriels();
        this.testDatas.importInterventionAgrosystTravailEdi();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain d1 = this.domainService.newDomain();
        d1.setCampaign(2014);
        d1.setName("Test toolsCouplingAffected");
        d1.setMainContact("test");
        d1.setType(DomainType.DOMAINE_EXPERIMENTAL);
        EquipmentImpl mat = new EquipmentImpl();
        mat.setTopiaId("NEW-EQUIPMENT-1");
        mat.setCode(UUID.randomUUID().toString());
        mat.setName("Test");
        RefMateriel refMateriel = this.getTractorVigne();
        mat.setRefMateriel(refMateriel);
        RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        List refInterventionAgrosystTravailEDIs = refActionAgrosystTravailEDITopiaDao.findAll();
        ArrayList mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{(RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(0), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(1), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(2)});
        ToolsCouplingImpl attelage = new ToolsCouplingImpl();
        attelage.setCode(UUID.randomUUID().toString());
        attelage.setToolsCouplingName("Test");
        attelage.setMainsActions((Collection)mainsActions);
        EquipmentImpl tractor = new EquipmentImpl();
        tractor.setTopiaId("NEW-EQUIPMENT-1");
        attelage.setTractor((Equipment)tractor);
        ArrayList equipments = Lists.newArrayList((Object[])new Equipment[]{mat});
        attelage.setEquipments((Collection)equipments);
        Domain domain = this.domainService.createOrUpdateDomain(d1, location.getTopiaId(), null, null, null, null, null, null, Collections.singletonList(mat), Collections.singletonList(attelage), null);
        List toolsCouplings = this.domainService.getToolsCouplings(domain.getTopiaId());
        Assert.assertEquals((long)1L, (long)toolsCouplings.size());
        for (ToolsCoupling toolsCoupling : toolsCouplings) {
            Assert.assertFalse((boolean)toolsCoupling.getTopiaId().contains("NEW-EQUIPMENT-"));
            Collection tcEquipments = toolsCoupling.getEquipments();
            Assert.assertEquals((long)1L, (long)tcEquipments.size());
            for (Equipment tcEquipment : tcEquipments) {
                Assert.assertFalse((boolean)tcEquipment.getTopiaId().contains("NEW-EQUIPMENT-"));
            }
        }
    }

    @Test
    @Ignore
    public void testImportEdaplos() {
        this.testDatas.importCommunesOsm();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain d1 = this.domainService.newDomain();
        d1.setName("Test eDaplos import");
        d1.setMainContact("eDaplos support team");
        d1.setSiret("77556351300016");
        d1.setType(DomainType.DOMAINE_EXPERIMENTAL);
        d1.setCampaign(2001);
        Domain domain = this.domainService.createOrUpdateDomain(d1, location.getTopiaId(), null, null, null, null, null, null, null, null, null);
        Plot p1 = this.plotService.getPlot(null);
        List plotZones = this.zoneTopiaDao.forPlotEquals(p1).findAll();
        p1.setName("Cimetierre/ 07 08");
        p1.setArea(14.79);
        p1.setMaxSlope(MaxSlope.ZERO_TO_TWO);
        p1.setWaterFlowDistance(WaterFlowDistance.FIVE_TO_TEN);
        p1.setBufferStrip(BufferStrip.NONE);
        Plot plot = this.plotService.createOrUpdatePlot(p1, domain.getTopiaId(), location.getTopiaId(), null, null, null, null, null, null, null, (Collection)plotZones, null);
        InputStream eDaplosStream = DomainServiceTest.class.getResourceAsStream("/edaplos/eDAPLOSV2.3_valid_exemple_inra_1.xml");
        List plots = this.plotService.findAllByDomain(domain);
        Assert.assertEquals((long)1L, (long)plots.size());
    }

    @Test
    @Ignore
    public void testImportEdaplosCreatePlot() {
        this.testDatas.importCommunesOsm();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain d1 = this.domainService.newDomain();
        d1.setName("Test eDaplos import");
        d1.setMainContact("eDaplos support team");
        d1.setSiret("77556351300016");
        d1.setType(DomainType.DOMAINE_EXPERIMENTAL);
        d1.setCampaign(2001);
        Domain domain = this.domainService.createOrUpdateDomain(d1, location.getTopiaId(), null, null, null, null, null, null, null, null, null);
        InputStream eDaplosStream = DomainServiceTest.class.getResourceAsStream("/edaplos/eDAPLOSV2.3_valid_exemple_inra_1.xml");
        List plots = this.plotService.findAllByDomain(domain);
        Assert.assertEquals((long)0L, (long)plots.size());
    }

    @Test
    public void testImportEdaplosCreateDomainAndPlot() {
        this.testDatas.importCommunesOsm();
        InputStream eDaplosStream = DomainServiceTest.class.getResourceAsStream("/edaplos/eDAPLOSV2.3_valid_exemple_inra_1.xml.zip");
        List results = this.edaplosService.validEdaplosData(eDaplosStream);
        this.edaplosService.importEdaplos(results);
        Domain domain = (Domain)this.domainTopiaDao.forProperties("siret", (Object)"77556351300016", new Object[]{"campaign", 2001}).findUniqueOrNull();
        Assert.assertEquals((Object)"EARL ISAGRI", (Object)domain.getName());
        List plots = this.plotService.findAllByDomain(domain);
        Assert.assertEquals((long)1L, (long)plots.size());
        List zones = this.zoneTopiaDao.forPlotEquals((Plot)plots.get(0)).findAll();
        Assert.assertEquals((long)1L, (long)plots.size());
    }

    @Test
    public void testImportEdaplosZipFolder() {
        this.testDatas.importCommunesOsm();
        this.testDatas.importCultureEdiGroupeCouvSol();
        InputStream eDaplosStream = DomainServiceTest.class.getResourceAsStream("/edaplos/eDAPLOSV2.3_valid_and_invalid.zip");
        List results = this.edaplosService.validEdaplosData(eDaplosStream);
        this.edaplosService.importEdaplos(results);
        Domain domain = (Domain)this.domainTopiaDao.forProperties("siret", (Object)"77556351300016", new Object[]{"campaign", 2001}).findUniqueOrNull();
        Assert.assertEquals((Object)"EARL ISAGRI", (Object)domain.getName());
        List croppingPlanEntries = this.croppingPlanEntryTopiaDao.forProperties("domain", (Object)domain, new Object[0]).findAll();
        Assert.assertEquals((long)3L, (long)croppingPlanEntries.size());
        List plots = this.plotService.findAllByDomain(domain);
        Assert.assertEquals((long)1L, (long)plots.size());
        List zones = this.zoneTopiaDao.forPlotEquals((Plot)plots.get(0)).findAll();
        Assert.assertEquals((long)1L, (long)zones.size());
        List effCropCycleNodes = this.effectiveCropCycleNodeTopiaDao.findAll();
        Assert.assertEquals((long)1L, (long)effCropCycleNodes.size());
        Assert.assertEquals((Object)"ID 2", (Object)((EffectiveCropCycleNode)effCropCycleNodes.get(0)).getEdaplosIssuerId());
        List effCycleConnections = this.effectiveCropCycleConnectionTopiaDao.findAll();
        Assert.assertEquals((long)1L, (long)effCycleConnections.size());
        Assert.assertEquals((Object)"ID_occ_sol_inter", (Object)((EffectiveCropCycleConnection)effCycleConnections.get(0)).getEdaplosIssuerId());
        List effPerennialCycles = this.effectivePerennialCropCycleTopiaDao.findAll();
        Assert.assertEquals((long)1L, (long)effPerennialCycles.size());
        Assert.assertEquals((Object)"ID_occ_sol_perenne", (Object)((EffectivePerennialCropCycle)effPerennialCycles.get(0)).getEdaplosIssuerId());
        eDaplosStream = DomainServiceTest.class.getResourceAsStream("/edaplos/eDAPLOSV2.3_valid_and_invalid.zip");
        results = this.edaplosService.validEdaplosData(eDaplosStream);
        this.edaplosService.importEdaplos(results);
        domain = (Domain)this.domainTopiaDao.forProperties("siret", (Object)"77556351300016", new Object[]{"campaign", 2001}).findUniqueOrNull();
        Assert.assertEquals((Object)"EARL ISAGRI", (Object)domain.getName());
        croppingPlanEntries = this.croppingPlanEntryTopiaDao.forProperties("domain", (Object)domain, new Object[0]).findAll();
        Assert.assertEquals((long)3L, (long)croppingPlanEntries.size());
        plots = this.plotService.findAllByDomain(domain);
        Assert.assertEquals((long)1L, (long)plots.size());
        zones = this.zoneTopiaDao.forPlotEquals((Plot)plots.get(0)).findAll();
        Assert.assertEquals((long)1L, (long)zones.size());
        effCropCycleNodes = this.effectiveCropCycleNodeTopiaDao.findAll();
        Assert.assertEquals((long)1L, (long)effCropCycleNodes.size());
        Assert.assertEquals((Object)"ID 2", (Object)((EffectiveCropCycleNode)effCropCycleNodes.get(0)).getEdaplosIssuerId());
        effCycleConnections = this.effectiveCropCycleConnectionTopiaDao.findAll();
        Assert.assertEquals((long)1L, (long)effCycleConnections.size());
        Assert.assertEquals((Object)"ID_occ_sol_inter", (Object)((EffectiveCropCycleConnection)effCycleConnections.get(0)).getEdaplosIssuerId());
        effPerennialCycles = this.effectivePerennialCropCycleTopiaDao.findAll();
        Assert.assertEquals((long)1L, (long)effPerennialCycles.size());
        Assert.assertEquals((Object)"ID_occ_sol_perenne", (Object)((EffectivePerennialCropCycle)effPerennialCycles.get(0)).getEdaplosIssuerId());
    }

    @Test
    public void testParseEdaplosFile() {
        this.testDatas.importCommunesOsm();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain d1 = this.domainService.newDomain();
        d1.setName("Test eDaplos import");
        d1.setMainContact("eDaplos support team");
        d1.setSiret("77556351300016");
        d1.setType(DomainType.DOMAINE_EXPERIMENTAL);
        d1.setCampaign(2001);
        Domain domain = this.domainService.createOrUpdateDomain(d1, location.getTopiaId(), null, null, null, null, null, null, null, null, null);
        InputStream eDaplosStream = DomainServiceTest.class.getResourceAsStream("/edaplos/eDAPLOSV2.3_valid_exemple_inra_1.xml.zip");
        List results = this.edaplosService.validEdaplosData(eDaplosStream);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)EdaplosParsingStatus.SUCCESS, (Object)((EdaplosParsingResult)results.get(0)).getEdaplosParsingStatus());
    }

    @Test
    public void testMainDomainPreconditions() {
        DomainImpl d = new DomainImpl();
        d.setType(DomainType.DOMAINE_EXPERIMENTAL);
        d.setCampaign(2014);
        d.setMainContact("MC");
        DomainServiceImplTest dst = new DomainServiceImplTest();
        dst.validDomainPreconditions((Domain)d, "LOC");
    }

    @Test
    public void testValidToolsCouplingDomainPreconditions() {
        this.testDatas.importMateriels();
        this.testDatas.importInterventionAgrosystTravailEdi();
        RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        List refInterventionAgrosystTravailEDIs = refActionAgrosystTravailEDITopiaDao.findAll();
        ArrayList mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{(RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(0), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(1), (RefInterventionAgrosystTravailEDI)refInterventionAgrosystTravailEDIs.get(2)});
        EquipmentImpl tractor = new EquipmentImpl();
        tractor.setName("Tracteur");
        tractor.setRefMateriel(this.getTractorVigne());
        EquipmentImpl tools0 = new EquipmentImpl();
        tools0.setName("Broyeur");
        tools0.setRefMateriel(this.getBroyeur());
        ToolsCouplingImpl tc0 = new ToolsCouplingImpl();
        tc0.setToolsCouplingName("OK 1");
        tc0.setTractor((Equipment)tractor);
        tc0.addEquipments((Equipment)tools0);
        tc0.setMainsActions((Collection)mainsActions);
        DomainServiceImplTest dst = new DomainServiceImplTest();
        Assert.assertTrue((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc0})));
        EquipmentImpl automotive = new EquipmentImpl();
        automotive.setName("Automoteur");
        automotive.setRefMateriel(this.getAutomoteur());
        ToolsCouplingImpl tc1 = new ToolsCouplingImpl();
        tc1.setToolsCouplingName("OK 2");
        tc1.setTractor((Equipment)automotive);
        tc1.setMainsActions((Collection)mainsActions);
        Assert.assertTrue((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc1})));
        ToolsCouplingImpl tc2 = new ToolsCouplingImpl();
        tc2.setToolsCouplingName("OK 3");
        tc2.setTractor((Equipment)automotive);
        tc2.addEquipments((Equipment)tools0);
        tc2.setMainsActions((Collection)mainsActions);
        Assert.assertTrue((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc2})));
        EquipmentImpl tools1 = new EquipmentImpl();
        tools1.setName("Sous soleuse 2 corps");
        tools1.setRefMateriel(this.getToolsSubsoilers());
        ToolsCouplingImpl tc3 = new ToolsCouplingImpl();
        tc3.setToolsCouplingName("OK 4");
        tc3.setTractor((Equipment)tractor);
        tc3.addEquipments((Equipment)tools0);
        tc3.addEquipments((Equipment)tools1);
        tc3.setMainsActions((Collection)mainsActions);
        Assert.assertTrue((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc3})));
        EquipmentImpl irrigReel = new EquipmentImpl();
        irrigReel.setName("enroul");
        irrigReel.setRefMateriel(this.getIrrigEnrouleur());
        EquipmentImpl irrigStation = new EquipmentImpl();
        irrigStation.setName("Station");
        irrigStation.setRefMateriel(this.getIrrigStation());
        ToolsCouplingImpl tc4 = new ToolsCouplingImpl();
        tc4.setToolsCouplingName("OK 4");
        tc4.setTractor((Equipment)tractor);
        tc4.addEquipments((Equipment)irrigReel);
        tc4.addEquipments((Equipment)irrigStation);
        tc4.setMainsActions((Collection)mainsActions);
        Assert.assertTrue((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc4})));
        ToolsCouplingImpl tc5 = new ToolsCouplingImpl();
        tc5.setToolsCouplingName("OK 5");
        tc5.setTractor((Equipment)automotive);
        tc5.addEquipments((Equipment)irrigReel);
        tc5.addEquipments((Equipment)irrigStation);
        tc5.setMainsActions((Collection)mainsActions);
        Assert.assertTrue((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc5})));
        ToolsCouplingImpl tc6 = new ToolsCouplingImpl();
        tc6.setToolsCouplingName("OK 6");
        tc6.addEquipments((Equipment)irrigReel);
        tc6.addEquipments((Equipment)irrigStation);
        tc6.setMainsActions((Collection)mainsActions);
        Assert.assertTrue((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc6})));
        ToolsCouplingImpl tc7 = new ToolsCouplingImpl();
        tc7.setToolsCouplingName("FAILED 1");
        tc7.addEquipments((Equipment)tools0);
        tc7.addEquipments((Equipment)irrigStation);
        tc7.setMainsActions((Collection)mainsActions);
        Assert.assertFalse((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc7})));
        ToolsCouplingImpl tc8 = new ToolsCouplingImpl();
        tc8.setToolsCouplingName("FAILED 2");
        tc8.setTractor((Equipment)tractor);
        tc8.addEquipments((Equipment)tools0);
        tc8.addEquipments((Equipment)irrigStation);
        tc8.setMainsActions((Collection)mainsActions);
        Assert.assertFalse((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc8})));
        ToolsCouplingImpl tc9 = new ToolsCouplingImpl();
        tc9.setToolsCouplingName("FAILED 9");
        tc9.setTractor((Equipment)automotive);
        tc9.addEquipments((Equipment)tools0);
        tc9.addEquipments((Equipment)irrigStation);
        tc9.setMainsActions((Collection)mainsActions);
        Assert.assertFalse((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc9})));
        ToolsCouplingImpl tc10 = new ToolsCouplingImpl();
        tc10.setTractor((Equipment)automotive);
        tc10.addEquipments((Equipment)tools0);
        tc10.addEquipments((Equipment)tools1);
        tc10.setMainsActions((Collection)mainsActions);
        Assert.assertFalse((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc10})));
        ToolsCouplingImpl tc11 = new ToolsCouplingImpl();
        tc9.setToolsCouplingName("FAILED 11");
        tc11.setTractor((Equipment)automotive);
        tc11.addEquipments((Equipment)tools0);
        tc11.addEquipments((Equipment)tools1);
        Assert.assertFalse((boolean)dst.validDomainToolsCouplingsPreconditions(Lists.newArrayList((Object[])new ToolsCoupling[]{tc11})));
    }

    protected RefMateriel getAutomoteur() {
        TypeMaterielFilter filter = new TypeMaterielFilter("Porteur Viti Automoteur", "Porteur Automoteur", "120 ch");
        filter.setType(MaterielType.AUTOMOTEUR);
        Map values = this.referentialService.getMaterielUniteMap(filter);
        String firstTracteurId = (String)values.keySet().iterator().next();
        return this.referentialService.findMateriel(firstTracteurId);
    }

    protected RefMateriel getBroyeur() {
        TypeMaterielFilter filter = new TypeMaterielFilter("Broyeur", "Broyeur port\u00e9 VL", "Sarments au sol");
        filter.setType(MaterielType.OUTIL);
        Map values = this.referentialService.getMaterielUniteMap(filter);
        String firstBroyeurId = (String)values.keySet().iterator().next();
        return this.referentialService.findMateriel(firstBroyeurId);
    }

    protected RefMateriel getToolsSubsoilers() {
        TypeMaterielFilter filter = new TypeMaterielFilter("SOUS-SOLEUSES-DECOMPACTEURS", "Sous soleuse 2 corps", "port\u00e9e,");
        filter.setType(MaterielType.OUTIL);
        Map values = this.referentialService.getMaterielUniteMap(filter);
        String firstSubsoilersId = (String)values.keySet().iterator().next();
        return this.referentialService.findMateriel(firstSubsoilersId);
    }

    protected RefMateriel getTractorVigne() {
        TypeMaterielFilter filter = new TypeMaterielFilter("TRACTEURS SPECIALISES 4RM VIGNE", "Tracteurs Sp\u00e9cialis\u00e9s Vigne 4 RM avec cabine confort", "46 \u00e0 55 ch");
        filter.setType(MaterielType.TRACTEUR);
        filter.setUniteParAn(50.0);
        Map values = this.referentialService.getMaterielUniteMap(filter);
        String firstTracteurId = (String)values.keySet().iterator().next();
        return this.referentialService.findMateriel(firstTracteurId);
    }

    protected RefMateriel getIrrigEnrouleur() {
        TypeMaterielFilter filter = new TypeMaterielFilter("Enrouleurs", "Enrouleur 90 mm x 350 m", "40 m3/h");
        filter.setType(MaterielType.IRRIGATION);
        Map values = this.referentialService.getMaterielUniteMap(filter);
        String reel = (String)values.keySet().iterator().next();
        return this.referentialService.findMateriel(reel);
    }

    protected RefMateriel getIrrigStation() {
        TypeMaterielFilter filter = new TypeMaterielFilter("Station", "Forage reserve", "Forage/R\u00e9serve 50 m + racor. EDF");
        filter.setType(MaterielType.IRRIGATION);
        Map values = this.referentialService.getMaterielUniteMap(filter);
        String station = (String)values.keySet().iterator().next();
        return this.referentialService.findMateriel(station);
    }
}

