/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.entities.AgrosystTopiaDaoSupplier;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.commons.gson.AgrosystGsonSupplier;
import fr.inra.agrosyst.services.AgrosystConfigurationHelper;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultServiceFactory;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.Driver;
import org.hibernate.dialect.H2Dialect;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaTransaction;

public class TestServiceContext
implements ServiceContext {
    private static final Log log = LogFactory.getLog(TestServiceContext.class);
    protected static final Long TEST_RUN_ID = System.currentTimeMillis();
    protected Method testMethod;
    protected AgrosystTopiaPersistenceContext transaction;
    protected AgrosystTopiaApplicationContext rootContext;
    protected ServiceFactory serviceFactory;
    protected AgrosystServiceConfig config;
    protected String authenticationToken;
    protected SecurityContext securityContext;

    public TestServiceContext(Method testMethod) {
        this.testMethod = testMethod;
        this.serviceFactory = new DefaultServiceFactory((ServiceContext)this);
    }

    public ServiceContext newServiceContext() {
        return this;
    }

    public void close() {
    }

    public Date getCurrentDate() {
        return new Date();
    }

    protected File getTestSpecificDirectory() {
        String javaIoTmpDir = System.getProperty("java.io.tmpdir");
        String dataBasePath = "tests_" + TEST_RUN_ID;
        File result = new File(javaIoTmpDir, dataBasePath);
        return result;
    }

    protected String getDatabaseFilePath() {
        File directory = this.getTestSpecificDirectory();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String result = directory.getAbsolutePath() + File.separator + this.testMethod.getDeclaringClass().getName() + '_' + this.testMethod.getName();
        return result;
    }

    protected String getDatabaseMemPath() {
        String base = "tests_" + TEST_RUN_ID;
        String result = String.format("%s/%s_%s", base, this.testMethod.getDeclaringClass().getName(), this.testMethod.getName());
        return result;
    }

    public TopiaTransaction getTransaction() {
        TopiaTransaction result = this.getTransaction(true);
        return result;
    }

    public TopiaTransaction getTransaction(boolean create) {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(create);
        return result;
    }

    public AgrosystTopiaDaoSupplier getDaoSupplier() {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(true);
        return result;
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(false);
        return result;
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(create);
        return result;
    }

    public AgrosystTopiaPersistenceContext getTransaction0(boolean create) {
        Preconditions.checkState((this.rootContext != null ? 1 : 0) != 0);
        if (this.transaction == null && create) {
            this.transaction = this.rootContext.newPersistenceContext();
        }
        return this.transaction;
    }

    public <E extends AgrosystService> E newService(Class<E> clazz) {
        return (E)this.serviceFactory.newService(clazz);
    }

    public <I> I newInstance(Class<I> clazz) {
        return (I)this.serviceFactory.newInstance(clazz);
    }

    public AgrosystServiceConfig getConfig() {
        if (this.config == null) {
            this.config = new AgrosystServiceConfig("agrosyst-test.properties");
        }
        return this.config;
    }

    public void beforeEachTest() {
        Properties properties = new Properties();
        properties.setProperty("hibernate.dialect", H2Dialect.class.getName());
        properties.setProperty("hibernate.connection.driver_class", Driver.class.getName());
        String jdbcUrl = "jdbc:h2:mem:" + this.getDatabaseMemPath();
        if (log.isInfoEnabled()) {
            log.info((Object)("jdbcUrl fot the current test is: " + jdbcUrl));
        }
        properties.setProperty("hibernate.connection.url", jdbcUrl);
        properties.setProperty("hibernate.connection.username", "sa");
        properties.setProperty("hibernate.connection.password", "");
        properties.setProperty("hibernate.current_session_context_class", "thread");
        properties.setProperty("hibernate.c3p0.min_size", "5");
        properties.setProperty("hibernate.c3p0.max_size", "20");
        properties.setProperty("hibernate.c3p0.timeout", "300");
        properties.setProperty("hibernate.c3p0.max_statements", "50");
        properties.setProperty("hibernate.hbm2ddl.auto", "update");
        properties.setProperty("hibernate.show_sql", "false");
        properties.setProperty("topia.persistence.initSchema", "false");
        properties.setProperty("topia.persistence.classes", AgrosystEntityEnum.getImplementationClassesAsString());
        this.rootContext = (AgrosystTopiaApplicationContext)TopiaApplicationContextCache.getContext((Properties)properties, (Function)AgrosystConfigurationHelper.getCreateTopiaContextFunction((AgrosystServiceConfig)this.getConfig()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEachTest() {
        if (this.transaction != null && !this.transaction.isClosed()) {
            try {
                this.transaction.rollback();
            }
            finally {
                this.transaction.close();
            }
        }
        this.transaction = null;
        if (!this.rootContext.isClosed()) {
            this.rootContext.close();
        }
        this.serviceFactory = null;
        this.securityContext = null;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
        if (!Strings.isNullOrEmpty((String)authenticationToken)) {
            this.securityContext = null;
        }
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = new SecurityContext(this.getServiceFactory(), this.authenticationToken);
        }
        return this.securityContext;
    }

    public SecurityContext getSecurityContextAsUser(String userId) {
        SecurityContext securityContext = new SecurityContext(this.getServiceFactory(), this.authenticationToken, userId);
        return securityContext;
    }

    public Gson getGson() {
        return new AgrosystGsonSupplier().get();
    }
}

