/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppaTopiaDao;
import fr.inra.agrosyst.api.services.effective.CopyPasteZoneByCampaigns;
import fr.inra.agrosyst.api.services.effective.CopyPasteZoneDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.AbstractAgrosystTest;
import fr.inra.agrosyst.services.TestDatas;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.topia.persistence.TopiaException;

public class EffectiveCropCycleServiceImplTest
extends AbstractAgrosystTest {
    protected EffectiveCropCycleService effectiveCropCycleService;
    protected ReferentialService referentialService;
    protected TestDatas testDatas;
    protected DomainTopiaDao domainTopiaDao;
    protected ZoneTopiaDao zoneTopiaDao;
    protected GrowingPlanTopiaDao growingPlanDao;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected PlotTopiaDao plotTopiaDao;
    protected RefSolProfondeurIndigoTopiaDao refSolProfondeurIndigoDao;
    protected RefSolTextureGeppaTopiaDao refSolTextureGeppaDao;
    protected RefLocationTopiaDao refLocationDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionsDao;
    protected EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleDao;

    @Before
    public void setupServices() throws TopiaException {
        this.testDatas = (TestDatas)this.serviceFactory.newInstance(TestDatas.class);
        this.referentialService = (ReferentialService)this.serviceFactory.newService(ReferentialService.class);
        this.effectiveCropCycleService = (EffectiveCropCycleService)this.serviceFactory.newService(EffectiveCropCycleService.class);
        this.domainTopiaDao = this.getPersistenceContext().getDomainDao();
        this.zoneTopiaDao = this.getPersistenceContext().getZoneDao();
        this.growingPlanDao = this.getPersistenceContext().getGrowingPlanDao();
        this.growingSystemDao = this.getPersistenceContext().getGrowingSystemDao();
        this.plotTopiaDao = this.getPersistenceContext().getPlotDao();
        this.refSolProfondeurIndigoDao = this.getPersistenceContext().getRefSolProfondeurIndigoDao();
        this.refSolTextureGeppaDao = this.getPersistenceContext().getRefSolTextureGeppaDao();
        this.refLocationDao = this.getPersistenceContext().getRefLocationDao();
        this.croppingPlanEntryDao = this.getPersistenceContext().getCroppingPlanEntryDao();
        this.effectiveCropCycleNodeDao = this.getPersistenceContext().getEffectiveCropCycleNodeDao();
        this.effectiveCropCycleConnectionsDao = this.getPersistenceContext().getEffectiveCropCycleConnectionDao();
        this.effectiveSeasonalCropCycleDao = this.getPersistenceContext().getEffectiveSeasonalCropCycleDao();
        this.loginAsAdmin();
    }

    @Test
    public void testGetZonesForCopy() {
        this.createTestZones();
        CopyPasteZoneByCampaigns copyPasteZoneByCampaigns = this.effectiveCropCycleService.getAvailableZonesForCopy("ZONE_TEST_ID");
        HashMap zonesByCampaigns = copyPasteZoneByCampaigns.getZonesByCampaigns();
        List zones2014 = (List)zonesByCampaigns.get(2014);
        Assert.assertEquals((long)4L, (long)zones2014.size());
        for (CopyPasteZoneDto copyPasteZoneDto : zones2014) {
            Assert.assertTrue((boolean)copyPasteZoneDto.getZoneName().contains("OK"));
        }
    }

    @Ignore(value="TODO")
    @Test
    public void testUpdateEffectiveCropCycles() {
        this.createTestZones();
        ArrayList seasonalCropCycleDtos = Lists.newArrayList();
        ArrayList perennialCropCycleDtos = Lists.newArrayList();
        this.createEffectiveSeasonalCropCycleDto();
    }

    protected EffectiveSeasonalCropCycleDto createEffectiveSeasonalCropCycleDto() {
        EffectiveSeasonalCropCycle cycle = (EffectiveSeasonalCropCycle)this.effectiveSeasonalCropCycleDao.forTopiaIdEquals("ZONE_TEST_ID_z_OK_ESCC0").findUniqueOrNull();
        Assert.assertNotNull((Object)cycle);
        EffectiveSeasonalCropCycleDto cycleDto = new EffectiveSeasonalCropCycleDto();
        ArrayList connectionDtos = Lists.newArrayList();
        ArrayList nodeDtos = Lists.newArrayList();
        cycleDto.setConnectionDtos((List)connectionDtos);
        cycleDto.setNodeDtos((List)nodeDtos);
        return cycleDto;
    }

    public void createTestZones() {
        this.testDatas.importCommunesOsm();
        RefLocation location = (RefLocation)this.referentialService.findActiveCommunes("01500").get(0);
        Domain activeDomain = (Domain)this.domainTopiaDao.create("topiaId", (Object)"ACTIVE_DOMAIN_ID", new Object[]{"name", "ACTIVE_DOMAIN", "code", "ABCD", "campaign", 2014, "location", location, "mainContact", "INRA", "type", DomainType.DOMAINE_EXPERIMENTAL, "updateDate", new Date(), "active", true});
        Domain inactiveDomain = (Domain)this.domainTopiaDao.create("topiaId", (Object)"INACTIVE_DOMAIN_ID", new Object[]{"name", "INACTIVE_DOMAIN", "code", "ABCD", "campaign", 2015, "location", location, "mainContact", "INRA", "type", DomainType.DOMAINE_EXPERIMENTAL, "updateDate", new Date(), "active", false});
        CroppingPlanEntry cpAB = (CroppingPlanEntry)this.croppingPlanEntryDao.create("domain", (Object)activeDomain, new Object[]{"code", "CroppingPlanEntry-code-5", "name", "cpAB", "type", CroppingEntryType.CATCH});
        CroppingPlanEntry cpIAB = (CroppingPlanEntry)this.croppingPlanEntryDao.create("domain", (Object)activeDomain, new Object[]{"code", "CroppingPlanEntry-code-6", "name", "cpIAB", "type", CroppingEntryType.CATCH});
        CroppingPlanEntry cpBC = (CroppingPlanEntry)this.croppingPlanEntryDao.create("domain", (Object)activeDomain, new Object[]{"code", "CroppingPlanEntry-code-7", "name", "cpBC", "type", CroppingEntryType.CATCH});
        GrowingPlan gp = (GrowingPlan)this.growingPlanDao.create("domain", (Object)activeDomain, new Object[]{"code", UUID.randomUUID().toString(), "name", "gpName", "type", TypeDEPHY.DEPHY_EXPE, "updateDate", new Date()});
        GrowingSystem activeGrowingSystem = (GrowingSystem)this.growingSystemDao.create("name", (Object)"ACTIVE GS", new Object[]{"code", UUID.randomUUID().toString(), "growingPlan", gp, "sector", Sector.HORTICULTURE, "updateDate", new Date(), "active", true});
        GrowingSystem inactiveGrowingSystem = (GrowingSystem)this.growingSystemDao.create("name", (Object)"NON ACTIVE GS", new Object[]{"code", UUID.randomUUID().toString(), "growingPlan", gp, "sector", Sector.HORTICULTURE, "updateDate", new Date(), "active", false});
        this.testDatas.importSolProfondeurIndigo();
        RefSolProfondeurIndigo solMoyen = (RefSolProfondeurIndigo)this.refSolProfondeurIndigoDao.forNaturalId("Moyen").findUnique();
        this.testDatas.importSolTextureGeppa();
        RefSolTextureGeppa solArgileLimoneuse = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forNaturalId("Al").findUnique();
        RefSolTextureGeppa solArgiloSaleuse = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forNaturalId("AS").findUnique();
        List locations = this.refLocationDao.findAll();
        Plot activePlot1WithActiveGSAndWithActiveDomain = (Plot)this.plotTopiaDao.create("name", (Object)"Active Plot 1", new Object[]{"domain", activeDomain, "area", 34.0, "comment", "", "growingSystem", activeGrowingSystem, "latitude", -45.0, "location", locations.get(0), "longitude", -1.2, "maxSlope", MaxSlope.TWO_TO_FIVE, "bufferStrip", BufferStrip.BUFFER_STRIP_NOT_NEXT_TO_WATER_FLOW, "pacIlotNumber", 21, "waterFlowDistance", WaterFlowDistance.LESS_THAN_THREE, "code", UUID.randomUUID().toString(), "surfaceTexture", solArgileLimoneuse, "subSoilTexture", solArgiloSaleuse, "solDepth", solMoyen, "solMaxDepth", 65, "solOrganicMaterialPercent", 5.0, "active", true});
        Plot activePlotWithInactiveGSAndWithActiveDomain = (Plot)this.plotTopiaDao.create("name", (Object)"Active Plot 1 with Inactive GS", new Object[]{"domain", activeDomain, "area", 34.0, "comment", "", "growingSystem", inactiveGrowingSystem, "latitude", -45.0, "location", locations.get(0), "longitude", -1.2, "maxSlope", MaxSlope.TWO_TO_FIVE, "bufferStrip", BufferStrip.BUFFER_STRIP_NOT_NEXT_TO_WATER_FLOW, "pacIlotNumber", 21, "waterFlowDistance", WaterFlowDistance.LESS_THAN_THREE, "code", UUID.randomUUID().toString(), "surfaceTexture", solArgileLimoneuse, "subSoilTexture", solArgiloSaleuse, "solDepth", solMoyen, "solMaxDepth", 65, "solOrganicMaterialPercent", 5.0, "active", true});
        Plot activePlotWithActiveGSAndInactiveDomain = (Plot)this.plotTopiaDao.create("name", (Object)"Active Plot with Active GS and inactive domain", new Object[]{"domain", inactiveDomain, "area", 34.0, "comment", "", "growingSystem", activeGrowingSystem, "latitude", -45.0, "location", locations.get(0), "longitude", -1.2, "maxSlope", MaxSlope.TWO_TO_FIVE, "bufferStrip", BufferStrip.BUFFER_STRIP_NOT_NEXT_TO_WATER_FLOW, "pacIlotNumber", 21, "waterFlowDistance", WaterFlowDistance.LESS_THAN_THREE, "code", UUID.randomUUID().toString(), "surfaceTexture", solArgileLimoneuse, "subSoilTexture", solArgiloSaleuse, "solDepth", solMoyen, "solMaxDepth", 65, "solOrganicMaterialPercent", 5.0, "active", true});
        Plot activePlotWithInActiveGSAndInactiveDomain = (Plot)this.plotTopiaDao.create("name", (Object)"Active Plot with inactive GS and inactive domain", new Object[]{"domain", inactiveDomain, "area", 34.0, "comment", "", "growingSystem", inactiveGrowingSystem, "latitude", -45.0, "location", locations.get(0), "longitude", -1.2, "maxSlope", MaxSlope.TWO_TO_FIVE, "bufferStrip", BufferStrip.BUFFER_STRIP_NOT_NEXT_TO_WATER_FLOW, "pacIlotNumber", 21, "waterFlowDistance", WaterFlowDistance.LESS_THAN_THREE, "code", UUID.randomUUID().toString(), "surfaceTexture", solArgileLimoneuse, "subSoilTexture", solArgiloSaleuse, "solDepth", solMoyen, "solMaxDepth", 65, "solOrganicMaterialPercent", 5.0, "active", true});
        Plot activePlotWithoutGSAndWithActiveDomain = (Plot)this.plotTopiaDao.create("name", (Object)"Active Plot without GS and Active domain", new Object[]{"domain", activeDomain, "area", 36.0, "comment", "", "latitude", -45.0, "location", locations.get(0), "longitude", -1.2, "maxSlope", MaxSlope.TWO_TO_FIVE, "bufferStrip", BufferStrip.BUFFER_STRIP_NOT_NEXT_TO_WATER_FLOW, "pacIlotNumber", 21, "waterFlowDistance", WaterFlowDistance.LESS_THAN_THREE, "code", UUID.randomUUID().toString(), "surfaceTexture", solArgileLimoneuse, "subSoilTexture", solArgiloSaleuse, "solDepth", solMoyen, "solMaxDepth", 65, "solOrganicMaterialPercent", 5.0, "active", true});
        Plot activePlotWithoutGSAndWithInactiveDomain = (Plot)this.plotTopiaDao.create("name", (Object)"Active Plot without GS and inactive domain", new Object[]{"domain", inactiveDomain, "area", 37.0, "comment", "", "latitude", -45.0, "location", locations.get(0), "longitude", -1.2, "maxSlope", MaxSlope.TWO_TO_FIVE, "bufferStrip", BufferStrip.BUFFER_STRIP_NOT_NEXT_TO_WATER_FLOW, "pacIlotNumber", 21, "waterFlowDistance", WaterFlowDistance.LESS_THAN_THREE, "code", UUID.randomUUID().toString(), "surfaceTexture", solArgileLimoneuse, "subSoilTexture", solArgiloSaleuse, "solDepth", solMoyen, "solMaxDepth", 65, "solOrganicMaterialPercent", 5.0, "active", true});
        Plot inactivePlotWithActiveGSAndDomain = (Plot)this.plotTopiaDao.create("name", (Object)"Active Plot without GS and inactive domain", new Object[]{"domain", activeDomain, "area", 37.0, "comment", "", "latitude", -45.0, "location", locations.get(0), "longitude", -1.2, "maxSlope", MaxSlope.TWO_TO_FIVE, "bufferStrip", BufferStrip.BUFFER_STRIP_NOT_NEXT_TO_WATER_FLOW, "pacIlotNumber", 21, "waterFlowDistance", WaterFlowDistance.LESS_THAN_THREE, "code", UUID.randomUUID().toString(), "surfaceTexture", solArgileLimoneuse, "subSoilTexture", solArgiloSaleuse, "solDepth", solMoyen, "solMaxDepth", 65, "solOrganicMaterialPercent", 5.0, "growingSystem", activeGrowingSystem, "active", false});
        Zone z_KO_0 = (Zone)this.zoneTopiaDao.create("area", (Object)activePlot1WithActiveGSAndWithActiveDomain.getArea(), new Object[]{"topiaId", "ZONE_TEST_ID", "plot", activePlot1WithActiveGSAndWithActiveDomain, "type", ZoneType.PRINCIPALE, "name", "KO-Inactive zone", "active", false, "code", UUID.randomUUID().toString()});
        EffectiveCropCycleNode node = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cpAB});
        ArrayList nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{node});
        this.effectiveSeasonalCropCycleDao.create("zone", (Object)z_KO_0, new Object[]{"nodes", nodes});
        Zone z_OK_0 = (Zone)this.zoneTopiaDao.create("topiaId", (Object)"ZONE_TEST_ID_z_OK_0", new Object[]{"area", activePlot1WithActiveGSAndWithActiveDomain.getArea(), "plot", activePlot1WithActiveGSAndWithActiveDomain, "type", ZoneType.PRINCIPALE, "name", "OK-activePlot1WithActiveGSAndWithActiveDomain", "active", true, "code", UUID.randomUUID().toString()});
        EffectiveCropCycleNode a = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("topiaId", (Object)"ZONE_TEST_ID_z_OK_0_NodeA", new Object[]{"rank", 0, "croppingPlanEntry", cpAB});
        EffectiveCropCycleNode b = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("topiaId", (Object)"ZONE_TEST_ID_z_OK_0_NodeB", new Object[]{"rank", 1, "croppingPlanEntry", cpBC});
        EffectiveCropCycleConnection connection = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionsDao.create("topiaId", (Object)"ZONE_TEST_ID_z_OK_0_ConnectionAB", new Object[]{"source", a, "target", b, "intermediateCroppingPlanEntry", cpIAB});
        nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{a, b});
        this.effectiveSeasonalCropCycleDao.create("topiaId", (Object)"ZONE_TEST_ID_z_OK_ESCC0", new Object[]{"zone", z_OK_0, "nodes", nodes});
        Zone z_KO_1 = (Zone)this.zoneTopiaDao.create("area", (Object)activePlotWithInactiveGSAndWithActiveDomain.getArea(), new Object[]{"plot", activePlotWithInactiveGSAndWithActiveDomain, "type", ZoneType.PRINCIPALE, "name", "KO-activePlotWithInactiveGSAndWithActiveDomain", "active", true, "code", UUID.randomUUID().toString()});
        node = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cpAB});
        nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{node});
        this.effectiveSeasonalCropCycleDao.create("zone", (Object)z_KO_1, new Object[]{"nodes", nodes});
        Zone z_KO_2 = (Zone)this.zoneTopiaDao.create("area", (Object)activePlotWithActiveGSAndInactiveDomain.getArea(), new Object[]{"plot", activePlotWithActiveGSAndInactiveDomain, "type", ZoneType.PRINCIPALE, "name", "KO-activePlotWithActiveGSAndInactiveDomain", "active", true, "code", UUID.randomUUID().toString()});
        node = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cpAB});
        nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{node});
        this.effectiveSeasonalCropCycleDao.create("zone", (Object)z_KO_2, new Object[]{"nodes", nodes});
        Zone z_KO_3 = (Zone)this.zoneTopiaDao.create("area", (Object)activePlotWithInActiveGSAndInactiveDomain.getArea(), new Object[]{"plot", activePlotWithInActiveGSAndInactiveDomain, "type", ZoneType.PRINCIPALE, "name", "KO-activePlotWithInactiveGSAndInactiveDomain", "active", true, "code", UUID.randomUUID().toString()});
        node = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cpAB});
        nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{node});
        this.effectiveSeasonalCropCycleDao.create("zone", (Object)z_KO_3, new Object[]{"nodes", nodes});
        Zone z_OK_1 = (Zone)this.zoneTopiaDao.create("area", (Object)activePlotWithoutGSAndWithActiveDomain.getArea(), new Object[]{"plot", activePlotWithoutGSAndWithActiveDomain, "type", ZoneType.PRINCIPALE, "name", "OK-activePlotWithoutGSAndWithActiveDomain", "active", true, "code", UUID.randomUUID().toString()});
        a = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cpAB});
        b = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)1, new Object[]{"croppingPlanEntry", cpAB});
        nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{a, b});
        this.effectiveSeasonalCropCycleDao.create("zone", (Object)z_OK_1, new Object[]{"nodes", nodes});
        Zone z_KO_4 = (Zone)this.zoneTopiaDao.create("area", (Object)activePlotWithoutGSAndWithInactiveDomain.getArea(), new Object[]{"plot", activePlotWithoutGSAndWithInactiveDomain, "type", ZoneType.PRINCIPALE, "name", "KO-activePlotWithoutGSAndWithInactiveDomain", "active", true, "code", UUID.randomUUID().toString()});
        node = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cpAB});
        nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{node});
        this.effectiveSeasonalCropCycleDao.create("zone", (Object)z_KO_4, new Object[]{"nodes", nodes});
        Zone z_KO_5 = (Zone)this.zoneTopiaDao.create("area", (Object)inactivePlotWithActiveGSAndDomain.getArea(), new Object[]{"plot", inactivePlotWithActiveGSAndDomain, "type", ZoneType.PRINCIPALE, "name", "KO-inactivePlotWithActiveGSAndDomain", "active", true, "code", UUID.randomUUID().toString()});
        node = (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create("rank", (Object)0, new Object[]{"croppingPlanEntry", cpAB});
        nodes = Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{node});
        this.effectiveSeasonalCropCycleDao.create("zone", (Object)z_KO_5, new Object[]{"nodes", nodes});
    }
}

