/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.TestServiceContext;
import java.lang.reflect.Method;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class AgrosystMethodRule
implements MethodRule {
    protected TestServiceContext serviceContext;

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        Method testMethod = method.getMethod();
        TestServiceContext testServiceContext = new TestServiceContext(testMethod);
        AgrosystTestStatement statement = new AgrosystTestStatement(testServiceContext, base);
        this.serviceContext = testServiceContext;
        return statement;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceContext.getServiceFactory();
    }

    public static class AgrosystTestStatement
    extends Statement {
        protected TestServiceContext testServiceContext;
        protected Statement base;

        public AgrosystTestStatement(TestServiceContext testServiceContext, Statement base) {
            this.testServiceContext = testServiceContext;
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            this.testServiceContext.beforeEachTest();
            try {
                this.base.evaluate();
            }
            finally {
                this.testServiceContext.afterEachTest();
            }
        }
    }
}

