/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRoleTopiaDao;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.services.AgrosystMethodRule;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.TestServiceContext;
import org.junit.Before;
import org.junit.Rule;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaTransaction;

public abstract class AbstractAgrosystTest {
    @Rule
    public AgrosystMethodRule methodRule = new AgrosystMethodRule();
    protected ServiceFactory serviceFactory;
    @Deprecated
    protected ServiceContext serviceContext;

    @Before
    public void setupServiceFactory() {
        this.serviceContext = this.methodRule.getServiceContext();
        this.serviceFactory = this.methodRule.getServiceFactory();
    }

    protected TopiaTransaction getCurrentTransaction() {
        return this.serviceContext.getTransaction();
    }

    public TopiaDaoSupplier getDaoSupplier() {
        return this.serviceContext.getDaoSupplier();
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        return this.serviceContext.getPersistenceContext();
    }

    public AgrosystServiceConfig getConfig() {
        return this.serviceContext.getConfig();
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        return this.serviceContext.getPersistenceContext(create);
    }

    protected UserDto loginUser(String login, String password) {
        AuthenticationService authenticationService = (AuthenticationService)this.serviceFactory.newService(AuthenticationService.class);
        UserDto authUser = authenticationService.login(login, password);
        ((TestServiceContext)this.serviceContext).setAuthenticationToken(authUser.getAuthenticationToken());
        return authUser;
    }

    protected void loginAsAdmin() {
        AgrosystUserTopiaDao userTopiaDao = this.getPersistenceContext(true).getAgrosystUserDao();
        if (!userTopiaDao.forEmailEquals("admin@test.fr").tryFindAny().isPresent()) {
            UserService userService = (UserService)this.serviceFactory.newService(UserService.class);
            UserDto user = new UserDto();
            user.setActive(true);
            user.setEmail("admin@test.fr");
            user.setFirstName("Admin");
            user.setLastName("Test");
            user = userService.createUser(user, "azerty");
            AgrosystUser userEntity = (AgrosystUser)userTopiaDao.forTopiaIdEquals(user.getTopiaId()).findUnique();
            UserRoleTopiaDao userRoleTopiaDao = this.getPersistenceContext().getUserRoleDao();
            userRoleTopiaDao.create("agrosystUser", (Object)userEntity, new Object[]{"type", RoleType.ADMIN});
        }
        this.loginUser("admin@test.fr", "azerty");
    }
}

