/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.referential.ReferentialEntity;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class AgrosystModelTest {
    private static final Log log = LogFactory.getLog(AgrosystModelTest.class);

    @Test
    public void testReferentialNaturalId() throws IOException {
        for (AgrosystEntityEnum entityEnum : AgrosystEntityEnum.values()) {
            Class entityClass = entityEnum.getImplementation();
            if (!ReferentialEntity.class.isAssignableFrom(entityClass)) continue;
            if (Modifier.isAbstract(entityClass.getModifiers())) {
                log.debug((Object)"Skip natural-id check, defined on abstract class");
                continue;
            }
            if (entityClass.getSuperclass().getInterfaces()[0].getInterfaces().length == 1) {
                log.debug((Object)"Skip natural-id check, defined on super class");
                continue;
            }
            String mapping = "/" + entityClass.getPackage().getName().replace('.', '/') + "/" + entityClass.getSimpleName() + ".hbm.xml";
            InputStream entityMapping = AgrosystModelTest.class.getResourceAsStream(mapping);
            String content = IOUtils.toString((InputStream)entityMapping);
            if (!content.contains("natural-id")) {
                log.warn((Object)("La classe " + entityClass.getName() + " n'a pas de contraintes de natural-id"));
            }
            Assert.assertTrue((String)("La classe " + entityClass.getName() + " n'a pas de contraintes de natural id"), (boolean)content.contains("natural-id"));
        }
    }
}

