package fr.inra.agrosyst.services.users;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: UserImportModel.java 3645 2014-03-06 16:21:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/users/UserImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

/**
 * Modele d'import des utilisateurs.
 * 
 * <ul>
 * <li>Nom
 * <li>Prenom
 * <li>Mail
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class UserImportModel extends AbstractAgrosystModel<AgrosystUser> {

    public UserImportModel() {
        super(';');
        newMandatoryColumn("email", AgrosystUser.PROPERTY_EMAIL);
        newMandatoryColumn("prenom", AgrosystUser.PROPERTY_FIRST_NAME);
        newMandatoryColumn("nom", AgrosystUser.PROPERTY_LAST_NAME);
        newMandatoryColumn("organisation", AgrosystUser.PROPERTY_ORGANISATION);
        newMandatoryColumn("tele", AgrosystUser.PROPERTY_PHONE_NUMBER);
    }

    @Override
    public AgrosystUser newEmptyInstance() {
        return new AgrosystUserImpl();
    }
}
