package fr.inra.agrosyst.services.security;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: UserRolesImportModel.java 3571 2014-03-03 15:23:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/security/UserRolesImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;
import fr.inra.agrosyst.services.security.ImportUserRoleDto;

/**
 * Created by davidcosse on 24/02/14.
 */
public class UserRolesImportModel extends AbstractAgrosystModel<ImportUserRoleDto> {

    public UserRolesImportModel() {
        super(';');

        newMandatoryColumn("email", "userEmail");
        newMandatoryColumn("role", "type", ROLE_TYPE_PARSER);
        newMandatoryColumn("entity", "targetedEntity");
        newMandatoryColumn("campaign", "campaign", INTEGER_WITH_NULL_PARSER);
    }

    @Override
    public ImportUserRoleDto newEmptyInstance() {
        return new ImportUserRoleDto();
    }
}
