package fr.inra.agrosyst.services.security;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: SecurityContext.java 3398 2014-02-21 14:29:05Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/security/SecurityContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.api.services.security.AuthorizationService;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class SecurityContext {

    protected ServiceFactory serviceFactory;

    protected String authenticationToken;
    protected String doAsUserId;

    // transient because can be recomputed at any time
    protected transient AuthorizationService authorizationService;
    protected transient Boolean admin;
    protected transient String userId;

    public SecurityContext(ServiceFactory serviceFactory, String authenticationToken) {
        this.serviceFactory = serviceFactory;
        this.authenticationToken = authenticationToken;
    }

    public SecurityContext(ServiceFactory serviceFactory, String authenticationToken, String doAsUserId) {
        this.serviceFactory = serviceFactory;
        this.authenticationToken = authenticationToken;
        this.doAsUserId = doAsUserId;
    }

    protected AuthorizationService getAuthorizationService() {
        if (authorizationService == null) {
            authorizationService = serviceFactory.newService(AuthorizationService.class);
        }
        return authorizationService;
    }

    public boolean isAdmin() {
        if (admin == null) {
            admin = getAuthorizationService().isAdmin(authenticationToken);
        }
        return admin;
    }

    public String getUserId() {
        if (userId == null) {
            if (Strings.isNullOrEmpty(doAsUserId)) {
                userId = getAuthorizationService().checkComputedPermissions(authenticationToken);
            } else {
                userId = getAuthorizationService().checkComputedPermissions(authenticationToken, doAsUserId);
            }
        }
        return userId;
    }

    public String getAuthenticationToken() {
        return authenticationToken;
    }

}
