package fr.inra.agrosyst.services.referential.csv.iphy;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefRcesuRunoffPotRulesParcModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/iphy/RefRcesuRunoffPotRulesParcModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.ParseException;

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParc;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParcImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

/**
 * Id règle;Soil texture;Slope;battance;hydromorphisms;Runoff potential
 * 
 * @author Eric Chatellier
 */
public class RefRcesuRunoffPotRulesParcModel extends AbstractAgrosystModel<RefRcesuRunoffPotRulesParc> implements ExportModel<RefRcesuRunoffPotRulesParc> {

    protected static final ValueParser<MaxSlope> MAX_SLOPE_PARSER = new ValueParser<MaxSlope>() {
        @Override
        public MaxSlope parse(String value) throws ParseException {
            MaxSlope result;
            if ("0%".equals(value)) {
                result = MaxSlope.ZERO;
            } else if ("0-2%".equals(value)) {
                result = MaxSlope.ZERO_TO_TWO;
            } else if ("2-5%".equals(value)) {
                result = MaxSlope.TWO_TO_FIVE;
            } else {
                // >5%
                result = MaxSlope.MORE_THAN_FIVE;
            }
            return result;
        }
    };

    protected static final ValueFormatter<MaxSlope> MAX_SLOPE_FORMATTER = new ValueFormatter<MaxSlope>() {
        @Override
        public String format(MaxSlope value) {
            String result;
            switch (value) {
            case ZERO:
                result = "0%";
                break;
            case ZERO_TO_TWO:
                result = "0-2%";
                break;
            case TWO_TO_FIVE:
                result = "2-5%";
                break;
            default:
                result = ">5%";
            }
            return result;
        }
    };

    protected static final ValueParser<Boolean> OUI_NON_PARSER = new ValueParser<Boolean>() {
        @Override
        public Boolean parse(String value) throws ParseException {
            boolean result = "oui".equalsIgnoreCase(value);
            return result;
        }
    };

    protected static final ValueFormatter<Boolean> OUI_NON_FORMATTER = new ValueFormatter<Boolean>() {
        @Override
        public String format(Boolean value) {
            String result = value != null && value ? "oui" : "non";
            return result;
        }
    };

    public RefRcesuRunoffPotRulesParcModel() {
        super(';');
        newMandatoryColumn("Id règle", RefRcesuRunoffPotRulesParc.PROPERTY_ID_REGLE, INT_PARSER);
        newMandatoryColumn("Soil texture", RefRcesuRunoffPotRulesParc.PROPERTY_SOIL_TEXTURE);
        newMandatoryColumn("Slope", RefRcesuRunoffPotRulesParc.PROPERTY_SLOPE, MAX_SLOPE_PARSER);
        newMandatoryColumn("battance", RefRcesuRunoffPotRulesParc.PROPERTY_BATTANCE, OUI_NON_PARSER);
        newMandatoryColumn("hydromorphisms", RefRcesuRunoffPotRulesParc.PROPERTY_HYDROMORPHISMS, OUI_NON_PARSER);
        newMandatoryColumn("Runoff potential", RefRcesuRunoffPotRulesParc.PROPERTY_RUNOFF_POTENTIAL, DOUBLE_PARSER);
    }

    @Override
    public RefRcesuRunoffPotRulesParc newEmptyInstance() {
        RefRcesuRunoffPotRulesParc result = new RefRcesuRunoffPotRulesParcImpl();
        return result;
    }

    @Override
    public Iterable<ExportableColumn<RefRcesuRunoffPotRulesParc, Object>> getColumnsForExport() {
        ModelBuilder<RefRcesuRunoffPotRulesParc> modelBuilder = new ModelBuilder<RefRcesuRunoffPotRulesParc>();
        modelBuilder.newColumnForExport("Id règle", RefRcesuRunoffPotRulesParc.PROPERTY_ID_REGLE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("Soil texture", RefRcesuRunoffPotRulesParc.PROPERTY_SOIL_TEXTURE);
        modelBuilder.newColumnForExport("Slope", RefRcesuRunoffPotRulesParc.PROPERTY_SLOPE, MAX_SLOPE_FORMATTER);
        modelBuilder.newColumnForExport("battance", RefRcesuRunoffPotRulesParc.PROPERTY_BATTANCE, OUI_NON_FORMATTER);
        modelBuilder.newColumnForExport("hydromorphisms", RefRcesuRunoffPotRulesParc.PROPERTY_HYDROMORPHISMS, OUI_NON_FORMATTER);
        modelBuilder.newColumnForExport("Runoff potential", RefRcesuRunoffPotRulesParc.PROPERTY_RUNOFF_POTENTIAL, DOUBLE_FORMATTER);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
