package fr.inra.agrosyst.services.referential.csv.iphy;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefRcesoRulesGroundWaterModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/iphy/RefRcesoRulesGroundWaterModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWaterImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

/**
 * CaseNumber;Rule_Number;FSet_OrgC;FSet_Depth;FSet_KOC;FSet_DT50;z.
 * 
 * @author Eric Chatellier
 */
public class RefRcesoRulesGroundWaterModel extends AbstractAgrosystModel<RefRcesoRulesGroundWater> implements ExportModel<RefRcesoRulesGroundWater> {

    public RefRcesoRulesGroundWaterModel() {
        super(';');
        newMandatoryColumn("CaseNumber", RefRcesoRulesGroundWater.PROPERTY_CASE_NUMBER, INT_PARSER);
        newMandatoryColumn("Rule_Number", RefRcesoRulesGroundWater.PROPERTY_RULE_NUMBER, INT_PARSER);
        newMandatoryColumn("FSet_OrgC", RefRcesoRulesGroundWater.PROPERTY_FSET_ORGC);
        newMandatoryColumn("FSet_Depth", RefRcesoRulesGroundWater.PROPERTY_FSET_DEPTH);
        newMandatoryColumn("FSet_KOC", RefRcesoRulesGroundWater.PROPERTY_FSET_KOC);
        newMandatoryColumn("FSet_DT50", RefRcesoRulesGroundWater.PROPERTY_FSET_DT50);
        newMandatoryColumn("z", RefRcesoRulesGroundWater.PROPERTY_Z, DOUBLE_PARSER);
    }

    @Override
    public RefRcesoRulesGroundWater newEmptyInstance() {
        RefRcesoRulesGroundWater result = new RefRcesoRulesGroundWaterImpl();
        return result;
    }

    @Override
    public Iterable<ExportableColumn<RefRcesoRulesGroundWater, Object>> getColumnsForExport() {
        ModelBuilder<RefRcesoRulesGroundWater> modelBuilder = new ModelBuilder<RefRcesoRulesGroundWater>();
        modelBuilder.newColumnForExport("Climate", RefRcesoCaseGroundWater.PROPERTY_CLIMATE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("ApplicationPeriod", RefRcesoCaseGroundWater.PROPERTY_APPLICATION_PERIOD);
        modelBuilder.newColumnForExport("Surface Texture", RefRcesoCaseGroundWater.PROPERTY_SURFACE_TEXTURE);
        modelBuilder.newColumnForExport("SubSoil_Texture", RefRcesoCaseGroundWater.PROPERTY_SUBSOIL_TEXTURE);
        modelBuilder.newColumnForExport("CaseNumber", RefRcesoCaseGroundWater.PROPERTY_CASE_NUMBER, INTEGER_FORMATTER);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
