package fr.inra.agrosyst.services.referential.csv.iphy;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefRcesoFuzzySetGroundWaterModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/iphy/RefRcesoFuzzySetGroundWaterModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWaterImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

/**
 * CaseNumber;Variables;FussySet;sigma;c.
 * 
 * @author Eric Chatellier
 */
public class RefRcesoFuzzySetGroundWaterModel extends AbstractAgrosystModel<RefRcesoFuzzySetGroundWater> implements ExportModel<RefRcesoFuzzySetGroundWater> {

    public RefRcesoFuzzySetGroundWaterModel() {
        super(';');
        newMandatoryColumn("CaseNumber", RefRcesoFuzzySetGroundWater.PROPERTY_CASE_NUMBER, INT_PARSER);
        newMandatoryColumn("Variables", RefRcesoFuzzySetGroundWater.PROPERTY_VARIABLES);
        newMandatoryColumn("FussySet", RefRcesoFuzzySetGroundWater.PROPERTY_FUZZY_SET);
        newMandatoryColumn("sigma", RefRcesoFuzzySetGroundWater.PROPERTY_SIGMA, DOUBLE_PARSER);
        newMandatoryColumn("c", RefRcesoFuzzySetGroundWater.PROPERTY_C, DOUBLE_PARSER);
    }

    @Override
    public RefRcesoFuzzySetGroundWater newEmptyInstance() {
        RefRcesoFuzzySetGroundWater result = new RefRcesoFuzzySetGroundWaterImpl();
        return result;
    }

    @Override
    public Iterable<ExportableColumn<RefRcesoFuzzySetGroundWater, Object>> getColumnsForExport() {
        ModelBuilder<RefRcesoFuzzySetGroundWater> modelBuilder = new ModelBuilder<RefRcesoFuzzySetGroundWater>();
        modelBuilder.newColumnForExport("CaseNumber", RefRcesoFuzzySetGroundWater.PROPERTY_CASE_NUMBER, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("Variables", RefRcesoFuzzySetGroundWater.PROPERTY_VARIABLES);
        modelBuilder.newColumnForExport("FussySet", RefRcesoFuzzySetGroundWater.PROPERTY_FUZZY_SET);
        modelBuilder.newColumnForExport("sigma", RefRcesoFuzzySetGroundWater.PROPERTY_SIGMA, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("c", RefRcesoFuzzySetGroundWater.PROPERTY_C, DOUBLE_FORMATTER);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
