package fr.inra.agrosyst.services.referential.csv.iphy;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefRcesoCaseGroundWaterModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/iphy/RefRcesoCaseGroundWaterModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWaterImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

/**
 * Climate;ApplicationPeriod;Surface Texture;SubSoil_Texture;CaseNumber.
 * 
 * @author Eric Chatellier
 */
public class RefRcesoCaseGroundWaterModel extends AbstractAgrosystModel<RefRcesoCaseGroundWater> implements ExportModel<RefRcesoCaseGroundWater> {

    public RefRcesoCaseGroundWaterModel() {
        super(';');
        newMandatoryColumn("Climate", RefRcesoCaseGroundWater.PROPERTY_CLIMATE, INT_PARSER);
        newMandatoryColumn("ApplicationPeriod", RefRcesoCaseGroundWater.PROPERTY_APPLICATION_PERIOD);
        newMandatoryColumn("Surface Texture", RefRcesoCaseGroundWater.PROPERTY_SURFACE_TEXTURE);
        newMandatoryColumn("SubSoil_Texture", RefRcesoCaseGroundWater.PROPERTY_SUBSOIL_TEXTURE);
        newMandatoryColumn("CaseNumber", RefRcesoCaseGroundWater.PROPERTY_CASE_NUMBER, INT_PARSER);
    }

    @Override
    public RefRcesoCaseGroundWater newEmptyInstance() {
        RefRcesoCaseGroundWater result = new RefRcesoCaseGroundWaterImpl();
        return result;
    }

    @Override
    public Iterable<ExportableColumn<RefRcesoCaseGroundWater, Object>> getColumnsForExport() {
        ModelBuilder<RefRcesoCaseGroundWater> modelBuilder = new ModelBuilder<RefRcesoCaseGroundWater>();
        modelBuilder.newColumnForExport("Climate", RefRcesoCaseGroundWater.PROPERTY_CLIMATE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("ApplicationPeriod", RefRcesoCaseGroundWater.PROPERTY_APPLICATION_PERIOD);
        modelBuilder.newColumnForExport("Surface Texture", RefRcesoCaseGroundWater.PROPERTY_SURFACE_TEXTURE);
        modelBuilder.newColumnForExport("SubSoil_Texture", RefRcesoCaseGroundWater.PROPERTY_SUBSOIL_TEXTURE);
        modelBuilder.newColumnForExport("CaseNumber", RefRcesoCaseGroundWater.PROPERTY_CASE_NUMBER, INTEGER_FORMATTER);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
