package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: SolsArvalisRegionsModel.java 3571 2014-03-03 15:23:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/SolsArvalisRegionsModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

public class SolsArvalisRegionsModel extends AbstractAgrosystModel<RegionDto> {

    public SolsArvalisRegionsModel() {
        super(';');

        newMandatoryColumn("sol_region text,", RegionDto.PROPERTY_NAME);
        newMandatoryColumn("Région", RegionDto.PROPERTY_CODE, INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("Source", RegionDto.PROPERTY_SOURCE);
    }

    @Override
    public RegionDto newEmptyInstance() {
        return new RegionDto();
    }

}
