package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefZoneClimatiqueIphyModel.java 3270 2014-02-17 11:08:03Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefZoneClimatiqueIphyModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphy;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphy;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphyImpl;

/**
 * Référentiel Acta substance active.
 * 
 * departement;zone_climatique
 */
public class RefZoneClimatiqueIphyModel extends AbstractAgrosystModel<RefZoneClimatiqueIphy> implements ExportModel<RefZoneClimatiqueIphy> {

    public RefZoneClimatiqueIphyModel() {
        super(';');

        newMandatoryColumn("departement", RefZoneClimatiqueIphy.PROPERTY_DEPARTEMENT);
        newMandatoryColumn("zone_climatique", RefZoneClimatiqueIphy.PROPERTY_ZONE_CLIMATIQUE, INT_PARSER);
    }

    @Override
    public Iterable<ExportableColumn<RefZoneClimatiqueIphy, Object>> getColumnsForExport() {
        ModelBuilder<RefPhytoSubstanceActiveIphy> modelBuilder = new ModelBuilder<RefPhytoSubstanceActiveIphy>();
        modelBuilder.newColumnForExport("departement", RefZoneClimatiqueIphy.PROPERTY_DEPARTEMENT);
        modelBuilder.newColumnForExport("zone_climatique", RefZoneClimatiqueIphy.PROPERTY_ZONE_CLIMATIQUE, INTEGER_FORMATTER);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefZoneClimatiqueIphy newEmptyInstance() {
        return new RefZoneClimatiqueIphyImpl();
    }
}
