package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefVarietePlantGrapeModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefVarietePlantGrapeModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrapeImpl;

public class RefVarietePlantGrapeModel extends AbstractAgrosystModel<RefVarietePlantGrape> implements ExportModel<RefVarietePlantGrape> {

    public RefVarietePlantGrapeModel() {
        super(';');
        newMandatoryColumn("CodeVar", RefVarietePlantGrape.PROPERTY_CODE_VAR, INT_PARSER);
        newMandatoryColumn("Variete", RefVarietePlantGrape.PROPERTY_VARIETE);
        newMandatoryColumn("Utilisation", RefVarietePlantGrape.PROPERTY_UTILISATION);
        newMandatoryColumn("Couleur", RefVarietePlantGrape.PROPERTY_COULEUR);
        newMandatoryColumn("source", RefVarietePlantGrape.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefVarietePlantGrape, Object>> getColumnsForExport() {
        ModelBuilder<RefVarietePlantGrape> modelBuilder = new ModelBuilder<RefVarietePlantGrape>();
        
        modelBuilder.newColumnForExport("CodeVar", RefVarietePlantGrape.PROPERTY_CODE_VAR, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("Variete", RefVarietePlantGrape.PROPERTY_VARIETE);
        modelBuilder.newColumnForExport("Utilisation", RefVarietePlantGrape.PROPERTY_UTILISATION);
        modelBuilder.newColumnForExport("Couleur", RefVarietePlantGrape.PROPERTY_COULEUR);
        modelBuilder.newColumnForExport("source", RefVarietePlantGrape.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefVarietePlantGrape newEmptyInstance() {
        RefVarietePlantGrapeImpl result = new RefVarietePlantGrapeImpl();
        return result;
    }
}
